/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.message;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import miworkplace.i18n.Messages;
import miworkplace.ui.message.MessageRetrievalInfoProvider;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;

public class RetrieverThreadStatusControl {
    @Inject
    private IResourcePool imagePool;
    private CLabel label;
    private MessageRetrievalInfoProvider infoProvider;

    @Inject
    public RetrieverThreadStatusControl(Composite parent, IResourcePool imagePool) {
        parent.setLayout((Layout)new FillLayout(256));
        this.label = new CLabel(parent, 0x1000000);
        this.label.setImage(imagePool.getImageUnchecked("IMAGE_JOBS_DISABLED"));
        this.label.setToolTipText(Messages.common_notactive);
    }

    @PostConstruct
    private void postConstruct(MPart part) {
        this.infoProvider = (MessageRetrievalInfoProvider)part.getObject();
    }

    @Inject
    @Optional
    public void notifiedThreadStart(@UIEventTopic(value="miworkplace/ui/message/thread/start") Event event) {
        if (this.infoProvider.getJob().toString().equals(event.getProperty("job")) && this.infoProvider.getConnection().getName().equals(event.getProperty("connection")) && !this.label.isDisposed()) {
            this.label.setImage(this.imagePool.getImageUnchecked("IMAGE_JOBS"));
            this.label.setToolTipText(Messages.common_active);
            this.label.update();
        }
    }

    @Inject
    @Optional
    public void notifiedThreadStop(@UIEventTopic(value="miworkplace/ui/message/thread/stop") Event event) {
        if (this.infoProvider.getJob().toString().equals(event.getProperty("job")) && this.infoProvider.getConnection().getName().equals(event.getProperty("connection")) && !this.label.isDisposed()) {
            this.label.setImage(this.imagePool.getImageUnchecked("IMAGE_JOBS_DISABLED"));
            this.label.setToolTipText(Messages.common_notactive);
            this.label.update();
        }
    }
}

