/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.message;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import miworkplace.i18n.Messages;
import miworkplace.ui.message.JobLogMessage;
import miworkplace.ui.message.JobLogMessageProperty;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MessageDetailsView {
    private Composite noJobSelectedLabel;
    private TableViewer viewer;
    private StackLayout mainLayout;
    private Composite parentComposite;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ISelectionListener viewSelectionListener = new ViewSelectionListener();
    public static final String VIEW_ID = "miworkplace.ui.message.details";

    @PostConstruct
    public void postConstruct(Composite parent, ESelectionService selectionService) {
        this.parentComposite = parent;
        this.mainLayout = new StackLayout();
        parent.setLayout((Layout)this.mainLayout);
        this.noJobSelectedLabel = this.buildNoJobSelectedLabel(parent);
        this.viewer = this.buildTableViewer(parent);
        selectionService.addSelectionListener(this.viewSelectionListener);
        if (selectionService.getSelection() != null && selectionService.getSelection() instanceof JobLogMessage) {
            this.viewer.setInput(selectionService.getSelection());
        }
        this.showComponents(selectionService.getSelection());
    }

    @PreDestroy
    public void preDestroy(ESelectionService selectionService) {
        selectionService.removeSelectionListener(this.viewSelectionListener);
    }

    private TableViewer buildTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 776);
        viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.configureTableColumns(viewer);
        viewer.getTable().setLinesVisible(true);
        viewer.getTable().setHeaderVisible(false);
        return viewer;
    }

    private void configureTableColumns(TableViewer viewer) {
        Table table = viewer.getTable();
        TableColumn col1 = new TableColumn(table, 16384);
        col1.setWidth(150);
        TableColumn col2 = new TableColumn(table, 16384);
        col2.setWidth(150);
    }

    private void showComponents(Object message) {
        if (message != null && message instanceof JobLogMessage) {
            this.mainLayout.topControl = this.viewer.getControl();
            this.parentComposite.layout();
            return;
        }
        this.mainLayout.topControl = this.noJobSelectedLabel;
        this.parentComposite.layout();
    }

    private Composite buildNoJobSelectedLabel(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Form form = toolkit.createForm(parent);
        RowLayout layout = new RowLayout();
        form.getBody().setLayout((Layout)layout);
        toolkit.createLabel(form.getBody(), Messages.ui_message_details_noselected);
        return form;
    }

    private String arrayToString(Object[] array) {
        StringBuilder sb = new StringBuilder();
        if (array != null) {
            if (array.length == 1) {
                sb.append(array[0].toString());
            } else {
                int i = 0;
                while (i < array.length) {
                    sb.append(array[i].toString());
                    if (i < array.length - 1) {
                        sb.append(", ");
                    }
                    ++i;
                }
            }
        }
        return sb.toString();
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof JobLogMessage) {
                return this.buildJobLogMessageProperties((JobLogMessage)inputElement);
            }
            return new Object[0];
        }

        private Object[] buildJobLogMessageProperties(JobLogMessage message) {
            ArrayList<JobLogMessageProperty> properties = new ArrayList<JobLogMessageProperty>();
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_id, message.id));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_severity, message.severity.toString()));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_type, message.type));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_date, MessageDetailsView.this.dateFormat.format(message.date.getTime())));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_from_lib, message.fromLibrary));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_from_pgm, message.fromProgram));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_from_mod, message.fromModule));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_from_proc, message.fromProcedure));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_from_stm, MessageDetailsView.this.arrayToString(message.fromStatement)));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_to_lib, message.toLibrary));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_to_pgm, message.toProgram));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_to_mod, message.toModule));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_to_proc, message.toProcedure));
            properties.add(new JobLogMessageProperty(Messages.ui_message_details_row_to_stm, MessageDetailsView.this.arrayToString(message.toStatement)));
            ListIterator iterator = properties.listIterator();
            while (iterator.hasNext()) {
                if (!StringUtils.isEmpty((CharSequence)((JobLogMessageProperty)iterator.next()).value)) continue;
                iterator.remove();
            }
            return properties.toArray(new JobLogMessageProperty[properties.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof JobLogMessage) {
                MessageDetailsView.this.showComponents(newInput);
            }
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            JobLogMessageProperty property = (JobLogMessageProperty)element;
            return columnIndex == 0 ? property.name : property.value;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class ViewSelectionListener
    implements ISelectionListener {
        ViewSelectionListener() {
        }

        public void selectionChanged(MPart part, Object selection) {
            if (selection instanceof IStructuredSelection) {
                Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
                if (selectedElement instanceof JobLogMessage) {
                    MessageDetailsView.this.viewer.setInput(selectedElement);
                }
            } else if (selection instanceof JobLogMessage) {
                MessageDetailsView.this.viewer.setInput(selection);
            }
        }
    }
}

