/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.IJobFilterService;
import miworkplace.ui.api.JobFilter;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class JobListRetriever
implements Runnable {
    private final JobFilter filter;
    private final Debug logger = Debug.getInstance();
    private final EventAdmin eventAdmin;
    private IConnection connection;
    private IJobFilterService jobFilterService;

    public JobListRetriever(IConnection connection, JobFilter filter, EventAdmin eventAdmin, IJobFilterService jobFilterService) {
        this.connection = connection;
        this.filter = filter;
        this.eventAdmin = eventAdmin;
        this.jobFilterService = jobFilterService;
    }

    @Override
    public void run() {
        block29: {
            this.logger.info((Option)miworkplace.ui.debug.Option.job, "Retrieving job list for filter " + this.filter.name);
            if (!this.connection.isConnected()) {
                return;
            }
            JobList jobList = new JobList(this.connection.getSystem());
            try {
                jobList.clearJobSelectionCriteria();
                if (this.filter.selectionJobName != null) {
                    jobList.addJobSelectionCriteria(1, (Object)this.filter.selectionJobName);
                }
                if (this.filter.selectionJobQueue != null) {
                    jobList.addJobSelectionCriteria(12, (Object)this.filter.selectionJobQueue);
                }
                if (this.filter.selectionJobQueueStatus != null) {
                    switch (this.filter.selectionJobQueueStatus) {
                        case Held: {
                            jobList.addJobSelectionCriteria(10, (Object)Boolean.TRUE);
                            break;
                        }
                        case Ready: {
                            jobList.addJobSelectionCriteria(11, (Object)Boolean.TRUE);
                        }
                    }
                }
                if (this.filter.selectionJobType != null) {
                    switch (this.filter.selectionJobType) {
                        case Autostart: {
                            jobList.addJobSelectionCriteria(4, (Object)"A");
                            break;
                        }
                        case Batch: {
                            jobList.addJobSelectionCriteria(4, (Object)"B");
                            break;
                        }
                        case Interactive: {
                            jobList.addJobSelectionCriteria(4, (Object)"I");
                        }
                    }
                }
                if (this.filter.selectionStatus != null) {
                    switch (this.filter.selectionStatus) {
                        case Active: {
                            jobList.addJobSelectionCriteria(5, (Object)Boolean.TRUE);
                            jobList.addJobSelectionCriteria(6, (Object)Boolean.FALSE);
                            jobList.addJobSelectionCriteria(7, (Object)Boolean.FALSE);
                            break;
                        }
                        case JobQueue: {
                            jobList.addJobSelectionCriteria(5, (Object)Boolean.FALSE);
                            jobList.addJobSelectionCriteria(6, (Object)Boolean.TRUE);
                            jobList.addJobSelectionCriteria(7, (Object)Boolean.FALSE);
                            break;
                        }
                        case OutQueue: {
                            jobList.addJobSelectionCriteria(5, (Object)Boolean.FALSE);
                            jobList.addJobSelectionCriteria(6, (Object)Boolean.FALSE);
                            jobList.addJobSelectionCriteria(7, (Object)Boolean.TRUE);
                        }
                    }
                }
                if (this.filter.selectionUserName != null) {
                    jobList.addJobSelectionCriteria(2, (Object)this.filter.selectionUserName);
                }
                if (this.filter.selectionCurrentUserName != null) {
                    jobList.addJobSelectionCriteria(13, (Object)this.filter.selectionCurrentUserName);
                }
                jobList.addJobAttributeToRetrieve(101);
                jobList.addJobAttributeToRetrieve(1004);
                jobList.addJobAttributeToRetrieve(1903);
                jobList.addJobAttributeToRetrieve(11003);
                jobList.addJobAttributeToRetrieve(1906);
                jobList.load();
                ArrayList<Job> jobs = new ArrayList<Job>();
                Enumeration jobsEnumeration = jobList.getJobs();
                while (jobsEnumeration.hasMoreElements()) {
                    try {
                        Job job = (Job)jobsEnumeration.nextElement();
                        if (this.filter.selectionSubsystem != null) {
                            if (!job.getSubsystem().toLowerCase().contains(this.filter.selectionSubsystem.toLowerCase())) continue;
                            jobs.add(job);
                            continue;
                        }
                        jobs.add(job);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        break;
                    }
                }
                this.jobFilterService.setJobs(this.filter, jobs);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("filter", this.filter);
                data.put("jobs", jobs);
                this.eventAdmin.sendEvent(new Event("miworkplace/ui/jobs/listretrieved", data));
            }
            catch (ConnectionDroppedException connectionDroppedException) {
            }
            catch (Exception e) {
                this.logger.error((Option)miworkplace.ui.debug.Option.job, "Could not get job list for filter " + String.valueOf(this.filter), (Throwable)e);
                if (Display.getDefault().getThread() != Thread.currentThread()) break block29;
                Notifier.error((String)Messages.ui_jobs_filter, (String)(String.format(Messages.ui_jobs_cld_not_load, this.filter.name) + System.lineSeparator() + e.getMessage()));
            }
        }
    }
}

