/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import com.ibm.as400.access.Job;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.extra.xstream.XStream;
import miworkplace.ui.Constants;
import miworkplace.ui.api.IJobFilterService;
import miworkplace.ui.api.JobFilter;
import miworkplace.ui.jobs.JobListRetriever;
import miworkplace.ui.jobs.JobListRetrieverThread;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class JobFilterService
implements IJobFilterService {
    private Map<JobFilter, List<Job>> jobs = new HashMap<JobFilter, List<Job>>();
    private Debug logger = Debug.getInstance();
    private EventAdmin eventAdmin;
    private IConnectionManager connectionManager;
    private IPath bundleStateLocation;
    private int retrievalInterval = 60;
    private JobListRetrieverThread retrieverThread;

    void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    void unbindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    void bindConnectionManager(IConnectionManager service) {
        this.connectionManager = service;
    }

    void unbindConnectionManager(IConnectionManager service) {
        this.connectionManager = null;
    }

    @Override
    public void addJobFilter(JobFilter filter) {
        this.jobs.put(filter, new ArrayList());
        this.persist();
        HashMap<String, JobFilter> data = new HashMap<String, JobFilter>();
        data.put("filter", filter);
        this.eventAdmin.sendEvent(new Event("miworkplace/ui/jobs/filter/added", data));
    }

    @Override
    public void removeJobFilter(JobFilter filter) {
        this.jobs.remove(filter);
        this.persist();
        HashMap<String, JobFilter> data = new HashMap<String, JobFilter>();
        data.put("filter", filter);
        this.eventAdmin.sendEvent(new Event("miworkplace/ui/jobs/filter/removed", data));
    }

    @Override
    public void updateJobFilter(JobFilter filter) {
        this.persist();
        HashMap<String, JobFilter> data = new HashMap<String, JobFilter>();
        data.put("filter", filter);
        this.eventAdmin.sendEvent(new Event("miworkplace/ui/jobs/filter/edited", data));
    }

    @Override
    public void setRetrievalInterval(int seconds) {
        this.retrievalInterval = seconds;
    }

    @Override
    public void startRetrieval() {
        try {
            if (this.retrieverThread == null || !this.retrieverThread.isAlive()) {
                this.retrieverThread = new JobListRetrieverThread(this.connectionManager, this, this.eventAdmin);
            }
            this.retrieverThread.setRetrievalInterval(this.retrievalInterval);
            if (!this.retrieverThread.isAlive()) {
                this.retrieverThread.start();
            }
        }
        catch (Exception e) {
            this.logger.error((Option)miworkplace.ui.debug.Option.job, "Could not restart the job list retriever thread.", (Throwable)e);
        }
    }

    @Override
    public void stopRetrieval() {
        if (this.retrieverThread != null && this.retrieverThread.isAlive()) {
            this.retrieverThread.end();
        }
    }

    @Override
    public List<JobFilter> listJobFilters(IConnection connection) {
        List<JobFilter> jobFilters = this.listJobFilters();
        ListIterator<JobFilter> iterator = jobFilters.listIterator();
        while (iterator.hasNext()) {
            JobFilter jobFilter = iterator.next();
            if (jobFilter.connectionName.equals(connection.getName())) continue;
            iterator.remove();
        }
        return jobFilters;
    }

    @Override
    public List<JobFilter> listJobFilters() {
        LinkedList<JobFilter> jobFilters = new LinkedList<JobFilter>(this.jobs.keySet());
        Collections.sort(jobFilters, new Comparator<JobFilter>(){

            @Override
            public int compare(JobFilter jf1, JobFilter jf2) {
                return jf1.name.compareTo(jf2.name);
            }
        });
        return jobFilters;
    }

    @Override
    public List<Job> listJobs(JobFilter filter) {
        return this.jobs.get(filter);
    }

    @Override
    public void refresh(JobFilter filter) {
        IConnection connection = this.connectionManager.get(filter.connectionName);
        new JobListRetriever(connection, filter, this.eventAdmin, this).run();
    }

    public void activate(BundleContext context) {
        Bundle bundle = Platform.getBundle((String)Constants.PLUGIN_ID);
        this.bundleStateLocation = Platform.getStateLocation((Bundle)bundle);
        this.load();
    }

    public void deactivate() {
        this.stopRetrieval();
    }

    private StaxDriver createSerializationDriverInstance() {
        return new StaxDriver();
    }

    private void load() {
        File file = this.getSerializedJobFiltersFile();
        if (!file.exists()) {
            this.logger.info((Option)miworkplace.ui.debug.Option.job, "No job filters to load.");
            return;
        }
        if (!file.canRead()) {
            this.logger.warn((Option)miworkplace.ui.debug.Option.job, "Could no read job filters file. No permission.");
            return;
        }
        XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
        xstream.setClassLoader(this.getClass().getClassLoader());
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        }
        catch (Exception e) {
            this.logger.error((Option)miworkplace.ui.debug.Option.job, "Could not read jobfilters from  " + file.getAbsolutePath(), (Throwable)e);
        }
        if (reader != null) {
            List jobFilters = (List)xstream.fromXML((Reader)reader);
            for (JobFilter jobFilter : jobFilters) {
                this.jobs.put(jobFilter, new ArrayList());
            }
        }
    }

    private void persist() {
        File file = this.getSerializedJobFiltersFile();
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            XStream xstream = new XStream((HierarchicalStreamDriver)this.createSerializationDriverInstance());
            xstream.setClassLoader(this.getClass().getClassLoader());
            xstream.toXML(this.listJobFilters(), (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            this.logger.error((Option)miworkplace.ui.debug.Option.job, "Could not write job filters to " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private File getSerializedJobFiltersFile() {
        IPath path = this.bundleStateLocation.append("jobfilters.xml");
        return path.toFile();
    }

    @Override
    public void setJobs(JobFilter filter, List<Job> retrievedJobs) {
        List<Job> jobs = this.jobs.get(filter);
        if (jobs == null) {
            this.addJobFilter(filter);
            jobs = this.jobs.get(filter);
        }
        jobs.clear();
        jobs.addAll(retrievedJobs);
    }

    @Override
    public JobFilter getJobFilterByName(String name) {
        for (JobFilter filter : this.jobs.keySet()) {
            if (!filter.name.equals(name)) continue;
            return filter;
        }
        return null;
    }

    @Override
    public boolean isRetrieving() {
        return this.retrieverThread != null && this.retrieverThread.isAlive();
    }
}

