/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.jobs;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.LinkedList;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.services.api.IActiveConnectionService;
import miworkplace.ui.api.IJobFilterService;
import miworkplace.ui.api.JobFilter;
import miworkplace.ui.api.WorkspaceUtil;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class JobFilterDialog
extends TitleAreaDialog {
    @Inject
    private IJobFilterService filterService;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IActiveConnectionService activeConnService;
    private Combo fConnection;
    private Text fFilterName;
    private Text fJobName;
    private Text fJobQueue;
    private Text fUserName;
    private Combo fJobType;
    private Combo fJobStatus;
    private Combo fJobQueueStatus;
    private Label lblSelectionCriteria;
    private JobFilter fJobFilter;
    private Text fCurrentUser;
    private Text fSubSystem;
    private JobFilter fFilter;

    @Inject
    public JobFilterDialog(@Named(value="activeShell") Shell parentShell, @Optional JobFilter jobfilter) {
        super(parentShell);
        this.fJobFilter = jobfilter;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.fJobFilter == null) {
            this.setTitle(Messages.ui_jobs_new_title);
            this.setMessage(Messages.ui_jobs_new_desc);
        } else {
            this.setTitle(Messages.ui_jobs_edit_title);
            this.setMessage(Messages.ui_jobs_edit_desc);
        }
        Image newTitleImage = new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/jobfilter-wizard.png"));
        this.setTitleImage(newTitleImage);
        parent.addDisposeListener(e -> newTitleImage.dispose());
        Composite root = new Composite(parent, 0);
        root.setLayoutData((Object)new GridData(4, 4, true, true));
        root.setLayout((Layout)new GridLayout(2, false));
        Label lblConnection = new Label(root, 0);
        lblConnection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblConnection.setText(Messages.ui_jobs_filter_connection);
        this.fConnection = new Combo(root, 8);
        this.fConnection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblFilterName = new Label(root, 0);
        lblFilterName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFilterName.setText(Messages.ui_jobs_filter_name);
        this.fFilterName = new Text(root, 2048);
        this.fFilterName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(root, 0);
        new Label(root, 0);
        this.lblSelectionCriteria = new Label(root, 0);
        this.lblSelectionCriteria.setText(Messages.ui_jobs_filter_criteria);
        FontDescriptor descriptor = FontDescriptor.createFrom((Font)this.lblSelectionCriteria.getFont());
        descriptor = descriptor.setStyle(1);
        Font createFont = descriptor.createFont((Device)this.lblSelectionCriteria.getDisplay());
        root.addDisposeListener(e -> createFont.dispose());
        this.lblSelectionCriteria.setFont(createFont);
        new Label(root, 0);
        Label lblJobName = new Label(root, 0);
        lblJobName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblJobName.setText(Messages.ui_jobs_filter_jobname);
        this.fJobName = new Text(root, 2048);
        this.fJobName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblUserName = new Label(root, 0);
        lblUserName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUserName.setText(Messages.ui_jobs_filter_username);
        this.fUserName = new Text(root, 2048);
        this.fUserName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblCurrentUser = new Label(root, 0);
        lblCurrentUser.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCurrentUser.setText(Messages.ui_jobs_filter_curr_user);
        this.fCurrentUser = new Text(root, 2048);
        this.fCurrentUser.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblJobQueue = new Label(root, 0);
        lblJobQueue.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblJobQueue.setText(Messages.ui_jobs_filter_jobqueue);
        this.fJobQueue = new Text(root, 2048);
        this.fJobQueue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblSubsystem = new Label(root, 0);
        lblSubsystem.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSubsystem.setText(Messages.ui_jobs_filter_subsystem);
        this.fSubSystem = new Text(root, 2048);
        this.fSubSystem.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(root, 0);
        new Label(root, 0);
        Label lblJobType = new Label(root, 0);
        lblJobType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblJobType.setText(Messages.ui_jobs_filter_jobtype);
        this.fJobType = new Combo(root, 8);
        this.fJobType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fJobType.add("");
        this.fJobType.add(JobFilter.JobType.Autostart.name());
        this.fJobType.add(JobFilter.JobType.Batch.name());
        this.fJobType.add(JobFilter.JobType.Interactive.name());
        Label lblJobStatus = new Label(root, 0);
        lblJobStatus.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblJobStatus.setText(Messages.ui_jobs_filter_jobstatus);
        this.fJobStatus = new Combo(root, 8);
        this.fJobStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fJobStatus.add("");
        this.fJobStatus.add(JobFilter.JobStatus.Active.name());
        this.fJobStatus.add(JobFilter.JobStatus.JobQueue.name());
        this.fJobStatus.add(JobFilter.JobStatus.OutQueue.name());
        Label lblJobQueueStatus = new Label(root, 0);
        lblJobQueueStatus.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblJobQueueStatus.setText(Messages.ui_jobs_filter_jobqueuestatus);
        this.fJobQueueStatus = new Combo(root, 8);
        this.fJobQueueStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fJobQueueStatus.add("");
        this.fJobQueueStatus.add(JobFilter.JobQueueStatus.Held.name());
        this.fJobQueueStatus.add(JobFilter.JobQueueStatus.Ready.name());
        if (this.fJobFilter != null) {
            this.fillInFormData(this.fJobFilter);
        } else {
            this.setValues();
        }
        WorkspaceUtil.setHelp((Widget)root, "miworkplace.help.MIW: Jobs/Filters");
        return root;
    }

    private void setValues() {
        LinkedList<String> connectionNames = new LinkedList<String>();
        for (IConnection connection : this.connectionManager.list()) {
            connectionNames.add(connection.getName());
        }
        String[] names = connectionNames.toArray(new String[connectionNames.size()]);
        this.fConnection.setItems(names);
        if (names.length > 0) {
            IConnection lastUsedActiveConnection = this.activeConnService.getLastUsedActiveConnection();
            if (lastUsedActiveConnection == null) {
                this.fConnection.select(0);
            } else {
                this.fConnection.select(this.fConnection.indexOf(lastUsedActiveConnection.getName()));
            }
        }
        this.fConnection.setEnabled(true);
        this.fFilterName.setEnabled(true);
    }

    private void fillInFormData(JobFilter jobFilter) {
        this.fConnection.add(jobFilter.connectionName);
        this.fConnection.setText(jobFilter.connectionName);
        this.fConnection.setEnabled(false);
        this.fFilterName.setText(jobFilter.name);
        this.fFilterName.setEnabled(false);
        if (jobFilter.selectionJobName != null) {
            this.fJobName.setText(jobFilter.selectionJobName);
        }
        if (jobFilter.selectionUserName != null) {
            this.fUserName.setText(jobFilter.selectionUserName);
        }
        if (jobFilter.selectionCurrentUserName != null) {
            this.fCurrentUser.setText(jobFilter.selectionCurrentUserName);
        }
        if (jobFilter.selectionJobQueue != null) {
            this.fJobQueue.setText(jobFilter.selectionJobQueue);
        }
        if (jobFilter.selectionSubsystem != null) {
            this.fSubSystem.setText(jobFilter.selectionSubsystem);
        }
        if (jobFilter.selectionJobQueueStatus != null) {
            this.fJobQueueStatus.select(this.fJobQueueStatus.indexOf(jobFilter.selectionJobQueueStatus.name()));
        }
        if (jobFilter.selectionJobType != null) {
            this.fJobType.select(this.fJobType.indexOf(jobFilter.selectionJobType.name()));
        }
        if (jobFilter.selectionStatus != null) {
            this.fJobStatus.select(this.fJobStatus.indexOf(jobFilter.selectionStatus.name()));
        }
    }

    protected void okPressed() {
        JobFilter filter;
        if (this.fJobFilter == null && StringUtils.isBlank((CharSequence)this.fFilterName.getText())) {
            this.setErrorMessage(Messages.ui_jobs_error_noname);
            return;
        }
        if (this.fJobFilter == null && this.filterService.getJobFilterByName(this.fFilterName.getText()) != null) {
            this.setErrorMessage(Messages.ui_jobs_error_dupname);
            return;
        }
        if (!this.filterCriteriaSelected()) {
            this.setErrorMessage(Messages.ui_jobs_error_noselection);
            return;
        }
        JobFilter jobFilter = filter = this.fJobFilter == null ? new JobFilter() : this.fJobFilter;
        if (this.fJobFilter == null) {
            filter.name = this.fFilterName.getText();
            filter.connectionName = this.fConnection.getItem(this.fConnection.getSelectionIndex());
        }
        filter.selectionJobName = StringUtils.isNotBlank((CharSequence)this.fJobName.getText()) ? this.fJobName.getText().toUpperCase() : null;
        filter.selectionJobQueue = StringUtils.isNotBlank((CharSequence)this.fJobQueue.getText()) ? this.fJobQueue.getText().toUpperCase() : null;
        filter.selectionSubsystem = StringUtils.isNotBlank((CharSequence)this.fSubSystem.getText()) ? this.fSubSystem.getText().toUpperCase() : null;
        filter.selectionUserName = StringUtils.isNotBlank((CharSequence)this.fUserName.getText()) ? this.fUserName.getText().toUpperCase() : null;
        filter.selectionCurrentUserName = StringUtils.isNotBlank((CharSequence)this.fCurrentUser.getText()) ? this.fCurrentUser.getText().toUpperCase() : null;
        filter.selectionJobType = StringUtils.isNotBlank((CharSequence)this.fJobType.getText()) ? JobFilter.JobType.valueOf(this.fJobType.getText()) : null;
        filter.selectionStatus = StringUtils.isNotBlank((CharSequence)this.fJobStatus.getText()) ? JobFilter.JobStatus.valueOf(this.fJobStatus.getText()) : null;
        filter.selectionJobQueueStatus = StringUtils.isNotBlank((CharSequence)this.fJobQueueStatus.getText()) ? JobFilter.JobQueueStatus.valueOf(this.fJobQueueStatus.getText()) : null;
        if (this.fJobFilter == null) {
            this.filterService.addJobFilter(filter);
        } else {
            this.filterService.updateJobFilter(filter);
        }
        this.fFilter = filter;
        super.okPressed();
    }

    public JobFilter getFilter() {
        return this.fFilter;
    }

    private boolean filterCriteriaSelected() {
        if (StringUtils.isNotBlank((CharSequence)this.fJobName.getText())) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.fJobQueue.getText())) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.fUserName.getText())) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.fJobType.getText())) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.fJobStatus.getText())) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this.fJobQueueStatus.getText());
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        parent.pack();
        return content;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle bounds = this.getShell().getBounds();
        Point location = this.getInitialLocation(new Point(bounds.width, bounds.height));
        this.getShell().setBounds(location.x, location.y, bounds.width + 100, bounds.height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean close() {
        if (!this.lblSelectionCriteria.getFont().isDisposed()) {
            this.lblSelectionCriteria.getFont().dispose();
        }
        return super.close();
    }
}

