/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.handler.showview;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.ui.api.ModelUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public abstract class ShowViewHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    protected EPartService partService;
    @Inject
    protected EModelService modelService;
    @Inject
    protected MApplication application;
    private MPartStack fPartStack;

    protected void show(String partId, String partStackId) {
        List stacks = this.modelService.findElements((MUIElement)this.application, partStackId, MPartStack.class);
        this.fPartStack = !stacks.isEmpty() ? (MPartStack)stacks.get(0) : ModelUtil.getSharedPartstack(this.modelService, this.application);
        this.show(partId);
    }

    protected void show(String partId) {
        MPart part = this.getPart(partId);
        if (part == null) {
            part = this.partService.createPart(partId);
            if (this.fPartStack != null) {
                this.fPartStack.getChildren().add(part);
                this.fPartStack = null;
            }
            this.partService.showPart(part, EPartService.PartState.ACTIVATE);
        } else {
            this.partService.activate(part);
        }
    }

    private MPart getPart(String partId) {
        try {
            Collection parts = this.partService.getParts();
            for (MPart part : parts) {
                if (!part.getElementId().equals(partId)) continue;
                return part;
            }
        }
        catch (Exception e) {
            this.logger.error((Option)miworkplace.ui.debug.Option.lifeCycle, e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

