/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.handler;

import com.ibm.as400.access.QSYSObjectPathName;
import com.myjavatools.lib.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.viewers.ITreeSelection;
import org.osgi.framework.Bundle;

public class StartDebugHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private UISynchronize sync;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        Object firstElement;
        boolean canExecute = true;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IConnection && !((IConnection)firstElement).isConnected()) {
            return false;
        }
        if (canExecute) {
            canExecute = this.determineJavaPath() != null;
        }
        return canExecute;
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        IConnection connection = null;
        IRemoteObject object = null;
        if (selection.getFirstElement() instanceof IConnection) {
            connection = (IConnection)selection.getFirstElement();
        } else if (selection.getFirstElement() instanceof IRemoteObject) {
            object = (IRemoteObject)selection.getFirstElement();
            connection = object.getConnection();
        } else {
            return;
        }
        String javaPath = this.determineJavaPath();
        this.logger.debug((Option)miworkplace.ui.debug.Option.lifeCycle, "Using path to java binary: " + javaPath);
        String jtopenPath = this.applicationPreferences.get("miworkplace.ui.debug.jtopen", null);
        this.logger.debug((Option)miworkplace.ui.debug.Option.lifeCycle, "Using path to jtopen library: " + jtopenPath);
        try {
            ProcessBuilder pb = this.buildCommand(connection, javaPath, jtopenPath, object);
            pb.start();
        }
        catch (IOException e) {
            this.logger.error("An error occured during the debug session: " + e.getMessage(), (Throwable)e);
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    Notifier.error((String)Messages.ui_handler_debug_title, (String)Messages.ui_handler_debug_error);
                }
            });
        }
    }

    private String determineJavaPath() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null || !new File(javaHome).exists()) {
            return null;
        }
        String osName = System.getProperty("os.name").toLowerCase();
        String exec = osName.contains("win") ? "java.exe" : "java";
        File f = new File(javaHome + "/bin/" + exec);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private ProcessBuilder buildCommand(IConnection connection, String javaPath, String pJtopenPath, IRemoteObject pObject) {
        LinkedList<String> commandList = new LinkedList<String>();
        commandList.add(javaPath);
        commandList.add("-cp");
        try {
            if (Strings.isEmpty((Object)pJtopenPath)) {
                commandList.add(StartDebugHandler.getLibraryLocation() + File.separator + "*");
            } else {
                commandList.add(pJtopenPath + File.separator + "*");
            }
            commandList.add("utilities.Debug");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        commandList.add("-s");
        commandList.add(connection.getSystemName());
        commandList.add("-u");
        commandList.add(connection.getUsername());
        if (pObject != null) {
            QSYSObjectPathName p = new QSYSObjectPathName(pObject.getPath());
            commandList.add("-p");
            if (Strings.isEmpty((Object)p.getMemberName())) {
                commandList.add(pObject.getPath());
            } else {
                commandList.add("/QSYS.LIB/" + p.getLibraryName() + ".LIB/" + p.getMemberName() + ".PGM");
            }
        }
        ProcessBuilder pb = new ProcessBuilder(commandList);
        return pb;
    }

    private static String getLibraryLocation() throws Exception {
        Bundle bundle = Platform.getBundle((String)"com.remainsoftware.common.jtopen.lib");
        URL find = FileLocator.find((Bundle)bundle, (IPath)new Path("/libs"));
        File f = new File(FileLocator.toFileURL((URL)find).toURI());
        return f.getCanonicalPath();
    }
}

