/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class QuitHandler {
    @Inject
    @Preference(nodePath="miworkplace.application", value="miworkplace.ui.general.promptonexit")
    private Boolean prompOnExit;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private LogService logger;
    @Inject
    private EPartService partService;
    @Inject
    private MApplication application;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, IWorkbench workbench) {
        if (this.prompOnExit == null || this.prompOnExit.booleanValue()) {
            IEclipseContext activeChild = this.application.getContext().getActiveChild();
            boolean ok = MessageDialog.openConfirm((Shell)shell, (String)Messages.ui_handler_close_exit_title, (String)Messages.ui_handler_close_exit_prompt);
            activeChild.setParent(this.application.getContext());
            activeChild.activateBranch();
            if (ok) {
                this.close(workbench, shell);
            }
        } else {
            this.close(workbench, shell);
        }
    }

    private void close(IWorkbench workbench, Shell shell) {
        this.logger.log(4, "Closing application");
        IEclipseContext activeChild = this.application.getContext().getActiveChild();
        if (this.arePartsDirty()) {
            MessageDialog dialog = new MessageDialog(shell, Messages.ui_handler_close_save_title, null, Messages.ui_handler_close_save_prompt, 3, new String[]{Messages.common_ignore, Messages.common_cancel}, 1);
            int result = dialog.open();
            activeChild.setParent(this.application.getContext());
            activeChild.activateBranch();
            if (result != 0) {
                return;
            }
        }
        Collection openParts = this.partService.getParts();
        for (MPart part : openParts) {
            if (part.getProperties().containsKey("miworkplace.editor")) {
                this.partService.hidePart(part, true);
                continue;
            }
            if (!part.getProperties().containsKey("miworkplace.view.temporary")) continue;
            this.partService.hidePart(part, true);
        }
        for (IConnection connection : this.connectionManager.list()) {
            if (!connection.isConnected()) continue;
            this.cancelKeepAliveJob(connection);
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                this.logger.log(1, "Could not disconnect connection " + connection.getName() + ". Cause: " + e.getMessage());
            }
        }
        LinkedList<Job> jobs = new LinkedList<Job>();
        for (IConnection connection : this.connectionManager.list()) {
            jobs.addAll(Arrays.asList(Job.getJobManager().find((Object)connection.getName())));
        }
        boolean running = true;
        while (running) {
            running = false;
            for (Job job : jobs) {
                if (job.getState() != 4 && job.getState() != 2) continue;
                running = true;
            }
            if (!running) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        workbench.close();
    }

    private void cancelKeepAliveJob(IConnection connection) {
        this.logger.log(4, "Canceling keep alive jobs for " + connection.getName());
        Job[] jobs = Job.getJobManager().find((Object)connection.getName());
        QualifiedName keepAliveQualifier = new QualifiedName("miworkplace://miworkplace.services.alive", "function");
        Job[] jobArray = jobs;
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            Object property = job.getProperty(keepAliveQualifier);
            if ("keep.alive".equals(property)) {
                job.cancel();
                job.getThread().interrupt();
                break;
            }
            ++n2;
        }
    }

    public boolean arePartsDirty() {
        if (this.partService != null) {
            return !this.partService.getDirtyParts().isEmpty();
        }
        return false;
    }
}

