/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.ui.SWTFontUtils;
import miworkplace.ui.api.IPrintable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.nebula.paperclips.core.EmptyPrint;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.core.grid.DefaultGridLook;
import org.eclipse.nebula.paperclips.core.grid.GridLook;
import org.eclipse.nebula.paperclips.core.grid.GridPrint;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberPrint;
import org.eclipse.nebula.paperclips.core.page.PagePrint;
import org.eclipse.nebula.paperclips.core.text.TextPrint;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;

public class PrintHandler {
    @Inject
    private Logger logger;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") @Optional MPart part) {
        return part == null ? false : part.getObject() instanceof IPrintable;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, @Preference(nodePath="miworkplace.application") IEclipsePreferences applicationPreferences) {
        IPrintable printable = (IPrintable)part.getObject();
        boolean printLineNumbers = applicationPreferences.getBoolean("miworkplace.ui.print.linenumbers", true);
        boolean printHeader = applicationPreferences.getBoolean("miworkplace.ui.print.header", true);
        boolean printFooter = applicationPreferences.getBoolean("miworkplace.ui.print.footer", true);
        PrintDialog dialog = new PrintDialog(shell, 0);
        PrinterData printerData = dialog.open();
        if (printerData != null) {
            String title = printable.getTitle();
            Print print = this.preparePrint(printable.getContent(), title, printLineNumbers, printHeader, printFooter);
            PrintJob job = new PrintJob(title, print);
            job = job.setMargins(40);
            try {
                PaperClips.print((PrintJob)job, (PrinterData)printerData);
            }
            catch (Throwable e) {
                this.logger.error(e);
            }
        }
    }

    private Print preparePrint(String content, final String headerTitle, boolean printLineNumbers, boolean printHeader, boolean printFooter) {
        Font monospacedFont = SWTFontUtils.getMonospacedFont();
        final FontData[] printFontData = monospacedFont.getFontData();
        String[] lines = content.split("\n");
        GridPrint print = null;
        if (printLineNumbers) {
            print = new GridPrint("p, l:10, d:g");
            i = 1;
            while (i <= lines.length) {
                print.add((Print)new TextPrint(String.valueOf(i), printFontData[0]));
                print.add((Print)new EmptyPrint(1, printFontData[0].getHeight()));
                print.add((Print)new TextPrint(lines[i - 1], printFontData[0]));
                ++i;
            }
        } else {
            print = new GridPrint("d:g");
            i = 0;
            while (i < lines.length) {
                print.add((Print)new TextPrint(lines[i], printFontData[0]));
                ++i;
            }
        }
        PageDecoration header = new PageDecoration(){
            private final GridLook footerLook = new DefaultGridLook(5, 2);

            public Print createPrint(PageNumber pageNumber) {
                GridPrint grid = new GridPrint("c:d:g", this.footerLook);
                grid.add((Print)new TextPrint(headerTitle, printFontData[0], 0x1000000));
                return grid;
            }
        };
        PageDecoration footer = new PageDecoration(){
            private final GridLook footerLook = new DefaultGridLook(5, 2);

            public Print createPrint(PageNumber pageNumber) {
                GridPrint grid = new GridPrint("c:d:g", this.footerLook);
                grid.add((Print)new PageNumberPrint(pageNumber, printFontData[0], 0x1000000));
                return grid;
            }
        };
        PagePrint page = new PagePrint((Print)print);
        if (printHeader) {
            page.setHeader(header);
            page.setHeaderGap(10);
        }
        if (printFooter) {
            page.setFooter(footer);
            page.setFooterGap(10);
        }
        return page;
    }
}

