/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.IFSFile;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.WorkspaceUtil;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class StreamFileWizardHandler {
    private final String OPEN_STREAM_FILE_COMMAND_ID = "miworkplace.ui.command.ifs.open";
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IEclipseContext context;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private IConnectionManager connectionManager;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") TreeSelection selection, MApplication application, EPartService partService) {
        IEclipseContext activeChild = application.getContext().getActiveChild();
        InputDialog dialog = new InputDialog(shell, Messages.ui_handler_stmf_wizard_title, Messages.ui_handler_stmf_wizard_prompt, null, null);
        if (dialog.open() == 0) {
            String value = dialog.getValue();
            if (StringUtils.isBlank((CharSequence)value)) {
                Notifier.warn((String)Messages.ui_handler_stmf_wizard_title, (String)String.format(Messages.ui_handler_stmf_wizard_invalidname, value));
            } else {
                StreamFile parentFile = (StreamFile)selection.getFirstElement();
                try {
                    if (!parentFile.isDirectory()) {
                        parentFile = (StreamFile)this.workspaceStore.getParentFile((IRemoteObject)parentFile);
                    }
                    String newDirectoryPath = parentFile.getPath() + "/" + value;
                    IFSFile file = new IFSFile(parentFile.getConnection().getSystem(), newDirectoryPath);
                    if (file.exists()) {
                        Notifier.warn((String)Messages.ui_handler_stmf_wizard_title, (String)String.format(Messages.ui_handler_stmf_wizard_exist, value));
                    } else {
                        boolean created = file.createNewFile();
                        if (created) {
                            IResource resource = WorkspaceUtil.buildStreamFileResource(parentFile.getConnection(), newDirectoryPath, false);
                            StreamFile streamFile = new StreamFile(parentFile.getConnection(), resource, IRemoteObject.Type.streamfile, false);
                            this.workspaceStore.add((IRemoteObject)streamFile);
                            this.eventBroker.post("miworkplace/streamfile/created", (Object)streamFile);
                            Notifier.info((String)Messages.ui_handler_stmf_wizard_title, (String)String.format(Messages.ui_handler_stmf_wizard_success, value));
                            if (activeChild != null) {
                                activeChild.setParent(application.getContext());
                                activeChild.activateBranch();
                            }
                            this.openStreamFile(streamFile.getConnection(), streamFile.getPath(), partService);
                        } else {
                            Notifier.warn((String)Messages.ui_handler_stmf_wizard_title, (String)String.format(Messages.ui_handler_stmf_wizard_notcreated, value));
                        }
                    }
                }
                catch (IOException e) {
                    this.logger.log(1, "Could not create new stream file.", (Throwable)e);
                    Notifier.error((String)Messages.ui_handler_stmf_wizard_title, (String)Messages.ui_handler_stmf_wizard_error);
                }
            }
        }
    }

    private void openStreamFile(IConnection connection, String path, EPartService partService) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("miworkplace.ui.editor.command.parameter.connection", connection.getName());
        parameters.put("miworkplace.ui.editor.command.parameter.selection", path);
        ParameterizedCommand command = this.commandService.createCommand("miworkplace.ui.command.ifs.open", parameters);
        if (!command.getCommand().isDefined()) {
            this.logger.log(1, "Command miworkplace.ui.command.ifs.open is not available. Could not open stream file " + path + ".");
            return;
        }
        if (!this.handlerService.canExecute(command)) {
            this.logger.log(1, "Open Stream File Handler cannot execute for stream file " + path + ".");
        } else {
            IEclipseContext handlerContext = this.context.createChild(this.getClass().getName());
            handlerContext.set(IConnectionManager.class, (Object)this.connectionManager);
            handlerContext.set(IConnection.class, (Object)connection);
            handlerContext.set(LogService.class, (Object)this.logger);
            handlerContext.set(EPartService.class, (Object)partService);
            this.handlerService.executeHandler(command, handlerContext);
            handlerContext.dispose();
        }
    }
}

