/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Properties;
import miworkplace.common.model.IRemoteObject;
import miworkplace.i18n.Messages;
import miworkplace.services.api.ICompileSettings;
import miworkplace.services.api.ICompileSettingsProvider;
import miworkplace.ui.compile.CompileOptionsDialog;
import miworkplace.ui.compile.CompileSettingsProvider;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;

public class SetCompileOptionsHandler {
    @Inject
    private CompileSettingsProvider memberCompileSettingsProvider;
    @Inject
    private ICompileSettingsProvider compileSettingsProvider;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return true;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Optional @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, IEclipseContext context) {
        if (selection.isEmpty()) {
            return;
        }
        IRemoteObject source = (IRemoteObject)selection.getFirstElement();
        Properties properties = this.memberCompileSettingsProvider.get(source);
        ICompileSettings compileSettings = properties != null && properties.containsKey("command.id") ? this.compileSettingsProvider.get(properties.getProperty("command.id")) : this.compileSettingsProvider.getDefault(source);
        String command = compileSettings.getCompileCommand();
        String options = properties.getProperty("compile.options");
        String args = compileSettings.getCompileArguments();
        if (options == null) {
            options = "";
        }
        if (args == null) {
            args = "";
        }
        options = options.trim().isEmpty() ? args : options;
        CompileOptionsDialog dialog = new CompileOptionsDialog(shell, Messages.ui_handler_compile_options_title, String.format(Messages.ui_handler_compile_options_prompt, source.getName(), command.toUpperCase()), options, command, source.getConnection());
        ContextInjectionFactory.inject((Object)((Object)dialog), (IEclipseContext)context);
        if (dialog.open() == 0) {
            properties.put("compile.options", dialog.getValue());
            this.memberCompileSettingsProvider.save(source, properties);
        }
    }
}

