/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.IFSFile;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.HashMap;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.api.WorkspaceUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class RenameIfsHandler {
    @Inject
    private LogService logger;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        return selection != null && !selection.isEmpty() && selection.size() == 1;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        StreamFile ifsObject = (StreamFile)selection.getFirstElement();
        if (ifsObject.isFile()) {
            this.renameStreamFile(shell, ifsObject);
        } else {
            this.renameDirectory(shell, ifsObject);
        }
    }

    private void renameDirectory(Shell shell, final StreamFile directory) {
        InputDialog dialog = new InputDialog(shell, Messages.ui_handler_rename_ifs_dir_title, Messages.ui_handler_rename_ifs_dir_prompt, directory.getName(), new NameValidator(directory)){

            protected void okPressed() {
                IFSFile dir = new IFSFile(directory.getConnection().getSystem(), directory.getPath());
                IFSFile renamedDir = new IFSFile(directory.getConnection().getSystem(), dir.getParentFile().getPath(), this.getValue());
                try {
                    if (renamedDir.exists()) {
                        this.setErrorMessage(Messages.ui_handler_rename_ifs_dir_exist);
                    } else {
                        this.setErrorMessage(null);
                        super.okPressed();
                    }
                }
                catch (IOException e) {
                    RenameIfsHandler.this.logger.log(1, "The new directory name " + this.getValue() + " could not be validated. Error: " + e.getMessage());
                    this.setErrorMessage(Messages.ui_handler_rename_ifs_dir_valerror);
                }
            }
        };
        if (dialog.open() == 0) {
            String newName = dialog.getValue().trim();
            this.logger.log(4, "Renaming " + directory.getPath() + " to " + newName + ".");
            IFSFile dir = new IFSFile(directory.getConnection().getSystem(), directory.getPath());
            IFSFile renamedDirectory = new IFSFile(directory.getConnection().getSystem(), dir.getParentFile().getPath(), newName);
            try {
                dir.renameTo(renamedDirectory);
                Notifier.info((String)Messages.ui_handler_rename_ifs_dir_title, (String)String.format(Messages.ui_handler_rename_ifs_dir_success, dir.getName(), newName));
                boolean isDirectory = true;
                IConnection connection = directory.getConnection();
                IResource resource = WorkspaceUtil.buildStreamFileResource(connection, renamedDirectory.getPath(), isDirectory);
                StreamFile renamedDir = new StreamFile(connection, resource, IRemoteObject.Type.streamfile, isDirectory);
                this.workspaceStore.remove((IRemoteObject)directory);
                this.workspaceStore.add((IRemoteObject)renamedDir);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("new.directory.path", renamedDirectory.getPath());
                map.put("old.directory.path", dir.getPath());
                map.put("connection", directory.getConnection().getName());
                this.eventBroker.post("miworkplace/directory/renamed", map);
            }
            catch (Exception e) {
                this.logger.log(1, "Could not rename directory " + dir.getName() + " to " + newName + ". Error: " + e.getMessage());
                Notifier.error((String)Messages.ui_handler_rename_ifs_dir_title, (String)String.format(Messages.ui_handler_rename_ifs_dir_error, dir.getName(), newName));
            }
        }
    }

    private void renameStreamFile(Shell shell, final StreamFile streamFile) {
        InputDialog dialog = new InputDialog(shell, Messages.ui_handler_rename_ifs_file_title, Messages.ui_handler_rename_ifs_file_prompt, streamFile.getName(), new NameValidator(streamFile)){

            protected void okPressed() {
                IFSFile file = new IFSFile(streamFile.getConnection().getSystem(), streamFile.getPath());
                IFSFile renamedFile = new IFSFile(streamFile.getConnection().getSystem(), file.getParentFile().getPath(), this.getValue());
                try {
                    if (renamedFile.exists()) {
                        this.setErrorMessage(Messages.ui_handler_rename_ifs_file_exist);
                    } else {
                        this.setErrorMessage(null);
                        super.okPressed();
                    }
                }
                catch (IOException e) {
                    RenameIfsHandler.this.logger.log(1, "The new filename " + this.getValue() + " could not be validated.", (Throwable)e);
                    this.setErrorMessage(Messages.ui_handler_rename_ifs_file_valerror);
                }
            }
        };
        if (dialog.open() == 0) {
            String newName = dialog.getValue().trim();
            this.logger.log(4, "Renaming " + streamFile.getPath() + " to " + newName + ".");
            IFSFile file = new IFSFile(streamFile.getConnection().getSystem(), streamFile.getPath());
            IFSFile renamedFile = new IFSFile(streamFile.getConnection().getSystem(), file.getParentFile().getPath(), newName);
            try {
                file.renameTo(renamedFile);
                Notifier.info((String)Messages.ui_handler_rename_ifs_file_title, (String)String.format(Messages.ui_handler_rename_ifs_file_success, file.getName(), newName));
                boolean isDirectory = false;
                IConnection connection = streamFile.getConnection();
                IResource resource = WorkspaceUtil.buildStreamFileResource(connection, renamedFile.getPath(), isDirectory);
                StreamFile renamedStreamFile = new StreamFile(connection, resource, IRemoteObject.Type.streamfile, isDirectory);
                this.workspaceStore.remove((IRemoteObject)streamFile);
                this.workspaceStore.add((IRemoteObject)renamedStreamFile);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("new.file.path", renamedFile.getPath());
                map.put("old.file.path", streamFile.getPath());
                map.put("connection", streamFile.getConnection().getName());
                this.eventBroker.post("miworkplace/streamfile/renamed", map);
            }
            catch (Exception e) {
                this.logger.log(1, "Could not rename file " + file.getName() + " to " + newName, (Throwable)e);
                Notifier.error((String)Messages.ui_handler_rename_ifs_file_title, (String)String.format(Messages.ui_handler_rename_ifs_file_error, file.getName(), newName));
            }
        }
    }

    class NameValidator
    implements IInputValidator {
        private StreamFile streamFile;

        public NameValidator(StreamFile streamFile) {
            this.streamFile = streamFile;
        }

        public String isValid(String newName) {
            if (this.streamFile.getName().equals(newName)) {
                return Messages.ui_handler_rename_ifs_samename;
            }
            return null;
        }
    }
}

