/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.SourceMember;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.ui.explorer.api.AbstractOpenMemberHandler;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;

public class OpenMemberReadOnlyHandler
extends AbstractOpenMemberHandler {
    @Inject
    private EHandlerService handlerService;
    @Inject
    private ECommandService commandService;
    @Inject
    private IContentTypeRegistry contentTypeRegistry;
    private EPartService partService;
    private MApplication application;
    private ESelectionService selectionService;
    private EModelService modelService;

    @Execute
    public void execute(EPartService partService, MApplication application, ESelectionService selectionService, EModelService modelService) {
        this.partService = partService;
        this.application = application;
        this.selectionService = selectionService;
        this.modelService = modelService;
        Object selection = selectionService.getSelection();
        if (selection != null) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object obj : ss) {
                if (!(obj instanceof SourceMember)) continue;
                SourceMember member = (SourceMember)obj;
                String commandId = OpenMemberReadOnlyHandler.getCommandId(member, this.contentTypeRegistry);
                OpenMemberReadOnlyHandler.open(member, commandId, true, this.handlerService, this.commandService, Debug.getInstance());
            }
        }
    }

    @Override
    protected String getContributionURI() {
        return "bundleclass://miworkplace.ui.editor/miworkplace.ui.editor.RemoteEditor";
    }

    @Override
    public String getEditorPartDescriptorId() {
        return "miworkplace.ui.editor.partdescriptor.default";
    }

    @Override
    protected EPartService getPartService() {
        return this.partService;
    }

    @Override
    protected EModelService getModelService() {
        return this.modelService;
    }

    @Override
    protected MApplication getApplication() {
        return this.application;
    }

    @Override
    protected ESelectionService getSelectionService() {
        return this.selectionService;
    }
}

