/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileWriter;
import jakarta.inject.Inject;
import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.service.log.LogService;

public class ImportToFolderRunner
implements IRunnableWithProgress {
    @Inject
    private UISynchronize uiSync;
    @Inject
    protected LogService logger;
    private final StreamFile folder;
    private final File archiveFile;

    public ImportToFolderRunner(StreamFile folder, File archiveFile) {
        this.folder = folder;
        this.archiveFile = archiveFile;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        final AtomicInteger counter = new AtomicInteger(0);
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(this.archiveFile);
                int numberEntries = this.getNumberEntries(zipFile);
                monitor.beginTask(String.format(Messages.ui_handler_import_folder_task, numberEntries), numberEntries);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    boolean created;
                    if (monitor.isCanceled()) break;
                    final ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    monitor.subTask(String.format(Messages.ui_handler_import_folder_subtask, entry.getName()));
                    String newFilePath = this.folder.getPath() + "/" + entry.getName();
                    IFSFile remoteFile = new IFSFile(this.folder.getConnection().getSystem(), newFilePath);
                    IFSFile parentFolder = remoteFile.getParentFile();
                    if (!parentFolder.exists()) {
                        parentFolder.mkdirs();
                    }
                    if (remoteFile.exists()) {
                        remoteFile.delete();
                    }
                    if (!(created = remoteFile.createNewFile())) {
                        this.uiSync.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Notifier.error((String)Messages.ui_handler_import_folder_title, (String)String.format(Messages.ui_handler_import_folder_error, entry.getName()));
                            }
                        });
                        monitor.worked(1);
                        continue;
                    }
                    InputStream in = zipFile.getInputStream(entry);
                    IFSFileWriter out = new IFSFileWriter(remoteFile);
                    IOUtils.copy((InputStream)in, (Writer)out);
                    in.close();
                    try {
                        out.close();
                    }
                    catch (ConnectionDroppedException connectionDroppedException) {}
                    counter.incrementAndGet();
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) {
                    this.uiSync.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Notifier.info((String)Messages.ui_handler_import_folder_title, (String)String.format(Messages.ui_handler_import_folder_success, counter.get(), ImportToFolderRunner.this.folder.getName()));
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            monitor.done();
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                this.logger.log(1, "Could not close ZIP file " + zipFile.getName() + ".", (Throwable)e);
            }
        }
    }

    private int getNumberEntries(ZipFile zipFile) {
        int counter = 0;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            ++counter;
        }
        return counter;
    }
}

