/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceFile;
import miworkplace.common.model.SourceMember;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class DeleteMemberHandler {
    @Inject
    private LogService logger;
    @Inject
    private IConnectionUtilities connUtil;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IWorkspaceStore workspaceStore;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        this.delete(shell, selection);
    }

    public void delete(Shell shell, ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        for (Object element : selection) {
            if (element == null || !(element instanceof SourceMember)) continue;
            this.delete(shell, (SourceMember)element);
        }
    }

    public void delete(Shell shell, SourceMember member) {
        SourceFile sourceFile = this.workspaceStore.getSourceFile(member.getConnection(), member);
        MessageDialog dialog = new MessageDialog(shell, Messages.ui_handler_delete_mbr_title, null, String.format(Messages.ui_handler_delete_mbr_prompt, member.getName()), 3, new String[]{Messages.common_yes, Messages.common_no}, 0);
        if (dialog.open() == 0) {
            String libraryName = this.workspaceStore.getLibrary((IRemoteObject)member).getName();
            try {
                this.connUtil.deleteSourceMember(member.getConnection(), libraryName, sourceFile.getName(), member.getName());
                Notifier.info((String)Messages.ui_handler_delete_mbr_notify_title, (String)String.format(Messages.ui_handler_delete_mbr_success, libraryName, sourceFile.getName(), member.getName()));
                this.workspaceStore.remove((IRemoteObject)member);
                this.eventBroker.post("miworkplace/member/deleted", (Object)member);
            }
            catch (Exception e) {
                this.logger.log(1, "Could not delete member.", (Throwable)e);
                Notifier.error((String)Messages.ui_handler_delete_mbr_notify_title, (String)String.format(Messages.ui_handler_delete_mbr_error, libraryName, sourceFile.getName(), member.getName()));
            }
        }
    }
}

