/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.LinkedList;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.explorer.CopySelection;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.log.LogService;

public class CopyHandler {
    @Inject
    private LogService logger;

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="e4ActivePart") MPart part, ESelectionService selectionService) {
        Object selection = selectionService.getSelection();
        if (selection != null) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.isEmpty()) {
                return;
            }
            LinkedList<String> values = new LinkedList<String>();
            String connectionName = null;
            IRemoteObject.Type type = null;
            boolean typeSet = false;
            for (Object o : ss) {
                if (!(o instanceof IRemoteObject)) continue;
                IRemoteObject object = (IRemoteObject)o;
                if (object.getType() == IRemoteObject.Type.library) {
                    Notifier.info((String)Messages.ui_handler_copy_title, (String)Messages.ui_handler_copy_lib_error);
                    continue;
                }
                if (connectionName == null) {
                    connectionName = object.getConnection().getName();
                }
                if (!typeSet) {
                    type = object instanceof SourceMember ? null : object.getType();
                    typeSet = true;
                }
                values.add(object.getPath());
            }
            if (!values.isEmpty() && connectionName != null) {
                CopySelection copySelection = new CopySelection(connectionName, type, values);
                this.logger.log(4, "Copy selection: " + String.valueOf(copySelection));
                IEclipseContext root = part.getContext();
                root.set(CopySelection.class, (Object)copySelection);
            } else {
                this.logger.log(3, "No values selected for copy/paste action.");
            }
        }
    }
}

