/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.handler;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IRemoteObject;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;

public class ChangeObjectDescriptionHandler {
    private Debug logger = Debug.getInstance();
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IConnectionUtilities connUtilFacade;
    @Inject
    private IObjectPropertiesStore propertiesStore;

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") @Optional ITreeSelection selection) {
        if (selection == null || selection.isEmpty()) {
            return false;
        }
        Object element = selection.getFirstElement();
        return element != null && element instanceof IRemoteObject;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        IRemoteObject object = (IRemoteObject)selection.getFirstElement();
        this.changeObjectDescription(shell, object);
    }

    private void changeObjectDescription(Shell shell, IRemoteObject remoteObject) {
        InputDialog dialog;
        String oldDescription = "";
        Map properties = this.propertiesStore.get(remoteObject);
        if (properties != null && properties.get(ObjectProperty.textdescription) != null) {
            oldDescription = properties.get(ObjectProperty.textdescription).toString();
        }
        if ((dialog = new InputDialog(shell, Messages.ui_handler_chgobjdesc_title, Messages.ui_handler_chgobjdesc_prompt, oldDescription, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() > 50) {
                    return Messages.ui_handler_chgobjdesc_limit_error;
                }
                return null;
            }
        })).open() == 0) {
            String newObjectDescription = dialog.getValue().trim();
            if (newObjectDescription.equals(oldDescription)) {
                Notifier.info((String)Messages.ui_handler_chgobjdesc_title, (String)Messages.ui_handler_chgobjdesc_samevalue_error);
            } else {
                try {
                    this.connUtilFacade.changeObjectDescription(remoteObject.getConnection(), remoteObject.getPath(), newObjectDescription);
                    this.eventBroker.post("miworkplace/object/updated", (Object)remoteObject);
                }
                catch (Exception e) {
                    this.logger.error("Error changing object description for " + remoteObject.getName(), (Throwable)e);
                    Notifier.error((String)Messages.ui_handler_chgobjdesc_title, (String)String.format(Messages.ui_handler_chgobjdesc_error, remoteObject.getName()));
                }
            }
        }
    }
}

