/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.filter;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.Library;
import miworkplace.common.model.RemoteObject;
import miworkplace.common.model.SourceFile;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.ui.explorer.filter.Filter;
import miworkplace.ui.explorer.filter.FilterManager;

public class FilterMatcher {
    private static final String AST = "*";
    private FilterManager fFilterManager;
    private List<Filter> fFilters;
    private boolean fNoLibraries;
    private boolean fNoObjects;
    private boolean fNoMembers;
    Debug log = Debug.getInstance();

    public FilterMatcher(FilterManager pManager, boolean pIFS) {
        this.fFilterManager = pManager;
        this.fFilters = this.fFilterManager.getActiveFilters().stream().filter(f -> f.isIfs() == pIFS).collect(Collectors.toList());
        this.setGlobalValues();
    }

    public FilterMatcher(Filter ... pFilters) {
        this.fFilters = Arrays.asList(pFilters);
        this.setGlobalValues();
    }

    private void setGlobalValues() {
        this.fNoLibraries = this.fFilters.stream().noneMatch(filter -> filter.getLibraries().length > 0);
        this.fNoObjects = this.fFilters.stream().noneMatch(filter -> filter.getObjects().length > 0 || filter.getObjectTypes().length > 0 || filter.getObjectAttributes().length > 0 || filter.isSelectSourceFiles());
        this.fNoMembers = this.fFilters.stream().noneMatch(filter -> filter.getMembers().length > 0 || filter.getMemberTypes().length > 0);
    }

    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.fFilters);
    }

    public boolean isNoLibraries() {
        return this.fNoLibraries;
    }

    public boolean isNoMembers() {
        return this.fNoMembers;
    }

    public boolean isNoObjects() {
        return this.fNoObjects;
    }

    public boolean select(Object pObject) {
        if (!(pObject instanceof IRemoteObject)) {
            return true;
        }
        if (pObject instanceof Library && this.isNoLibraries()) {
            return true;
        }
        if (pObject instanceof SourceMember && this.isNoMembers()) {
            return true;
        }
        if (this.getFilters().size() == 0) {
            return true;
        }
        for (Filter filter : this.getFilters()) {
            if (!this.select(filter, pObject)) continue;
            if (pObject instanceof IRemoteObject) {
                this.log.info((Option)miworkplace.ui.debug.Option.rexFilter, MessageFormat.format("{2} {0} selected by - {1}", ((IRemoteObject)pObject).getName(), filter.getName(), pObject.getClass().getSimpleName()));
            }
            return true;
        }
        return false;
    }

    private boolean select(Filter pFilter, Object pObject) {
        boolean selected = true;
        if (pObject instanceof SourceMember) {
            selected = this.selectSourceMember(pFilter, (SourceMember)pObject);
        } else if (pObject instanceof SourceFile) {
            selected = this.selectSourceFile(pFilter, (SourceFile)pObject);
        } else if (pObject instanceof StreamFile) {
            selected = this.selectStreamFile(pFilter, (StreamFile)pObject);
        } else if (pObject instanceof Library) {
            selected = this.selectLibrary(pFilter, (Library)pObject);
        } else if (pObject instanceof RemoteObject) {
            selected = this.selectRemoteObject(pFilter, (RemoteObject)pObject);
        }
        return selected;
    }

    public String toString() {
        return this.fFilters.toString();
    }

    private boolean selectLibrary(Filter pFilter, Library pLibrary) {
        return this.fFilters.stream().anyMatch(filter -> {
            String[] stringArray = filter.getLibraries();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String lib = stringArray[n2];
                if (this.checkGeneric(lib, pLibrary.getName())) {
                    return true;
                }
                ++n2;
            }
            return this.isNoLibraries();
        });
    }

    private boolean selectSourceMember(Filter pFilter, SourceMember pMember) {
        if (pFilter.getMembers().length == 0 && pFilter.getMemberTypes().length == 0) {
            return false;
        }
        return !(pFilter.getMemberTypes().length != 0 && !this.matchMemberType(pFilter, pMember.getSourceType()) || pFilter.getMembers().length != 0 && !this.matchSourceMember(pFilter, pMember.getName()));
    }

    private boolean selectSourceFile(Filter pFilter, SourceFile pElement) {
        if (pFilter.isSelectSourceFiles()) {
            return true;
        }
        return this.selectRemoteObject(pFilter, (RemoteObject)pElement);
    }

    private boolean selectRemoteObject(Filter pFilter, RemoteObject pElement) {
        int count = 0;
        int match = 0;
        if (pFilter.getObjects().length > 0) {
            ++count;
        }
        if (pFilter.getObjectTypes().length > 0) {
            ++count;
        }
        if (pFilter.getObjectAttributes().length > 0) {
            ++count;
        }
        if (pFilter.getObjectAttributes().length > 0 && this.matchAttribute(pFilter, pElement.getRealAttribute(), pElement.getAttribute())) {
            ++match;
        }
        if (pFilter.getObjectTypes().length > 0 && this.matchType(pFilter, pElement.getRealType())) {
            ++match;
        }
        if (pFilter.getObjects().length > 0 && this.matchObject(pFilter, pElement.getName())) {
            ++match;
        }
        if (count == match && count > 0) {
            return true;
        }
        return this.isNoObjects() && this.isNoMembers();
    }

    boolean matchObject(Filter pFilter, String pName) {
        if (pFilter.getObjects().length == 0) {
            return true;
        }
        String[] stringArray = pFilter.getObjects();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String obj = stringArray[n2];
            if (this.checkGeneric(obj, pName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean matchSourceMember(Filter pFilter, String pName) {
        String[] stringArray = pFilter.getMembers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String mbr = stringArray[n2];
            if (this.checkGeneric(mbr, pName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean selectStreamFile(Filter pFilter, StreamFile pStreamFile) {
        boolean isDirectory = pStreamFile.isDirectory();
        String path = pStreamFile.getPath();
        String fileName = pStreamFile.getName();
        if (pFilter.getDirectories().length > 0 && this.matchStreamFile(pFilter, isDirectory, path, fileName)) {
            return isDirectory || this.matchExtension(pFilter, pStreamFile);
        }
        if (pFilter.getDirectories().length == 0) {
            return this.matchExtension(pFilter, pStreamFile);
        }
        return false;
    }

    private boolean matchExtension(Filter pFilter, StreamFile pStreamFile) {
        if (pFilter.getExtensions().length == 0) {
            return true;
        }
        String[] extensions = pStreamFile.getName().split("\\.");
        if (extensions.length == 1) {
            return false;
        }
        String extension = extensions[extensions.length - 1];
        String[] stringArray = pFilter.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (this.checkGeneric(ext, extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean matchStreamFile(Filter pFilter, boolean pIsDir, String pPath, String pName) {
        if (pFilter.getDirectories().length == 0 && pFilter.getExtensions().length == 0) {
            return false;
        }
        String[] stringArray = pFilter.getDirectories();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            if (pIsDir) {
                if (this.checkGeneric(dir, pPath)) {
                    return true;
                }
                if (pPath.endsWith("/") && this.checkGeneric(dir, pPath.substring(0, pPath.length() - 1))) {
                    return true;
                }
                if (this.checkPath(dir, pPath, pName)) {
                    return true;
                }
                if (pPath.endsWith("/") && this.checkPath(dir, pPath.substring(0, pPath.length() - 1), pName)) {
                    return true;
                }
            } else if (this.checkPath(dir, pPath, pName) && this.checkGeneric(this.getLastSegment(dir), pName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean matchAttribute(Filter pFilter, String pAttribute, IRemoteObject.Attribute pExtendedAttribute) {
        if (pFilter.getObjectAttributes().length == 0) {
            return true;
        }
        String[] stringArray = pFilter.getObjectAttributes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            if (this.checkGeneric(attr, pAttribute)) {
                return true;
            }
            if (pExtendedAttribute != null && this.checkGeneric(attr, pExtendedAttribute.attr())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean matchType(Filter pFilter, String pType) {
        if (pFilter.getObjectTypes().length == 0) {
            return true;
        }
        String[] stringArray = pFilter.getObjectTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type.equalsIgnoreCase(pType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean matchMemberType(Filter pFilter, String pType) {
        String[] stringArray = pFilter.getMemberTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (this.checkGeneric(type, pType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean checkGeneric(String generic, String elementName) {
        String[] split;
        if (generic == null || elementName == null) {
            return false;
        }
        if (generic.equals(AST)) {
            return true;
        }
        generic = generic.toUpperCase();
        if ((elementName = elementName.toUpperCase()).equals(generic)) {
            return true;
        }
        if (generic.startsWith(AST) && generic.endsWith(AST)) {
            generic.replaceFirst("\\*", "");
            if (elementName.contains(generic.substring(1, generic.length() - 1))) {
                return true;
            }
        }
        return generic.startsWith(AST) ? elementName.endsWith(generic.substring(1, generic.length())) : (generic.endsWith(AST) ? elementName.startsWith(generic.substring(0, generic.length() - 1)) : generic.contains(AST) && elementName.startsWith((split = generic.split("\\*"))[0]) && elementName.endsWith(split[split.length - 1]));
    }

    private boolean checkPath(String pDir, String pPath, String pName) {
        pDir = pDir.toUpperCase();
        pPath = pPath.toUpperCase();
        if (pDir.endsWith(AST)) {
            String dir = pDir.substring(0, pDir.length() - 1);
            if (dir.length() > pPath.length()) {
                return dir.startsWith(pPath);
            }
            return pPath.startsWith(dir);
        }
        if (pDir.startsWith(AST) && pPath.endsWith(pDir.substring(1))) {
            return true;
        }
        if (pDir.length() >= pPath.length() && pPath.startsWith(pDir)) {
            return true;
        }
        if (pPath.replaceFirst(Pattern.quote(pDir), "").equalsIgnoreCase(pName)) {
            return true;
        }
        String[] splits = pDir.split("\\*");
        if (splits[0].startsWith(pPath)) {
            return true;
        }
        if (splits.length == 2) {
            String home = pPath.substring(0, pPath.length() - this.getLastSegment(pPath).length());
            if (splits[0].equals(home) && pPath.endsWith(splits[1])) {
                return true;
            }
            if (splits[0].equals(home) && pPath.endsWith(splits[1])) {
                return true;
            }
        } else if (splits.length > 2) {
            String home = pPath.substring(0, pPath.length() - this.getLastSegment(pPath).length());
            String lastSegment = splits[splits.length - 1];
            if (home.startsWith(splits[0]) && pPath.endsWith(lastSegment)) {
                String between = pPath.substring(splits[0].length(), pPath.length() - lastSegment.length() + 1);
                int i = 1;
                while (i < splits.length - 1) {
                    if (!between.contains(splits[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    private String getLastSegment(String pDir) {
        if (pDir.endsWith("/")) {
            return "/";
        }
        String[] split = pDir.split("/");
        return split[split.length - 1];
    }
}

