/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import miworkplace.common.debug.Debug;
import miworkplace.ui.explorer.filter.FilterManager;

public class Filter {
    private String name = "";
    private String[] directories = new String[0];
    private String[] extensions = new String[0];
    private String[] libraries = new String[0];
    private String[] objects = new String[0];
    private String[] objectTypes = new String[0];
    private String[] objectAttributes = new String[0];
    private String[] members = new String[0];
    private String[] memberTypes = new String[0];
    boolean fSelectSourceFiles = false;
    boolean active = false;
    boolean ifs = false;
    @JsonIgnore
    private FilterManager manager;
    @JsonIgnore
    Debug log = Debug.getInstance();

    public void setManager(FilterManager pManager) {
        this.manager = pManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String pName) {
        this.name = pName;
    }

    public String[] getDirectories() {
        return this.directories;
    }

    public void setDirectories(String[] pDirectories) {
        this.directories = pDirectories;
    }

    public String[] getLibraries() {
        return this.libraries;
    }

    public void setLibraries(String[] pLibraries) {
        this.libraries = pLibraries;
    }

    public String[] getObjects() {
        return this.objects;
    }

    public void setObjects(String[] pObjects) {
        this.objects = pObjects;
    }

    public String[] getObjectTypes() {
        return this.objectTypes;
    }

    public void setObjectTypes(String[] pObjectTypes) {
        this.objectTypes = pObjectTypes;
    }

    public String[] getMembers() {
        return this.members;
    }

    public void setMembers(String[] pMembers) {
        this.members = pMembers;
    }

    public boolean isSelectSourceFiles() {
        return this.fSelectSourceFiles;
    }

    public void setSelectSourceFiles(boolean pSelectSourceFiles) {
        this.fSelectSourceFiles = pSelectSourceFiles;
    }

    public void setObjectAttributes(String[] pObjectAttributes) {
        this.objectAttributes = pObjectAttributes;
    }

    public String[] getObjectAttributes() {
        return this.objectAttributes;
    }

    public void setMemberTypes(String[] pMemberTypes) {
        this.memberTypes = pMemberTypes;
    }

    public String[] getMemberTypes() {
        return this.memberTypes;
    }

    public Filter setActive(boolean pActive) {
        this.active = pActive;
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.name, other.name);
    }

    public Filter save() {
        this.manager.addFilter(this);
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isIfs() {
        return this.ifs;
    }

    public void setIfs(boolean pIfs) {
        this.ifs = pIfs;
    }

    public void setExtensions(String[] pExtensions) {
        this.extensions = pExtensions;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public Filter clone() {
        Filter result = new Filter();
        result.setActive(this.isActive());
        result.setDirectories((String[])this.getDirectories().clone());
        result.setExtensions((String[])this.getExtensions().clone());
        result.setIfs(this.isIfs());
        result.setLibraries((String[])this.getLibraries().clone());
        result.setManager(this.manager);
        result.setMembers((String[])this.getMembers().clone());
        result.setMemberTypes((String[])this.getMemberTypes().clone());
        result.setName(this.getName());
        result.setObjectAttributes((String[])this.getObjectAttributes().clone());
        result.setObjects((String[])this.getObjects().clone());
        result.setObjectTypes((String[])this.getObjectTypes().clone());
        result.setSelectSourceFiles(this.isSelectSourceFiles());
        return result;
    }

    @JsonIgnore
    public boolean isNoObjects() {
        return this.getObjects().length <= 0 && this.getObjectTypes().length <= 0 && this.getObjectAttributes().length <= 0;
    }
}

