/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MemberDescription {
    private static final SimpleDateFormat osDateTimeFormat = new SimpleDateFormat("yyMMddHHmmss");
    private static final SimpleDateFormat osDateFormat = new SimpleDateFormat("yyMMdd");
    private static final String QUSRMBRD_FORMAT_100 = "MBRD0100";
    private static final String QUSRMBRD_FORMAT_200 = "MBRD0200";
    private static final String QUSRMBRD_FORMAT_300 = "MBRD0300";
    public static final int CREATION_DATE_TIME = 1;
    public static final int FILE_ATTRIBUTE = 2;
    public static final int FILE_NAME = 3;
    public static final int FILE_TEXT_DESCRIPTION = 4;
    public static final int FILE_TEXT_DESCRIPTION_CCSID = 5;
    public static final int LAST_SOURCE_CHANGE_DATE = 6;
    public static final int MEMBER_NAME = 7;
    public static final int MEMBER_TEXT_DESCRIPTION = 8;
    public static final int SOURCE_FILE = 9;
    public static final int SOURCE_TYPE = 10;
    public static final int LIBRARY_NAME = 11;
    public static final int REMOTE_FILE = 12;
    public static final int LOGICAL_FILE = 13;
    public static final int ODP_SHARING = 14;
    public static final int CURRENT_NUMBER_OF_RECORDS = 15;
    public static final int DATA_SPACE_SIZE = 16;
    public static final int ACCESS_PATH_SIZE = 17;
    public static final int NUMBER_OF_BASED_ON_PHYICAL_FILE_MEMBERS = 18;
    public static final int CHANGE_DATE_AND_TIME = 19;
    public static final int SAVE_DATE_AND_TIME = 20;
    public static final int RESTORE_DATE_AND_TIME = 21;
    public static final int EXPIRATION_DATE = 22;
    public static final int NUMBER_OF_DAYS_USED = 23;
    public static final int DATE_LAST_USED = 24;
    public static final int USE_RESET_DATE = 25;
    public static final int DATA_SPACE_MULTIPLIER = 26;
    public static final int ACCESS_PATH_SIZE_MULTIPLIER = 27;
    public static final int MEMBER_TEXT_DESCRIPTION_CCSID = 28;
    public static final int NUMBER_OF_DELETED_RECORDS = 29;
    public static final int JOIN_MEMBER = 30;
    public static final int ACCESS_PATH_MAINTENANCE = 31;
    public static final int SQL_FILE_TYPE = 32;
    public static final int ALLOW_READ_OPERATION = 33;
    public static final int ALLOW_WRITE_OPERATION = 34;
    public static final int ALLOW_UPDATE_OPERATION = 35;
    public static final int ALLOW_DELETE_OPERATION = 36;
    public static final int RECORDS_TO_FORCE_A_WRITE = 37;
    public static final int MAXIMUM_PERCENT_DELETED_RECORDS_ALLOWED = 38;
    public static final int INITIAL_NUMBER_OF_RECORDS = 39;
    public static final int INCREMENT_NUMBER_OF_RECORDS = 40;
    public static final int MAXIMUM_NUMBER_OF_INCREMENTS = 41;
    public static final int CURRENT_NUMBER_OF_INCREMENTS = 42;
    public static final int RECORD_CAPACITY = 43;
    public static final int RECORD_FORMAT_SELECTOR_PROGRAM_NAME = 44;
    public static final int RECORD_FORMAT_SELECTOR_LIBRARY_NAME = 45;
    public static final int ALL_MEMBER_INFORMATION = Integer.MAX_VALUE;
    static final int OFFSET_FILE_NAME = 8;
    static final int OFFSET_LIBRARY_NAME = 18;
    static final int OFFSET_MEMBER_NAME = 28;
    static final int OFFSET_FILE_ATTRIBUTE = 38;
    static final int OFFSET_SOURCE_TYPE = 48;
    static final int OFFSET_CREATION_DATE_TIME = 58;
    static final int OFFSET_LAST_SOURCE_CHANGE_DATE = 71;
    static final int OFFSET_MEMBER_TEXT_DESCRIPTION = 84;
    static final int OFFSET_SOURCE_FILE = 134;
    static final int OFFSET_REMOTE_FILE = 135;
    static final int OFFSET_LOGICAL_FILE = 136;
    static final int OFFSET_ODP_SHARING = 137;
    static final int OFFSET_NUMBER_OF_RECORDS = 252;
    static final int OFFSET_DATA_SPACE_SIZE = 148;
    static final int OFFSET_DATA_SPACE_MULTIPLIER = 232;
    static final int OFFSET_ACCESS_PATH_SIZE = 152;
    static final int OFFSET_ACCESS_PATH_SIZE_MULTIPLIER = 236;
    static final int OFFSET_NUMBER_OF_BASED_ON_PHYICAL_FILE_MEMBERS = 156;
    static final int OFFSET_CHANGE_DATE_AND_TIME = 160;
    static final int OFFSET_SAVE_DATE_AND_TIME = 173;
    static final int OFFSET_USE_RESET_DATE = 223;
    static final int OFFSET_RESTORE_DATE_AND_TIME = 186;
    static final int OFFSET_EXPIRATION_DATE = 199;
    static final int OFFSET_NUMBER_OF_DAYS_USED = 212;
    static final int OFFSET_DATE_LAST_USED = 216;
    static final int OFFSET_MEMBER_TEXT_DESCRIPTION_CCSID = 240;
    static final int OFFSET_NUMBER_OF_DELETED_RECORDS = 256;
    static final int OFFSET_JOIN_MEMBER = 266;
    static final int OFFSET_ACCESS_PATH_MAINTENANCE = 267;
    static final int OFFSET_SQL_FILE_TYPE = 268;
    static final int OFFSET_ALLOW_READ_OPERATION = 279;
    static final int OFFSET_ALLOW_WRITE_OPERATION = 280;
    static final int OFFSET_ALLOW_UPDATE_OPERATION = 281;
    static final int OFFSET_ALLOW_DELETE_OPERATION = 282;
    static final int OFFSET_RECORDS_TO_FORCE_A_WRITE = 284;
    static final int OFFSET_MAXIMUM_PERCENT_DELETED_RECORDS_ALLOWED = 288;
    static final int OFFSET_INITIAL_NUMBER_OF_RECORDS = 292;
    static final int OFFSET_INCREMENT_NUMBER_OF_RECORDS = 296;
    static final int OFFSET_MAXIMUM_NUMBER_OF_INCREMENTS = 300;
    static final int OFFSET_CURRENT_NUMBER_OF_INCREMENTS = 304;
    static final int OFFSET_RECORD_CAPACITY = 308;
    static final int OFFSET_RECORD_FORMAT_SELECTOR_PROGRAM_NAME = 312;
    static final int OFFSET_RECORD_FORMAT_SELECTOR_LIBRARY_NAME = 322;
    private AS400 system;
    private QSYSObjectPathName path;
    private final HashMap attributes = new HashMap();
    private final AS400Bin4 intConverter = new AS400Bin4();

    public MemberDescription(AS400 system, QSYSObjectPathName path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.system = system;
        this.path = path;
    }

    MemberDescription(AS400 system, QSYSObjectPathName path, Map attributes) {
        this(system, path);
        this.attributes.putAll(attributes);
    }

    private String lookupFormat(int attribute) {
        String format;
        switch (attribute) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                String string = QUSRMBRD_FORMAT_100;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                format = QUSRMBRD_FORMAT_200;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 0x7FFFFFFF: {
                format = QUSRMBRD_FORMAT_300;
                break;
            }
            default: {
                format = QUSRMBRD_FORMAT_100;
            }
        }
        return format;
    }

    public Object getValue(int attribute) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, Exception {
        Integer key = new Integer(attribute);
        Object value = null;
        value = this.attributes.get(key);
        if (value == null) {
            value = this.retrieve(attribute);
            this.attributes.put(key, value);
        }
        return value;
    }

    void setAttribute(int attribute, Object value) {
        this.attributes.put(new Integer(attribute), value);
    }

    private Object retrieve(int attribute) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String format = this.lookupFormat(attribute);
        ProgramParameter[] parameters = this.buildProgramParameters(format);
        ProgramCall program = new ProgramCall(this.system, "/QSYS.LIB/QUSRMBRD.PGM", parameters);
        if (!this.system.isConnected()) {
            throw new IOException("Client is not connected to the server.");
        }
        if (program.run()) {
            this.readMemberInfo(parameters[0].getOutputData(), format);
            return this.attributes.get(new Integer(attribute));
        }
        throw new AS400Exception(program.getMessageList());
    }

    private ProgramParameter[] buildProgramParameters(String format) {
        QSYSObjectPathName filePath = new QSYSObjectPathName(this.path.getLibraryName(), this.path.getObjectName(), "FILE");
        ProgramParameter[] parameterList = new ProgramParameter[]{new ProgramParameter(332), new ProgramParameter(this.intConverter.toBytes(332)), new ProgramParameter(CharConverter.stringToByteArray((AS400)this.system, (String)format)), new ProgramParameter(CharConverter.stringToByteArray((AS400)this.system, (String)filePath.toQualifiedObjectName())), new ProgramParameter(new AS400Text(10).toBytes((Object)this.path.getMemberName())), new ProgramParameter(CharConverter.stringToByteArray((AS400)this.system, (String)"1"))};
        return parameterList;
    }

    private void readMemberInfo(byte[] entryBytes, String format) throws UnsupportedEncodingException {
        CharConverter charConverter = new CharConverter(this.system.getCcsid(), this.system);
        this.setAttribute(3, charConverter.byteArrayToString(entryBytes, 8, 10).trim());
        this.setAttribute(11, charConverter.byteArrayToString(entryBytes, 18, 10).trim());
        this.setAttribute(2, charConverter.byteArrayToString(entryBytes, 38, 10).trim());
        this.setAttribute(7, charConverter.byteArrayToString(entryBytes, 28, 10).trim());
        this.setAttribute(10, charConverter.byteArrayToString(entryBytes, 48, 10).trim());
        this.setAttribute(8, charConverter.byteArrayToString(entryBytes, 84, 50).trim());
        this.setAttribute(6, this.transformDate(charConverter.byteArrayToString(entryBytes, 71, 13)));
        this.setAttribute(1, this.transformDate(charConverter.byteArrayToString(entryBytes, 58, 13)));
        this.setAttribute(9, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 134, 1)));
        if (format.equals(QUSRMBRD_FORMAT_200) || format.equals(QUSRMBRD_FORMAT_300)) {
            this.setAttribute(12, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 135, 1)));
            this.setAttribute(13, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 136, 1)));
            this.setAttribute(14, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 137, 1)));
            this.setAttribute(16, new Integer(this.intConverter.toInt(entryBytes, 148)));
            this.setAttribute(17, new Integer(this.intConverter.toInt(entryBytes, 152)));
            this.setAttribute(18, new Integer(this.intConverter.toInt(entryBytes, 156)));
            this.setAttribute(19, this.transformDate(charConverter.byteArrayToString(entryBytes, 160, 13)));
            this.setAttribute(21, this.transformDate(charConverter.byteArrayToString(entryBytes, 186, 13)));
            this.setAttribute(20, this.transformDate(charConverter.byteArrayToString(entryBytes, 173, 13)));
            this.setAttribute(22, this.transformDate(charConverter.byteArrayToString(entryBytes, 199, 13)));
            this.setAttribute(23, new Integer(this.intConverter.toInt(entryBytes, 212)));
            this.setAttribute(24, this.transformDate(charConverter.byteArrayToString(entryBytes, 216, 13)));
            this.setAttribute(25, this.transformDate(charConverter.byteArrayToString(entryBytes, 223, 13)));
            this.setAttribute(26, new Integer(this.intConverter.toInt(entryBytes, 232)));
            this.setAttribute(27, new Integer(this.intConverter.toInt(entryBytes, 236)));
            this.setAttribute(28, new Integer(this.intConverter.toInt(entryBytes, 240)));
            this.setAttribute(29, new Integer(this.intConverter.toInt(entryBytes, 256)));
        }
        if (format.equals(QUSRMBRD_FORMAT_300)) {
            this.setAttribute(30, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 266, 1)));
            this.setAttribute(31, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 267, 1)));
            this.setAttribute(32, charConverter.byteArrayToString(entryBytes, 268, 10).trim());
            this.setAttribute(33, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 279, 1)));
            this.setAttribute(34, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 280, 1)));
            this.setAttribute(35, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 281, 1)));
            this.setAttribute(36, this.transformBoolean(charConverter.byteArrayToString(entryBytes, 282, 1)));
            this.setAttribute(37, new Integer(this.intConverter.toInt(entryBytes, 284)));
            this.setAttribute(38, new Integer(this.intConverter.toInt(entryBytes, 288)));
            this.setAttribute(39, new Integer(this.intConverter.toInt(entryBytes, 292)));
            this.setAttribute(40, new Integer(this.intConverter.toInt(entryBytes, 296)));
            this.setAttribute(41, new Integer(this.intConverter.toInt(entryBytes, 300)));
            this.setAttribute(42, new Integer(this.intConverter.toInt(entryBytes, 304)));
            this.setAttribute(43, new Integer(this.intConverter.toInt(entryBytes, 308)));
            this.setAttribute(44, charConverter.byteArrayToString(entryBytes, 44, 10).trim());
            this.setAttribute(45, charConverter.byteArrayToString(entryBytes, 45, 10).trim());
        }
    }

    private Date transformDate(String osDateString) {
        Date retVal = null;
        if (osDateString != null && !osDateString.equals("")) {
            try {
                if (osDateString.length() == 13) {
                    retVal = osDateTimeFormat.parse(osDateString.substring(1));
                } else if (osDateString.length() == 7) {
                    retVal = osDateFormat.parse(osDateString.substring(1));
                }
            }
            catch (ParseException parseException) {}
        }
        return retVal;
    }

    private Boolean transformBoolean(String value) {
        if (value.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getPath() {
        return this.path.getPath();
    }
}

