/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.explorer;

import com.ibm.as400.access.IFSFile;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.StreamFile;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IDoubleClickExecutor;
import miworkplace.services.api.IDoubleClickServiceProvider;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.explorer.IfsViewerSorter;
import org.eclipse.core.resources.IResource;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogService;

public class IfsViewer
extends TreeViewer {
    private static final String ROOT_CONTEXT_MENU_ID = "miworkplace.ui.menu.popup.explorer.ifs";
    private static final String DIRECTORY_CONTEXT_MENU_ID = "miworkplace.ui.menu.popup.explorer.ifs.directory";
    private static final String FILE_CONTEXT_MENU_ID = "miworkplace.ui.menu.popup.explorer.ifs.file";
    @Inject
    private IEclipseContext context;
    @Inject
    @Named(value="miworkplace.ui.source.id")
    private Long sourceId;
    @Inject
    private LogService logger;
    @Inject
    private IConnectionManager connectionManager;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ECommandService commandService;
    @Inject
    private EHandlerService handlerService;
    @Inject
    private EMenuService menuService;
    @Inject
    private IDoubleClickServiceProvider doubleClickServiceProvider;

    @Inject
    public IfsViewer(@Named(value="miworkplace.ui.explorer.viewer.parent") Composite parent) {
        super(parent, 770);
    }

    @PostConstruct
    private void postConstruct(final ESelectionService selectionService) {
        this.setSorter(new IfsViewerSorter());
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                selectionService.setSelection((Object)event.getSelection());
                if (!event.getSelection().isEmpty() && event.getSelection() instanceof ITreeSelection) {
                    ITreeSelection selection = (ITreeSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element == null) {
                        IfsViewer.this.menuService.registerContextMenu((Object)IfsViewer.this.getControl(), IfsViewer.ROOT_CONTEXT_MENU_ID);
                    } else if (element instanceof IConnection) {
                        IfsViewer.this.menuService.registerContextMenu((Object)IfsViewer.this.getControl(), IfsViewer.ROOT_CONTEXT_MENU_ID);
                    } else if (element instanceof StreamFile) {
                        StreamFile file = (StreamFile)element;
                        try {
                            if (file.isDirectory()) {
                                IfsViewer.this.menuService.registerContextMenu((Object)IfsViewer.this.getControl(), IfsViewer.DIRECTORY_CONTEXT_MENU_ID);
                            } else if (file.isFile()) {
                                IfsViewer.this.menuService.registerContextMenu((Object)IfsViewer.this.getControl(), IfsViewer.FILE_CONTEXT_MENU_ID);
                            } else {
                                IfsViewer.this.menuService.registerContextMenu((Object)IfsViewer.this.getControl(), IfsViewer.ROOT_CONTEXT_MENU_ID);
                            }
                        }
                        catch (Exception e) {
                            IfsViewer.this.logger.log(1, "Could not determine file type for determining context menu for " + String.valueOf(element) + ". Error: " + e.getMessage());
                            IfsViewer.this.menuService.registerContextMenu((Object)IfsViewer.this.getControl(), IfsViewer.ROOT_CONTEXT_MENU_ID);
                        }
                    }
                    IConnection connection = null;
                    if (element instanceof IConnection) {
                        connection = (IConnection)element;
                    } else {
                        Object firstSegment;
                        TreePath[] path = selection.getPathsFor(element);
                        if (path.length > 0 && (firstSegment = path[0].getSegment(0)) instanceof IConnection) {
                            connection = (IConnection)firstSegment;
                        }
                    }
                    if (connection != null) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("org.eclipse.e4.data", connection);
                        map.put("connection", connection.getName());
                        IfsViewer.this.eventBroker.send("miworkplace/connection/used", map);
                    }
                }
            }
        });
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() == null) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                IDoubleClickExecutor executor = IfsViewer.this.doubleClickServiceProvider.get(element);
                if (executor != null) {
                    executor.execute(element, IfsViewer.this.handlerService, IfsViewer.this.commandService);
                }
            }
        });
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.addDragSupport(2, transferTypes, (DragSourceListener)new DragListener((ISelectionProvider)this));
        DropListener dropListener = new DropListener((Viewer)this);
        ContextInjectionFactory.inject((Object)((Object)dropListener), (IEclipseContext)this.context);
        this.addDropSupport(2, transferTypes, (DropTargetListener)dropListener);
    }

    @PreDestroy
    private void preDestroy() {
    }

    @Inject
    @Optional
    public void notifiedConnection(@UIEventTopic(value="miworkplace/connection/*") Event event) {
        try {
            if (event.getTopic().equals("miworkplace/connection/connected")) {
                this.refresh(event.getProperty("org.eclipse.e4.data"));
            } else if (event.getTopic().equals("miworkplace/connection/changed")) {
                this.refresh(event.getProperty("org.eclipse.e4.data"));
            } else if (event.getTopic().equals("miworkplace/connection/created")) {
                this.refresh();
            } else if (event.getTopic().equals("miworkplace/connection/deleted")) {
                this.refresh();
            } else if (event.getTopic().equals("miworkplace/connection/disconnected")) {
                this.refresh(event.getProperty("org.eclipse.e4.data"));
            }
        }
        catch (SWTException sWTException) {}
    }

    @Inject
    @Optional
    public void notifiedFilesLoaded(@UIEventTopic(value="miworkplace/ui/loader/files/loaded") Event event) {
        if (event.getProperty("viewerId").equals(this.getSourceId())) {
            String connectionName = event.getProperty("connection").toString();
            IConnection connection = this.connectionManager.get(connectionName);
            String path = event.getProperty("path").toString();
            Object object = "/".equals(path) ? connection : this.workspaceStore.get(connection, path);
            if (object != null) {
                Object[] expandedElements = this.getExpandedElements();
                this.refresh(object, true);
                Object[] objectArray = expandedElements;
                int n = expandedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    this.expandToLevel(o, 0);
                    ++n2;
                }
                this.setExpandedState(object, true);
            }
        }
    }

    @Inject
    @Optional
    public void notifiedStreamFileCreated(@UIEventTopic(value="miworkplace/streamfile/created") Event event) {
        StreamFile file = (StreamFile)event.getProperty("org.eclipse.e4.data");
        StreamFile parentFile = (StreamFile)this.workspaceStore.getParentFile((IRemoteObject)file);
        if (parentFile != null) {
            this.refresh(parentFile, true);
            this.setExpandedState(parentFile, true);
        }
    }

    @Inject
    @Optional
    public void notifiedStreamFileDeleted(@UIEventTopic(value="miworkplace/streamfile/deleted") Event event) {
        StreamFile file = (StreamFile)event.getProperty("org.eclipse.e4.data");
        StreamFile parentFile = (StreamFile)this.workspaceStore.getParentFile((IRemoteObject)file);
        if (parentFile != null) {
            this.refresh(parentFile);
            this.setExpandedState(parentFile, true);
        }
    }

    @Inject
    @Optional
    public void notifiedStreamFileRenamed(@UIEventTopic(value="miworkplace/streamfile/renamed") Event event) {
        String newPath;
        IConnection connection = this.connectionManager.get(event.getProperty("connection").toString());
        IRemoteObject newStreamFile = this.workspaceStore.get(connection, newPath = event.getProperty("new.file.path").toString());
        IRemoteObject newParentFile = this.workspaceStore.getParentFile(newStreamFile);
        if (newParentFile != null) {
            this.refresh(newParentFile);
        }
    }

    @Inject
    @Optional
    public void notifiedDirectoryRenamed(@UIEventTopic(value="miworkplace/directory/renamed") Event event) {
        IConnection connection = this.connectionManager.get(event.getProperty("connection").toString());
        String newPath = event.getProperty("new.directory.path").toString();
        IRemoteObject newDirectory = this.workspaceStore.get(connection, newPath);
        IRemoteObject newParentFile = this.workspaceStore.getParentFile(newDirectory);
        String oldPath = event.getProperty("old.directory.path").toString();
        IRemoteObject oldDirectory = this.workspaceStore.get(connection, oldPath);
        IRemoteObject oldParentFile = this.workspaceStore.getParentFile(oldDirectory);
        if (newParentFile != null) {
            this.refresh(newParentFile);
        }
        if (!newParentFile.getPath().equals(oldParentFile.getPath())) {
            this.refresh(oldParentFile);
        }
    }

    @Inject
    @Optional
    public void notifiedDirectoryCreated(@UIEventTopic(value="miworkplace/directory/created") Event event) {
        StreamFile file = (StreamFile)event.getProperty("org.eclipse.e4.data");
        IRemoteObject directory = this.workspaceStore.getParentFile((IRemoteObject)file);
        if (directory != null) {
            this.refresh(directory, true);
            this.setExpandedState(directory, true);
        }
    }

    @Inject
    @Optional
    public void notifiedCollapse(@UIEventTopic(value="miworkplace/ui/explorer/collapse") Event event) {
        this.collapseAll();
        this.refresh();
    }

    @Inject
    @Optional
    public void notifiedStreamFileMoved(@UIEventTopic(value="miworkplace/streamfile/moved") Event event) {
        IConnection connection = this.connectionManager.get(event.getProperty("connection").toString());
        String newPath = event.getProperty("new.file.path").toString();
        IRemoteObject newFile = this.workspaceStore.get(connection, newPath);
        IRemoteObject newParentFile = this.workspaceStore.getParentFile(newFile);
        String oldPath = event.getProperty("old.parent.file.path").toString();
        IRemoteObject oldParentFile = this.workspaceStore.get(connection, oldPath);
        if (newParentFile != null) {
            this.refresh(newParentFile);
        }
        if (!newParentFile.getPath().equals(oldParentFile.getPath())) {
            this.refresh(oldParentFile);
        }
    }

    @Inject
    @Optional
    public void notifiedExpandPath(@UIEventTopic(value="miworkplace/ui/explorer/ifs/expand") Event event) {
        IConnection connection = (IConnection)event.getProperty("connection");
        String path = event.getProperty("path").toString();
        this.setExpandedState(connection, true);
        List treePathElements = this.workspaceStore.getPathElements(connection, path);
        ArrayList<IConnection> elements = new ArrayList<IConnection>();
        elements.add(connection);
        elements.addAll(treePathElements);
        this.setExpandedElements(elements.toArray());
        if (!treePathElements.isEmpty()) {
            this.reveal(treePathElements.get(treePathElements.size() - 1));
        }
    }

    private Long getSourceId() {
        return this.sourceId;
    }

    class DragListener
    extends DragSourceAdapter {
        private final ISelectionProvider selectionProvider;

        public DragListener(ISelectionProvider selectionProvider) {
            this.selectionProvider = selectionProvider;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
            event.doit = selection.isEmpty() ? false : selection.getFirstElement() instanceof StreamFile;
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
            if (transfer.isSupportedType(event.dataType)) {
                transfer.setSelection((ISelection)selection);
                transfer.setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
            }
        }
    }

    class DropListener
    extends ViewerDropAdapter {
        private final String NOTIFICATION_TITLE;
        @Inject
        private IWorkspaceStore workspaceStore;
        @Inject
        private Shell shell;

        public DropListener(Viewer viewer) {
            super(viewer);
            this.NOTIFICATION_TITLE = Messages.ui_ifsviewer_drop_title;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return this.getCurrentLocation() == 3 && target instanceof StreamFile && LocalSelectionTransfer.getTransfer().isSupportedType(transferType);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean performDrop(Object data) {
            LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
            IStructuredSelection selection = (IStructuredSelection)transfer.getSelection();
            StreamFile target = (StreamFile)this.getCurrentTarget();
            if (target.isFile()) {
                target = (StreamFile)this.workspaceStore.getParentFile((IRemoteObject)target);
            }
            if (target == null) {
                return false;
            }
            int numberStreamFiles = 0;
            int successfullyMoved = 0;
            boolean replaceAll = false;
            boolean aborted = false;
            block8: for (StreamFile sourceStreamFile : selection) {
                ++numberStreamFiles;
                try {
                    boolean replace;
                    IFSFile sourceIfsFile = new IFSFile(sourceStreamFile.getConnection().getSystem(), sourceStreamFile.getPath());
                    IFSFile destIfsFile = new IFSFile(target.getConnection().getSystem(), target.getPath() + "/" + sourceStreamFile.getName());
                    if (sourceIfsFile.getParent().equals(destIfsFile.getParent())) {
                        IfsViewer.this.logger.log(1, "Could not move " + sourceIfsFile.getPath() + " to " + destIfsFile.getPath() + ". Source path must not equal the destination path.");
                        Notifier.error((String)this.NOTIFICATION_TITLE, (String)String.format(Messages.ui_ifsviewer_drop_same, sourceIfsFile.getPath(), destIfsFile.getPath()));
                        continue;
                    }
                    boolean exist = destIfsFile.exists();
                    boolean bl = replace = replaceAll;
                    if (exist && !replaceAll) {
                        MessageDialog dialog = new MessageDialog(this.shell, Messages.ui_ifsviewer_drop_confirm, null, String.format(Messages.ui_ifsviewer_drop_confirm_msg, sourceIfsFile.getName()), 5, new String[]{Messages.common_yes_all, Messages.common_yes, Messages.common_no, Messages.common_cancel}, 2);
                        int buttonIndex = dialog.open();
                        switch (buttonIndex) {
                            case 0: {
                                replaceAll = true;
                                replace = true;
                                break;
                            }
                            case 1: {
                                replace = true;
                                break;
                            }
                            case 2: {
                                replace = false;
                                break;
                            }
                            case 3: {
                                aborted = true;
                                break block8;
                            }
                        }
                    }
                    if (exist && !replace) continue;
                    boolean success = sourceIfsFile.renameTo(destIfsFile);
                    if (success) {
                        ++successfullyMoved;
                    }
                    String oldParentFilePath = this.workspaceStore.getParentFile((IRemoteObject)sourceStreamFile).getPath();
                    this.changeInWorkspace(sourceStreamFile, target);
                    this.sendMovedEvent(sourceStreamFile, destIfsFile, oldParentFilePath);
                }
                catch (Exception e) {
                    IfsViewer.this.logger.log(1, "Could not move " + sourceStreamFile.getPath() + " to " + target.getPath() + ". Error: " + e.getMessage());
                    Notifier.error((String)this.NOTIFICATION_TITLE, (String)String.format(Messages.ui_ifsviewer_drop_notmove, sourceStreamFile.getPath(), target.getPath()));
                }
            }
            if (aborted) {
                Notifier.info((String)this.NOTIFICATION_TITLE, (String)Messages.ui_ifsviewer_drop_abort);
                return false;
            }
            if (successfullyMoved > 0) {
                Notifier.info((String)this.NOTIFICATION_TITLE, (String)String.format(Messages.ui_ifsviewer_drop_success, successfullyMoved, numberStreamFiles));
                return true;
            }
            return false;
        }

        private void sendMovedEvent(StreamFile sourceStreamFile, IFSFile destIfsFile, String oldParentFilePath) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("new.file.path", destIfsFile.getPath());
            map.put("old.parent.file.path", oldParentFilePath);
            map.put("connection", sourceStreamFile.getConnection().getName());
            IfsViewer.this.eventBroker.post("miworkplace/streamfile/moved", map);
        }

        private void changeInWorkspace(StreamFile sourceStreamFile, StreamFile targetDirectory) {
            IConnection connection = sourceStreamFile.getConnection();
            String name = targetDirectory.getPath() + "/" + sourceStreamFile.getName();
            IResource resource = WorkspaceUtil.buildStreamFileResource(connection, name, sourceStreamFile.isDirectory());
            StreamFile renamedStreamFile = new StreamFile(connection, resource, IRemoteObject.Type.streamfile, sourceStreamFile.isDirectory());
            this.workspaceStore.remove((IRemoteObject)sourceStreamFile);
            this.workspaceStore.add((IRemoteObject)renamedStreamFile);
        }
    }
}

