/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.eventfile;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.MemberDescription;
import com.ibm.as400.access.MemberList;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.SequentialFile;
import com.remainsoftware.common.util.ServiceUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Scanner;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.connection.api.IConnectionUtilities;
import miworkplace.ui.api.EventFile;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.api.IEventFileLoader;
import miworkplace.ui.eventfile.NoEventFileException;

public class EventFileLoader
implements IEventFileLoader {
    private static final String SPACE = " ";
    private static SimpleDateFormat compileResultTimestampFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private Debug logger = Debug.getInstance();
    IWorkspaceStore fStore;
    IConnectionUtilities fUtils;

    @Override
    public EventFile loadEventFile(IConnection conn, String ifsPath) {
        this.logger.debug((Option)miworkplace.ui.debug.Option.compile, "Loading event file " + ifsPath);
        this.fStore = (IWorkspaceStore)ServiceUtils.getOSGiService(this.getClass(), IWorkspaceStore.class);
        this.fUtils = (IConnectionUtilities)ServiceUtils.getOSGiService(this.getClass(), IConnectionUtilities.class);
        if (ifsPath.trim().toUpperCase().startsWith("/QSYS.LIB")) {
            return this.loadQSysEventFile(conn, ifsPath);
        }
        return this.loadIfsEventFile(conn, ifsPath);
    }

    public void deleteEventFile(IConnection connection, String ifsPath) {
        try {
            this.fUtils.executeRemoteCommand(connection, this.buildRemoveEventFileMemberCommand(ifsPath));
            MemberList memberList = new MemberList(connection.getSystem(), new QSYSObjectPathName(ifsPath));
            memberList.addAttribute(3);
            memberList.load();
            MemberDescription[] memberDescriptions = memberList.getMemberDescriptions();
            if (memberDescriptions == null || memberDescriptions.length == 0) {
                this.fUtils.executeRemoteCommand(connection, this.buildRemoveEventFileMemberCommand(ifsPath));
            }
        }
        catch (Exception e) {
            this.logger.error("Could not delete event file " + ifsPath, (Throwable)e);
        }
    }

    private EventFile loadIfsEventFile(IConnection pConn, String pIfsPath) {
        try {
            StringBuilder file = this.fUtils.loadIFSFile(pConn, pIfsPath, null);
            EventFile eventFile = new EventFile();
            Scanner scanner = new Scanner(file.toString());
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] split = line.split(":");
                if (split.length != 3) continue;
                EventFileEntry entry = new EventFileEntry();
                int cfr_ignored_0 = split.length;
                String fileName = split[0];
                String lineNumber = split[1];
                String sourceLine = split[2];
                eventFile.addFile(fileName.hashCode(), fileName);
                entry.setLine(Integer.parseInt(lineNumber));
                entry.setMessage(sourceLine);
                entry.setFileId(fileName.hashCode());
                eventFile.addEntry(entry);
            }
            return eventFile;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private EventFile loadQSysEventFile(IConnection conn, String ifsPath) {
        EventFile result = null;
        try {
            SequentialFile eventFile = new SequentialFile(conn.getSystem(), ifsPath);
            eventFile.setRecordFormat();
            Record[] records = eventFile.readAll();
            result = this.parseEventFileRecords(records);
            result.setConnection(conn);
            result.setIfsPath(ifsPath);
        }
        catch (AS400Exception ae) {
            if (ae.getAS400Message().getID().equals("CPF4102")) {
                this.logger.debug((Option)miworkplace.ui.debug.Option.compile, "*EVENTF not specified as compiler option.");
            } else {
                if (ae.getAS400Message().getID().equals("CPF3012")) {
                    this.logger.debug((Option)miworkplace.ui.debug.Option.compile, MessageFormat.format("Event file {0} not found. Error: {1}", ifsPath, ae.getMessage()));
                    QSYSObjectPathName qsysPath = new QSYSObjectPathName(ifsPath);
                    throw new NoEventFileException(qsysPath.getMemberName());
                }
                this.logger.error("Could not load event file at " + ifsPath, (Throwable)ae);
            }
        }
        catch (Exception e) {
            this.logger.error("Remote Search? Could not load event file at " + ifsPath, (Throwable)e);
        }
        return result;
    }

    private EventFile parseEventFileRecords(Record[] records) {
        EventFile result = new EventFile();
        this.logger.debug((Option)miworkplace.ui.debug.Option.compile, records.length + " event file entries");
        int i = 0;
        while (i < records.length) {
            try {
                String line = (String)records[i].getField(0);
                if (line.startsWith("TIMESTAMP")) {
                    parts = line.split(SPACE);
                    String stringTimestamp = parts[3];
                    result.setCreated(compileResultTimestampFormat.parse(stringTimestamp));
                } else if (!line.startsWith("PROCESSOR") && !line.startsWith("FILEIDCONT")) {
                    if (line.startsWith("FILEID")) {
                        parts = line.substring(0, 27).split(SPACE);
                        int fileId = Integer.parseInt(parts[6]);
                        int filePathLength = Integer.parseInt(parts[8]);
                        String filePath = line.substring(28, 28 + filePathLength);
                        filePath = EventFileLoader.convertQsysPathToIfsPath(filePath);
                        result.addFile(fileId, filePath);
                        this.logger.debug((Option)miworkplace.ui.debug.Option.compile, "Event file entries for file " + filePath);
                    } else if (!line.startsWith("FILEEND")) {
                        if (line.startsWith("ERROR")) {
                            parts = line.substring(11, 65).split(SPACE);
                            if (parts[8].equals("FNDSTR")) {
                                parts[9] = parts[10];
                                parts[10] = parts[11];
                                parts[11] = parts[12];
                            }
                            EventFileEntry entry = new EventFileEntry();
                            entry.setFileId(Integer.parseInt(parts[1]));
                            entry.setLine(Integer.parseInt(parts[3]));
                            entry.setColumnStart(Integer.parseInt(parts[5]));
                            entry.setColumnEnd(Integer.parseInt(parts[7]));
                            entry.setMessageId(parts[8]);
                            entry.setSeverityCode(parts[9]);
                            entry.setSeverityLevel(Integer.parseInt(parts[10]));
                            int messageLength = Integer.parseInt(parts[11]);
                            entry.setMessage(line.substring(65, 65 + messageLength));
                            result.addEntry(entry);
                            this.logger.debug((Option)miworkplace.ui.debug.Option.compile, MessageFormat.format("String selection at line {0} offset {1}", entry.getLine(), entry.getColumnStart()));
                        } else if (!(line.startsWith("PROGRAM") || line.startsWith("MAPDEFINE") || line.startsWith("MAPSTART") || line.startsWith("MAPEND") || line.startsWith("FEEDBACK"))) {
                            this.logger.info((Option)miworkplace.ui.debug.Option.compile, "Unsupported event file line: " + line);
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(MessageFormat.format("Skipped line {0} of the event file.", i), (Throwable)e);
            }
            ++i;
        }
        return result;
    }

    private String buildRemoveEventFileMemberCommand(String ifsPath) {
        QSYSObjectPathName memberPath = new QSYSObjectPathName(ifsPath);
        String command = "RMVM FILE(" + memberPath.getLibraryName().trim() + "/" + memberPath.getObjectName().trim() + ") MBR(" + memberPath.getMemberName().trim() + ")";
        return command;
    }

    private String buildRemoveEventFileCommand(String ifsPath) {
        QSYSObjectPathName filePath = new QSYSObjectPathName(ifsPath);
        String command = "DLTF FILE(" + filePath.getLibraryName().trim() + "/" + filePath.getObjectName().trim() + ")";
        return command;
    }

    public static String convertQsysPathToIfsPath(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String[] parts = path.split("[\\(\\)\\/]", 4);
        return QSYSObjectPathName.toPath((String)parts[0], (String)parts[1], (String)parts[2], (String)"MBR");
    }
}

