/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.dialog;

import com.ibm.as400.access.Record;
import com.ibm.as400.access.SequentialFile;
import miworkplace.common.model.SourceMember;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import org.apache.commons.lang3.StringUtils;

class SourceContentLoader {
    private SourceMember member;

    public SourceContentLoader(SourceMember member) {
        this.member = member;
    }

    public String load() {
        String memberPath = this.member.getPath();
        StringBuilder content = new StringBuilder();
        SequentialFile file = new SequentialFile(this.member.getConnection().getSystem(), memberPath);
        try {
            file.setRecordFormat();
            Record[] records = file.readAll();
            int i = 0;
            while (i < records.length) {
                content.append(StringUtils.stripEnd((String)records[i].getField(2).toString().replaceAll("\\s+$", ""), null) + System.getProperty("line.separator"));
                ++i;
            }
            return content.toString();
        }
        catch (Exception exception) {
            Notifier.error((String)Messages.ui_dialog_export_load_title, (String)String.format(Messages.ui_dialog_export_load_error, memberPath));
            return null;
        }
    }
}

