/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.dialog;

import com.ibm.as400.access.AS400SecurityException;
import java.io.InputStream;
import java.net.UnknownHostException;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.i18n.Messages;
import miworkplace.images.service.Factory;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class LoginDialog
extends TitleAreaDialog {
    private Text txtUser;
    private Text txtPass;
    private IConnection connection;
    private Debug logger = Debug.getInstance();

    public LoginDialog(Shell shell, IConnection connection) {
        super(shell);
        this.connection = connection;
        this.setHelpAvailable(false);
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        parent.pack();
        return content;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Rectangle bounds = this.getShell().getBounds();
        Point location = this.getInitialLocation(new Point(bounds.width, bounds.height));
        this.getShell().setBounds(location.x, location.y, bounds.width, bounds.height);
    }

    protected Point getInitialLocation(Point initialSize) {
        Composite parent = this.getShell().getParent();
        Monitor monitor = this.getShell().getDisplay().getPrimaryMonitor();
        if (parent != null) {
            monitor = parent.getMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Point centerPoint = parent != null ? Geometry.centerPoint((Rectangle)parent.getBounds()) : Geometry.centerPoint((Rectangle)monitorBounds);
        return new Point(centerPoint.x - initialSize.x / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - initialSize.y * 2 / 3, monitorBounds.y + monitorBounds.height - initialSize.y)));
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ui_dialog_login_title);
        this.setMessage(String.format(Messages.ui_dialog_login_desc, this.connection.getName(), this.connection.getSystemName()));
        this.setTitleImage(Factory.create((Widget)parent, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/icons/login-dialogtitle.png")));
        parent.getShell().setText(Messages.ui_dialog_login_title);
        Composite p = (Composite)super.createDialogArea(parent);
        Composite controls = new Composite(p, 0);
        controls.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        controls.setLayout((Layout)new GridLayout(2, false));
        new Label(controls, 0);
        new Label(controls, 0);
        Label lblUser = new Label(controls, 0);
        lblUser.setText(Messages.ui_dialog_login_username);
        this.txtUser = new Text(controls, 2048);
        GridData gd_txtUser = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtUser.minimumWidth = 300;
        this.txtUser.setLayoutData((Object)gd_txtUser);
        this.txtUser.setText(StringUtils.defaultString((String)this.connection.getUsername()));
        Label lblPass = new Label(controls, 0);
        lblPass.setText(Messages.ui_dialog_login_password);
        this.txtPass = new Text(controls, 0x400800);
        this.txtPass.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txtPass.setEchoChar('*');
        new Label(controls, 0);
        new Label(controls, 0);
        if (this.connection.getUsername() == null || this.connection.getUsername().length() == 0) {
            this.txtUser.setFocus();
        } else {
            this.txtPass.setFocus();
        }
        return p;
    }

    protected void okPressed() {
        this.connection.setUsername(this.txtUser.getText());
        this.connection.setPassword(this.txtPass.getText());
        try {
            this.connection.connect(this.txtPass.getText());
            super.okPressed();
            return;
        }
        catch (AS400SecurityException ase) {
            this.logger.error(ase.getMessage(), (Throwable)ase);
            String message = this.handleSecurityException(ase);
            this.setErrorMessage(message);
        }
        catch (UnknownHostException unknownHostException) {
            this.setErrorMessage(String.format(Messages.ui_dialog_login_error_host, this.connection.getSystemName()));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.setErrorMessage(Messages.ui_dialog_login_failed + " - " + e.getMessage());
        }
        if (this.connection.isConnected()) {
            try {
                this.connection.disconnect();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String handleSecurityException(AS400SecurityException ase) {
        switch (ase.getReturnCode()) {
            case 8: 
            case 10: 
            case 29: 
            case 32: 
            case 63: {
                return Messages.ui_dialog_login_error_creds;
            }
            case 7: {
                return Messages.ui_dialog_login_error_expired;
            }
            case 9: {
                return Messages.ui_dialog_login_error_willdis;
            }
            case 31: {
                return Messages.ui_dialog_login_error_disabled;
            }
        }
        return Messages.ui_dialog_login_failed;
    }
}

