/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.dialog;

import com.ibm.as400.access.Job;
import com.remainsoftware.common.util.ServiceUtils;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.IConnection;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.dialog.Library;
import miworkplace.ui.widgets.LibraryList;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class LibraryListDialog
extends TrayDialog {
    private final Debug logger = Debug.getInstance();
    @Inject
    private final IConnection connection;
    @Inject
    EHelpService fHelpService;
    private final List<Library> libraries;
    private final List<String> userLibraries = new ArrayList<String>();
    private LibraryList fUserList;

    @Inject
    public LibraryListDialog(Shell shell, IConnection connection) {
        super(shell);
        this.connection = connection;
        this.libraries = this.getLibraryList(connection);
    }

    private List<Library> getLibraryList(IConnection connection) {
        String library;
        int n;
        int n2;
        String[] stringArray;
        LinkedList<Library> libraries = new LinkedList<Library>();
        Job[] jobs = connection.getSystem().getJobs(2);
        if (jobs == null || jobs.length == 0) {
            return libraries;
        }
        Job job = jobs[0];
        try {
            String[] systemLibraryList = job.getSystemLibraryList();
            if (systemLibraryList != null) {
                stringArray = systemLibraryList;
                n2 = systemLibraryList.length;
                n = 0;
                while (n < n2) {
                    library = stringArray[n];
                    libraries.add(new Library(library, "*SYSTEM"));
                    ++n;
                }
            }
        }
        catch (Exception e) {
            Notifier.error((String)Messages.ui_dialog_libl_title, (String)Messages.ui_dialog_libl_system_error);
            this.logger.error("Could not get system part of the library list.", (Throwable)e);
        }
        try {
            if (job.getCurrentLibraryExistence()) {
                libraries.add(new Library(job.getCurrentLibrary(), "*CURRENT"));
            }
        }
        catch (Exception e) {
            Notifier.error((String)Messages.ui_dialog_libl_title, (String)Messages.ui_dialog_libl_current_error);
            this.logger.error("Could not get current library.", (Throwable)e);
        }
        try {
            String[] userLibraryList = job.getUserLibraryList();
            if (userLibraryList != null) {
                stringArray = userLibraryList;
                n2 = userLibraryList.length;
                n = 0;
                while (n < n2) {
                    library = stringArray[n];
                    libraries.add(new Library(library, "*USER"));
                    this.userLibraries.add(library);
                    ++n;
                }
            }
        }
        catch (Exception e) {
            Notifier.error((String)Messages.ui_dialog_libl_title, (String)Messages.ui_dialog_libl_user_error);
            this.logger.error("Could not get user part of the library list.", (Throwable)e);
        }
        return libraries;
    }

    public Control createDialogArea(Composite parent) {
        parent.getShell().setText(String.format(Messages.ui_dialog_libl_shell_title, this.connection.getName()));
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        container.setLayout((Layout)gridLayout);
        Group grpSystemLibraryList = new Group(container, 0);
        grpSystemLibraryList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpSystemLibraryList.setText(Messages.ui_dialog_libl_syslibl);
        grpSystemLibraryList.setLayout((Layout)new FillLayout(256));
        TableViewer viewer = new TableViewer((Composite)grpSystemLibraryList, 2560);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LibraryListLabelProvider());
        this.createTableViewerColumn(viewer, Messages.ui_dialog_libl_col_library, 200);
        this.createTableViewerColumn(viewer, Messages.ui_dialog_libl_col_part, 100);
        viewer.setInput(this.libraries.stream().filter(lib -> !"*USER".equals(lib.type)).collect(Collectors.toList()));
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Group grpUserLibraryList = new Group(container, 0);
        grpUserLibraryList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpUserLibraryList.setText(Messages.ui_dialog_libl_userlibl);
        grpUserLibraryList.setLayout((Layout)new FillLayout(256));
        this.fUserList = new LibraryList((Composite)grpUserLibraryList, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fUserList);
        this.fUserList.setInput(this.userLibraries.toArray(new String[0]));
        this.fHelpService.setHelp((Object)container, "miworkplace.help.MIW: Connections/Library List");
        return container;
    }

    private void createTableViewerColumn(TableViewer viewer, String title, int width) {
        Table table = viewer.getTable();
        TableColumn column = new TableColumn(table, 0);
        column.setText(title);
        column.setWidth(width);
        column.setResizable(true);
        column.setMoveable(true);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        try {
            this.connection.setUserLibraryList(Arrays.asList(this.fUserList.getElements()));
            this.connection.setCustomUserLibraries(Arrays.asList(this.fUserList.getElements()));
            ((IConnectionManager)ServiceUtils.getOSGiService(((Object)((Object)this)).getClass(), IConnectionManager.class)).update(this.connection);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)Messages.ui_dialog_liblerrSettingLibl, (String)e.getMessage());
            this.logger.error("Issue processing library list", (Throwable)e);
        }
        super.okPressed();
    }

    class LibraryListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        LibraryListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((Library)element).name;
                }
                case 1: {
                    return ((Library)element).type;
                }
            }
            return "";
        }
    }
}

