/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.dialog;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Scanner;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.dialog.EncodingUtil;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class FeedbackDialog
extends TitleAreaDialog {
    private static final String EXT_TXT = ".txt";
    @Inject
    private IWorkspace workspace;
    private Text fSummary;
    private Button addEnvironmentInformation;
    private Button addBundleInformation;
    private Button addSessionLog;
    private Text content;
    private Text fEmail;

    @Inject
    public FeedbackDialog(@Named(value="activeShell") Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ui_dialog_feedback_title);
        this.getShell().setText(Messages.ui_dialog_feedback_title);
        this.setMessage(Messages.ui_dialog_feedback_desc);
        this.setTitleImage(new Image((Device)parent.getShell().getDisplay(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/bug-wizard.png")));
        Composite controls = new Composite(parent, 0);
        controls.setLayout((Layout)new GridLayout(2, false));
        controls.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(controls, 0);
        new Label(controls, 0);
        Label label = new Label(controls, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText("Subject:");
        this.fSummary = new Text(controls, 2048);
        this.fSummary.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fSummary.setMessage(Messages.ui_dialog_feedback_bug_prompt);
        this.content = new Text(controls, 2050);
        GridData gd_content = new GridData(4, 4, true, true, 2, 1);
        gd_content.heightHint = 400;
        this.content.setLayoutData((Object)gd_content);
        this.content.setMessage(Messages.ui_dialog_feedback_prompt);
        this.addEnvironmentInformation = new Button(controls, 32);
        this.addEnvironmentInformation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.addEnvironmentInformation.setText(Messages.ui_dialog_feedback_env);
        this.addEnvironmentInformation.setSelection(true);
        this.addBundleInformation = new Button(controls, 32);
        this.addBundleInformation.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.addBundleInformation.setText(Messages.ui_dialog_feedback_bundle);
        this.addBundleInformation.setSelection(true);
        this.addSessionLog = new Button(controls, 32);
        this.addSessionLog.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.addSessionLog.setText(Messages.ui_dialog_feedback_log);
        this.addSessionLog.setSelection(true);
        this.fSummary.setFocus();
        return controls;
    }

    protected void okPressed() {
        try {
            this.sendMail("helpdesk@remainsoftware.com", this.composeSubject(), this.composeBody());
            super.okPressed();
        }
        catch (Exception e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error("dialog_message_error_image", (Throwable)e);
            Notifier.error((String)e.getMessage(), (String)MessageFormat.format("An error occured during sending of the feedback. Please see the log for more information. ({0})", e.getMessage()));
        }
    }

    private void checkMailAddress(String pText) {
        if (!pText.matches(".+?@.+?\\..+?")) {
            throw new RuntimeException("Invalid e-mail address.");
        }
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Button createButton(Composite pParent, int pId, String pLabel, boolean pDefaultButton) {
        if (pId == 0) {
            return super.createButton(pParent, pId, Messages.ui_dialog_feedback_send, pDefaultButton);
        }
        return super.createButton(pParent, pId, pLabel, pDefaultButton);
    }

    private String composeBody() {
        StringBuilder sb = new StringBuilder(this.content.getText());
        sb.append("\n");
        ArrayList<String> files = new ArrayList<String>();
        if (this.addEnvironmentInformation.getSelection()) {
            files.add(this.addEnvInformationToMailContent(sb));
        }
        if (this.addBundleInformation.getSelection()) {
            files.add(this.addBundleInformationToMailContent(sb));
        }
        if (this.addSessionLog.getSelection()) {
            files.add(this.addSessionLogToMailContent(sb));
        }
        if (!files.isEmpty()) {
            FileDialog d = new FileDialog(this.getParentShell(), 4098);
            d.setFilterPath(System.getProperty("java.io.tmpdir"));
            d.setFilterExtensions(new String[]{"MiW*.txt"});
            d.setText("Attach these files to the mail");
            this.getShell().getDisplay().asyncExec(() -> ((FileDialog)d).open());
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String addEnvInformationToMailContent(StringBuilder sb) {
        try {
            File file = File.createTempFile("MiWEnvironment", EXT_TXT);
            sb.append("\n");
            sb.append("Please attach file: " + file.getAbsolutePath());
            sb.append("\n");
            StringBuffer fileBuf = new StringBuffer();
            fileBuf.append("*** Application Arguments ***");
            fileBuf.append("\n");
            String[] arguments = Platform.getApplicationArgs();
            Object object = arguments;
            int n = arguments.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = object[n2];
                fileBuf.append(arg + "\n");
                ++n2;
            }
            fileBuf.append("\n");
            fileBuf.append("*** System Properties ***");
            fileBuf.append("\n");
            LinkedList<CallSite> sortingList = new LinkedList<CallSite>();
            Enumeration<Object> keys = System.getProperties().keys();
            while (keys.hasMoreElements()) {
                String string = keys.nextElement().toString();
                sortingList.add((CallSite)((Object)(string + ": " + System.getProperty(string) + "\n")));
            }
            Collections.sort(sortingList);
            for (String string : sortingList) {
                fileBuf.append(string);
            }
            Throwable throwable = null;
            object = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(fileBuf.toString().getBytes());
            }
            catch (Throwable throwable2) {
                void var7_13;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var7_13;
            }
            return file.getName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String addBundleInformationToMailContent(StringBuilder sb) {
        try {
            File file = File.createTempFile("MiWBundles", EXT_TXT);
            sb.append("Please attach file: " + file.getAbsolutePath());
            sb.append("\n");
            StringBuffer fileBuf = new StringBuffer();
            fileBuf.append("\n");
            fileBuf.append("*** Installed Bundles ***");
            fileBuf.append("\n");
            LinkedList<CallSite> sortingList = new LinkedList<CallSite>();
            BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
            Bundle[] bundleArray = bundleContext.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle throwable = bundleArray[n2];
                Dictionary headers = throwable.getHeaders();
                sortingList.add((CallSite)((Object)(((String)headers.get("Bundle-SymbolicName")).split(";")[0] + " (" + (String)headers.get("Bundle-Version") + ") \"" + (String)headers.get("Bundle-Name") + "\" - " + this.getBundleState(throwable) + "\n")));
                ++n2;
            }
            Collections.sort(sortingList);
            for (String string : sortingList) {
                fileBuf.append(string);
            }
            Throwable throwable = null;
            Iterator iterator = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(fileBuf.toString().getBytes());
            }
            catch (Throwable throwable2) {
                void var6_18;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var6_18;
            }
            return file.getName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String addSessionLogToMailContent(StringBuilder sb) {
        try {
            StringBuffer fileBuf;
            File file;
            block23: {
                file = File.createTempFile("MiWLog", EXT_TXT);
                sb.append("Please attach file: " + file.getAbsolutePath());
                sb.append("\n");
                fileBuf = new StringBuffer();
                IPath logFilePath = this.workspace.getRoot().getLocation().append(".metadata").append(".log");
                Scanner scanner = null;
                try {
                    int x = 0;
                    LinkedList<String> logfileEntries = new LinkedList<String>();
                    scanner = new Scanner(logFilePath.toFile());
                    while (scanner.hasNextLine()) {
                        logfileEntries.add(scanner.nextLine());
                        if (!((String)logfileEntries.get(logfileEntries.size() - 1)).startsWith("!SESSION")) continue;
                        x = logfileEntries.size() - 1;
                    }
                    fileBuf.append("\n");
                    Iterator iter = logfileEntries.subList(x, logfileEntries.size() - 1).iterator();
                    while (iter.hasNext()) {
                        fileBuf.append((String)iter.next());
                        fileBuf.append("\n");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileBuf.append("\n\n");
                    fileBuf.append("Log file not found.");
                    if (scanner != null) {
                        scanner.close();
                    }
                    break block23;
                }
                catch (Exception e) {
                    try {
                        fileBuf.append("\n\n");
                        fileBuf.append("Could not append session log: " + e.getMessage());
                        break block23;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (scanner != null) {
                            scanner.close();
                        }
                    }
                }
                if (scanner != null) {
                    scanner.close();
                }
            }
            Throwable throwable = null;
            Object var7_10 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(fileBuf.toString().getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return file.getName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getBundleState(Bundle bundle) {
        switch (bundle.getState()) {
            case 32: {
                return "active";
            }
            case 2: {
                return "installed";
            }
            case 4: {
                return "resolved";
            }
            case 8: {
                return "starting";
            }
            case 16: {
                return "stopping";
            }
            case 1: {
                return "uninstalled";
            }
        }
        return "unknown";
    }

    private String composeSubject() {
        return "MiWorkplace : " + this.fSummary.getText();
    }

    private void sendMail(String to, String subject, String body) throws Exception {
        String link = "mailto:" + to + "?subject=" + EncodingUtil.encodeURIComponent(subject) + "&body=" + EncodingUtil.encodeURIComponent(body);
        Desktop.getDesktop().mail(URI.create(link));
    }

    protected boolean isResizable() {
        return true;
    }
}

