/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.console;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.TextAttribute;
import miworkplace.services.api.ITextAttributeService;
import miworkplace.ui.api.ConsoleEntryType;
import miworkplace.ui.api.WorkspaceUtil;
import miworkplace.ui.themes.Colors;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.json.JSONArray;
import org.osgi.service.event.Event;

public class ConsoleView {
    private Debug logger = Debug.getInstance();
    @Inject
    private ITextAttributeService textAttributeService;
    @Inject
    private IStylingEngine stylingEngine;
    private Map<String, IDocument> documents = new HashMap<String, IDocument>();
    private TextViewer viewer;
    private String currentProcess;

    @PostConstruct
    public void postConstruct(Composite parent) throws Exception {
        parent.setLayout((Layout)new GridLayout());
        this.viewer = new SourceViewer(parent, null, 776);
        this.viewer.setDocument((IDocument)new Document());
        this.viewer.getTextWidget().setFont(this.buildFont(this.viewer.getTextWidget().getFont(), parent.getDisplay()));
        this.stylingEngine.setClassname((Object)this.viewer.getTextWidget(), "miworkplace-editor-text");
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        WorkspaceUtil.setHelp((Widget)parent, "miworkplace.help.MIW: Console");
    }

    @Inject
    @Optional
    public void notifiedConsoleOutput(@UIEventTopic(value="miworkplace/ui/console/new") Event event) {
        String process = event.getProperty("process").toString();
        String data = event.getProperty("org.eclipse.e4.data").toString();
        ConsoleEntryType type = (ConsoleEntryType)((Object)event.getProperty("type"));
        if (!this.documents.containsKey(process)) {
            this.documents.put(process, (IDocument)new Document());
        }
        IDocument document = this.documents.get(process);
        try {
            int documentLength = document.getLength();
            document.replace(document.getLength(), 0, data);
            if (this.currentProcess == null) {
                this.viewer.setDocument(document);
            } else if (!this.currentProcess.equals(process)) {
                this.viewer.setDocument(document);
            }
            if (type == ConsoleEntryType.Error) {
                Color color = Colors.instance().get(Colors.ColorDefinition.Function);
                this.viewer.setTextColor(color, documentLength, data.length(), true);
            }
            this.viewer.setTopIndex(document.getNumberOfLines());
            this.currentProcess = process;
        }
        catch (BadLocationException e) {
            this.logger.error("Could not output data to console view.", (Throwable)e);
        }
    }

    private Font buildFont(Font defaultFont, Display display) throws Exception {
        String s;
        TextAttribute ta = this.textAttributeService.get("miworkplace.ui.pref.text.basic.editor.font");
        if (ta != null && (s = ta.getValue()) != null) {
            JSONArray array = new JSONArray(s);
            FontData[] fontList = new FontData[array.length()];
            int i = 0;
            while (i < array.length()) {
                fontList[i] = new FontData(array.getString(i));
                ++i;
            }
            Font f = new Font((Device)display, fontList);
            return f;
        }
        return defaultFont;
    }

    public List<String> getProcesses() {
        ArrayList<String> processes = new ArrayList<String>(this.documents.keySet());
        return processes;
    }

    public void switchDocument(String process) {
        if (process.equals(this.currentProcess)) {
            return;
        }
        if (this.documents.containsKey(process)) {
            this.viewer.setDocument(this.documents.get(process));
        }
    }

    public void clearConsole() {
        this.viewer.getDocument().set("");
    }

    public void removeCurrentProcess() {
        this.documents.remove(this.currentProcess);
        this.viewer.setDocument((IDocument)new Document());
        this.currentProcess = null;
    }

    public void removeAllProcesses() {
        this.documents.clear();
        this.viewer.setDocument((IDocument)new Document());
        this.currentProcess = null;
    }
}

