/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.connection;

import java.util.HashMap;
import miworkplace.common.Commands;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.services.api.IDoubleClickExecutor;
import miworkplace.services.api.IDoubleClickServiceProvider;
import miworkplace.ui.connection.handler.OpenConnectionHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;

public class ConnectionDoubleClickExecutor
implements IDoubleClickExecutor {
    private Debug logger = Debug.getInstance();

    void bindDoubleClickProvider(IDoubleClickServiceProvider service) {
        service.register((IDoubleClickExecutor)this);
    }

    void unbindDoubleClickProvider(IDoubleClickServiceProvider service) {
        service.deregister((IDoubleClickExecutor)this);
    }

    public void execute(Object obj, EHandlerService handlerService, ECommandService commandService) {
        if (obj instanceof IConnection) {
            Command command = commandService.getCommand(Commands.OpenConnection.id());
            if (command.isDefined()) {
                handlerService.activateHandler("miworkplace.ui.handler.openConnection", (Object)new OpenConnectionHandler());
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("miworkplace.ui.command.openConnection.parameter.connection", ((IConnection)obj).getName());
                ParameterizedCommand cmd = commandService.createCommand(Commands.OpenConnection.id(), parameters);
                handlerService.executeHandler(cmd);
            } else {
                this.logger.debug((Option)miworkplace.ui.debug.Option.lifeCycle, "Command for opening connection is not defined. Command Id: miworkplace.ui.handler.openConnection");
            }
        }
    }

    public boolean canExecute(ECommandService commandService, Object object) {
        return object instanceof IConnection;
    }

    public Integer getRanking() {
        return 1;
    }
}

