/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.SourceMember;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.services.api.ObjectProperty;
import miworkplace.ui.api.ICompileArgumentResolver;
import org.osgi.service.log.LogService;

public class MemberPropertyArgumentResolver
implements ICompileArgumentResolver {
    private LogService logger;
    private IObjectPropertiesStore propertiesStore;

    public void bindLogService(LogService logger) {
        this.logger = logger;
    }

    public void unbindLogService(LogService logger) {
        this.logger = null;
    }

    void bindObjectPropertiesStore(IObjectPropertiesStore propertiesStore) {
        this.propertiesStore = propertiesStore;
    }

    void unbindObjectPropertiesStore(IObjectPropertiesStore propertiesStore) {
        this.propertiesStore = null;
    }

    @Override
    public String resolve(IRemoteObject sourceObject, String key) {
        ObjectProperty searchedProperty;
        if (!(sourceObject instanceof SourceMember)) {
            return null;
        }
        SourceMember member = (SourceMember)sourceObject;
        Map properties = this.propertiesStore.get((IRemoteObject)member, true);
        try {
            searchedProperty = ObjectProperty.valueOf((String)key);
        }
        catch (Exception exception) {
            try {
                searchedProperty = ObjectProperty.valueOf((String)key.toLowerCase());
            }
            catch (Exception exception2) {
                return null;
            }
        }
        Object property = properties.get(searchedProperty);
        if (property == null) {
            return null;
        }
        this.logger.log(4, key + " resolved by " + this.getClass().getName());
        if (property instanceof Date) {
            DateFormat formatter = SimpleDateFormat.getDateInstance(3, Locale.getDefault());
            return formatter.format((Date)property);
        }
        return property.toString();
    }
}

