/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import java.util.ArrayList;
import miworkplace.ui.api.EventFileEntry;
import miworkplace.ui.compile.CompileResult;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class CompileResultSorter
extends ViewerComparator {
    public static final boolean SORT_ASCENDING = false;
    public static final boolean SORT_DESCENDING = true;
    public static final int SORT_TYPE = 1;
    public static final int SORT_SEVERITY = 2;
    public static final int SORT_TEXT = 3;
    public static final int SORT_SOURCE_FILE = 4;
    public static final int SORT_MESSAGE_ID = 5;
    public static final int SORT_LINE = 6;
    private int criteria = 1;
    private boolean sortDirection = true;
    private ArrayList<String> severityCodes = new ArrayList();

    public CompileResultSorter(int criteria, boolean sortDirection) {
        this.criteria = criteria;
        this.sortDirection = sortDirection;
        this.severityCodes.add("I");
        this.severityCodes.add("W");
        this.severityCodes.add("E");
        this.severityCodes.add("S");
        this.severityCodes.add("T");
    }

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        EventFileEntry entry1 = (EventFileEntry)obj1;
        EventFileEntry entry2 = (EventFileEntry)obj2;
        int retVal = 1;
        switch (this.criteria) {
            case 1: {
                int severityCodeIndex1 = this.severityCodes.indexOf(entry1.getSeverityCode());
                int severityCodeIndex2 = this.severityCodes.indexOf(entry2.getSeverityCode());
                if (severityCodeIndex1 == severityCodeIndex2) {
                    retVal = 0;
                    break;
                }
                if (severityCodeIndex1 < severityCodeIndex2) {
                    retVal = -1;
                    break;
                }
                retVal = 1;
                break;
            }
            case 2: {
                if (entry1.getSeverityLevel() == entry2.getSeverityLevel()) {
                    retVal = 0;
                    break;
                }
                if (entry1.getSeverityLevel() < entry2.getSeverityLevel()) {
                    retVal = -1;
                    break;
                }
                retVal = 1;
                break;
            }
            case 5: {
                retVal = entry1.getMessageId().compareTo(entry2.getMessageId());
                break;
            }
            case 6: {
                if (entry1.getLine() == entry2.getLine()) {
                    retVal = 0;
                    break;
                }
                if (entry1.getLine() < entry2.getLine()) {
                    retVal = -1;
                    break;
                }
                retVal = 1;
                break;
            }
            case 3: {
                retVal = entry1.getMessage().compareTo(entry2.getMessage());
                break;
            }
            case 4: {
                CompileResult result = (CompileResult)viewer.getInput();
                retVal = result.getFile(entry1.getFileId()).compareTo(result.getFile(entry2.getFileId()));
                break;
            }
            default: {
                retVal = 1;
            }
        }
        if (this.criteria != 6 && retVal == 0) {
            retVal = entry1.getLine() == entry2.getLine() ? 0 : (entry1.getLine() < entry2.getLine() ? -1 : 1);
        } else if (this.isSortDescending()) {
            retVal *= -1;
        }
        return retVal;
    }

    public int getCriteria() {
        return this.criteria;
    }

    public boolean isSortDescending() {
        return this.sortDirection;
    }
}

