/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import miworkplace.ui.compile.CommandOptionContentProposal;
import miworkplace.ui.compile.CommandParameter;
import miworkplace.ui.compile.CommandParameterOption;
import miworkplace.ui.compile.ReplacingTextContentAdapter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class CommandContentProposalProvider
implements IContentProposalProvider {
    private IContentProposal[] keywordProposals;
    private Map<String, IContentProposal[]> optionProposals = new HashMap<String, IContentProposal[]>();
    private ReplacingTextContentAdapter contentAdapter;

    public CommandContentProposalProvider(ReplacingTextContentAdapter contentAdapter) {
        this.contentAdapter = contentAdapter;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        String input = this.getInputBeginning(contents, position);
        String keyword = this.getKeyword(input);
        LinkedList<IContentProposal> validProposals = new LinkedList<IContentProposal>();
        if (keyword.equals(input)) {
            this.contentAdapter.setReplaceableContents(input);
            input = input.toUpperCase();
            IContentProposal[] iContentProposalArray = this.keywordProposals;
            int n = this.keywordProposals.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProposal keywordProposal = iContentProposalArray[n2];
                if (keywordProposal.getContent().startsWith(input)) {
                    validProposals.add(keywordProposal);
                }
                ++n2;
            }
        } else {
            String optionInput = this.getOptionBeginning(input);
            this.contentAdapter.setReplaceableContents(optionInput);
            optionInput = optionInput.toUpperCase();
            IContentProposal[] optionProposalCandidates = this.optionProposals.get(keyword);
            if (optionProposalCandidates != null) {
                IContentProposal[] iContentProposalArray = optionProposalCandidates;
                int n = optionProposalCandidates.length;
                int n3 = 0;
                while (n3 < n) {
                    IContentProposal keywordProposal = iContentProposalArray[n3];
                    if (keywordProposal.getContent().startsWith(optionInput)) {
                        validProposals.add(keywordProposal);
                    }
                    ++n3;
                }
            }
        }
        validProposals.addAll(this.getVariables(input));
        Collections.sort(validProposals, new Comparator<IContentProposal>(){

            @Override
            public int compare(IContentProposal p1, IContentProposal p2) {
                return p1.getLabel().compareTo(p2.getLabel());
            }
        });
        return validProposals.toArray(new IContentProposal[validProposals.size()]);
    }

    private List<IContentProposal> getVariables(String pInput) {
        ArrayList<IContentProposal> result = new ArrayList<IContentProposal>();
        int index = pInput.lastIndexOf("$");
        if (index == -1) {
            return result;
        }
        String input = pInput.substring(index);
        String var = "${name}";
        String desc = "The object name";
        this.addProposal(result, input, var, desc);
        var = "${changeDate}";
        desc = "Member change date";
        this.addProposal(result, input, var, desc);
        var = "${creationDate}";
        desc = "Member creation date";
        this.addProposal(result, input, var, desc);
        var = "${lastUsedDate}";
        desc = "Member last use date";
        this.addProposal(result, input, var, desc);
        var = "${fileName}";
        desc = "File name";
        this.addProposal(result, input, var, desc);
        var = "${library}";
        desc = "Library name";
        this.addProposal(result, input, var, desc);
        var = "${name}";
        desc = "Member name";
        this.addProposal(result, input, var, desc);
        var = "${textDescription}";
        desc = "Member description";
        this.addProposal(result, input, var, desc);
        var = "${daysUsed}";
        desc = "Days used ";
        this.addProposal(result, input, var, desc);
        var = "${restoreDate}";
        desc = "Restore date";
        this.addProposal(result, input, var, desc);
        var = "${saveDate}";
        desc = "Save date";
        this.addProposal(result, input, var, desc);
        var = "${attribute}";
        desc = "Member attribute";
        this.addProposal(result, input, var, desc);
        var = "${streamfile}";
        desc = "name of the stream file (including the suffix of the file)";
        this.addProposal(result, input, var, desc);
        var = "${basename}";
        desc = "name of the stream file without the suffix";
        this.addProposal(result, input, var, desc);
        var = "${ifspath}";
        desc = "absolute path of the stream file";
        this.addProposal(result, input, var, desc);
        return result;
    }

    private void addProposal(List<IContentProposal> result, String input, String var, String desc) {
        if (var.startsWith(input)) {
            result.add((IContentProposal)new CommandOptionContentProposal(var, var, desc, var.length(), false));
        }
    }

    public String getOptionBeginning(String contents) {
        if (StringUtils.isBlank((CharSequence)contents)) {
            return "";
        }
        if (contents.trim().endsWith("(")) {
            return "";
        }
        int i = contents.length() - 1;
        while (i >= 0) {
            if (contents.charAt(i) == '(') {
                return contents.substring(i + 1);
            }
            if (contents.charAt(i) == ' ') {
                return contents.substring(i + 1);
            }
            if (contents.charAt(i) == '/') {
                return contents.substring(i + 1);
            }
            --i;
        }
        return "";
    }

    public String getInputBeginning(String contents, int position) {
        if (position == 0) {
            return "";
        }
        String interimValue = null;
        boolean openForTextValue = false;
        boolean openParanthesisMultiValue = false;
        int i = position - 1;
        while (i >= 0) {
            if (contents.charAt(i) == '\'') {
                openForTextValue = !openForTextValue;
            } else if (!openForTextValue) {
                if (contents.charAt(i) == '(') {
                    openParanthesisMultiValue = true;
                } else if (openParanthesisMultiValue) {
                    if (contents.charAt(i) == ' ' || contents.charAt(i) == '\t') {
                        interimValue = contents.substring(i + 1, position);
                        break;
                    }
                } else if (interimValue != null) {
                    if (contents.charAt(i) == ')') {
                        break;
                    }
                } else if (contents.charAt(i) == ' ' || contents.charAt(i) == '\t') {
                    interimValue = contents.substring(i + 1, position);
                }
            }
            --i;
        }
        if (openForTextValue) {
            return "";
        }
        if (openParanthesisMultiValue && interimValue != null && StringUtils.isBlank(interimValue)) {
            return contents.substring(0, position).endsWith(")") ? "" : contents.substring(0, position);
        }
        if (openParanthesisMultiValue && i == -1) {
            return contents.substring(0, position).endsWith(")") ? "" : contents.substring(0, position);
        }
        if (interimValue != null) {
            return interimValue.endsWith(")") ? "" : interimValue;
        }
        if (StringUtils.isNotBlank((CharSequence)contents.substring(0, position))) {
            return contents.substring(0, position).endsWith(")") ? "" : contents.substring(0, position);
        }
        return "";
    }

    public String getKeyword(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return "";
        }
        int start = 0;
        int end = input.length();
        int i = input.length() - 1;
        while (i >= 0) {
            if (input.charAt(i) == '(') {
                end = i;
            }
            --i;
        }
        return input.substring(start, end).trim();
    }

    public void setCommandParameters(List<CommandParameter> commandParameters) {
        this.optionProposals.clear();
        this.keywordProposals = new IContentProposal[0];
        LinkedList<ContentProposal> keywordProposalList = new LinkedList<ContentProposal>();
        LinkedList<CommandOptionContentProposal> optionProposalList = new LinkedList<CommandOptionContentProposal>();
        for (CommandParameter commandParameter : commandParameters) {
            ContentProposal contentProposal = new ContentProposal(commandParameter.keyword, commandParameter.keyword + " - " + commandParameter.name, commandParameter.description, commandParameter.keyword.length());
            keywordProposalList.add(contentProposal);
            if (commandParameter.options != null) {
                for (CommandParameterOption option : commandParameter.options) {
                    CommandOptionContentProposal optionProposal = new CommandOptionContentProposal(option.option, option.option, option.description, option.option.length(), option.placeholder);
                    optionProposalList.add(optionProposal);
                }
                this.optionProposals.put(commandParameter.keyword, optionProposalList.toArray(new IContentProposal[optionProposalList.size()]));
            }
            optionProposalList.clear();
        }
        this.keywordProposals = keywordProposalList.toArray(new IContentProposal[keywordProposalList.size()]);
    }
}

