/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui.api;

import com.ibm.as400.access.QSYSObjectPathName;
import com.remainsoftware.common.ui.util.UiUtils;
import com.remainsoftware.common.util.ServiceUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.QSYSObject;
import miworkplace.common.model.StreamFile;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IObjectPropertiesStore;
import miworkplace.ui.api.IRemoteEditor;
import miworkplace.ui.util.DirectoryLoader;
import miworkplace.ui.util.MemberLoader;
import miworkplace.ui.util.ObjectLoader;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.services.IEvaluationService;

public class WorkspaceUtil {
    public static final String QSYS_LIBRARY = "QSYS.LIB";
    private static IWorkspace workspace;
    private static IWorkspaceStore workspaceStore;
    private static IEclipseContext eclipseContext;

    public static void setWorkspace(IWorkspace workspace) {
        WorkspaceUtil.workspace = workspace;
    }

    public static void setWorkspaceStore(IWorkspaceStore workspaceStore) {
        WorkspaceUtil.workspaceStore = workspaceStore;
    }

    public static void setEclipseContext(IEclipseContext context) {
        eclipseContext = context;
    }

    public static IFolder getRoot(IConnection connection) {
        return WorkspaceUtil.getRoot(connection.getName());
    }

    public static IFolder getRoot(String connectionName) {
        return WorkspaceUtil.getWorkspace().getRoot().getProject("RemoteFileSystem").getFolder(connectionName);
    }

    public static IFolder getQsys(IConnection connection) {
        return WorkspaceUtil.getQsys(connection.getName());
    }

    public static IFolder getQsys(String connectionName) {
        return WorkspaceUtil.getRoot(connectionName).getFolder(QSYS_LIBRARY);
    }

    public static IResource buildObjectResource(IRemoteObject library, String name, IRemoteObject.Type type) {
        Object resource = null;
        IFolder folder = WorkspaceUtil.getQsys(library.getConnection());
        IFolder libraryResource = folder.getFolder(library.getName() + "." + library.getType().abbr().substring(1));
        resource = type == IRemoteObject.Type.file ? libraryResource.getFolder(name + "." + type.abbr().substring(1)) : libraryResource.getFile(name + "." + type.abbr().substring(1));
        return resource;
    }

    public static IResource buildStreamFileResource(IConnection connection, String path, boolean directory) {
        return WorkspaceUtil.buildStreamFileResource(connection.getName(), path, directory);
    }

    public static IResource buildStreamFileResource(String connectionName, String path, boolean directory) {
        IFolder root = WorkspaceUtil.getRoot(connectionName);
        Path strippedPath = new Path(StringUtils.strip((String)path, (String)"/"));
        return directory ? root.getFolder((IPath)strippedPath) : root.getFile((IPath)strippedPath);
    }

    public static IFile buildMemberFile(IRemoteObject sourceFile, String name) {
        String[] pathSegments = sourceFile.getPath().split("/");
        return WorkspaceUtil.getQsys(sourceFile.getConnection()).getFolder(pathSegments[2]).getFolder(pathSegments[3]).getFile(name + ".MBR");
    }

    public static IFile buildMemberFile(String memberPath, String connection) {
        String[] pathSegments = memberPath.split("/");
        return WorkspaceUtil.getQsys(connection).getFolder(pathSegments[2]).getFolder(pathSegments[3]).getFile(pathSegments[pathSegments.length - 1]);
    }

    public static IRemoteObject load(IConnection connection, String path) {
        if (path.toUpperCase().startsWith("/QSYS.LIB/")) {
            return WorkspaceUtil.loadQsysLibPath(connection, path);
        }
        return WorkspaceUtil.loadIfsPath(connection, path);
    }

    public static void updateHandlerEnablement() {
        IEventBroker broker = (IEventBroker)WorkspaceUtil.getEclipseContext().get(IEventBroker.class);
        broker.post("org/eclipse/e4/ui/renderer/requestEnablementUpdate", null);
    }

    public static void requestEvaluation() {
        IEvaluationService evaluationService = (IEvaluationService)WorkspaceUtil.getEclipseContext().get(IEvaluationService.class);
        evaluationService.requestEvaluation("activePart");
    }

    public static void setHelp(Widget pWidget, String pHelpLink) {
        EHelpService help = (EHelpService)WorkspaceUtil.getEclipseContext().get(EHelpService.class);
        help.setHelp((Object)pWidget, pHelpLink);
    }

    public static void runCommand(String pCommandId, IEclipseContext pContext) {
        ECommandService cmdService = (ECommandService)pContext.get(ECommandService.class);
        ParameterizedCommand command = cmdService.createCommand(pCommandId, null);
        EHandlerService hndlrService = (EHandlerService)pContext.get(EHandlerService.class);
        hndlrService.executeHandler(command, pContext);
    }

    public static List<MPart> getMiWEditors() {
        Collection parts;
        ArrayList<MPart> miwParts = new ArrayList<MPart>();
        try {
            parts = ((EPartService)WorkspaceUtil.getEclipseContext().get(EPartService.class)).getParts();
        }
        catch (IllegalStateException e1) {
            Debug.getInstance().debug((Option)miworkplace.ui.debug.Option.loading, "Failed to get the MiW editors.", (Throwable)e1);
            try {
                parts = UiUtils.getPartService().getParts();
            }
            catch (IllegalStateException e2) {
                Debug.getInstance().error("Failed to get the MiW editors.", (Throwable)e2);
                return miwParts;
            }
        }
        for (MPart part : parts) {
            if (!(part.getObject() instanceof IRemoteEditor)) continue;
            miwParts.add(part);
        }
        return miwParts;
    }

    public static MPart getFileEditor(String filePath) {
        for (MPart part : WorkspaceUtil.getMiWEditors()) {
            String editorFilePath = EditorInputUriUtil.getFullFilePath((String)((IRemoteEditor)part.getObject()).getInputUri());
            if (!filePath.equals(editorFilePath)) continue;
            return part;
        }
        return null;
    }

    private static IRemoteObject loadIfsPath(IConnection connection, String path) {
        String[] filenames = path.split("/");
        List rootChildren = WorkspaceUtil.getWorkspaceStore().getStreamFiles(connection, "/");
        if (rootChildren == null || rootChildren.isEmpty()) {
            IEclipseContext additionalContext = EclipseContextFactory.create();
            additionalContext.set(IConnection.class, (Object)connection);
            additionalContext.set("miworkplace.ui.source.id", (Object)System.currentTimeMillis());
            DirectoryLoader loader = (DirectoryLoader)((Object)ContextInjectionFactory.make(DirectoryLoader.class, (IEclipseContext)WorkspaceUtil.getEclipseContext(), (IEclipseContext)additionalContext));
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                throw new RuntimeException(Messages.editor_handler_openinc_loadrooterror + status.getMessage());
            }
        }
        String lastParentPath = path.substring(0, path.lastIndexOf("/"));
        String p = "/";
        int i = 1;
        while (i < filenames.length) {
            List files = WorkspaceUtil.getWorkspaceStore().getStreamFiles(connection, p);
            for (IRemoteObject file : files) {
                if (!file.getName().equalsIgnoreCase(filenames[i])) continue;
                p = file.getPath();
                if (((StreamFile)file).isDirectory() && file.areChildrenLoaded()) {
                    if (!file.getPath().equalsIgnoreCase(lastParentPath)) break;
                    IRemoteObject remoteObject = WorkspaceUtil.getWorkspaceStore().get(connection, path);
                    if (remoteObject != null) {
                        return remoteObject;
                    }
                    IResource streamFileResource = WorkspaceUtil.buildStreamFileResource(connection, path, false);
                    StreamFile streamFile = new StreamFile(connection, streamFileResource, IRemoteObject.Type.streamfile, false);
                    WorkspaceUtil.getWorkspaceStore().add((IRemoteObject)streamFile);
                    IObjectPropertiesStore objectPropertiesStore = (IObjectPropertiesStore)ServiceUtils.getOSGiService(WorkspaceUtil.class, IObjectPropertiesStore.class);
                    objectPropertiesStore.update((IRemoteObject)streamFile);
                    ((IEventBroker)WorkspaceUtil.getEclipseContext().get(IEventBroker.class)).post("miworkplace/streamfile/created", (Object)streamFile);
                    remoteObject = WorkspaceUtil.getWorkspaceStore().get(connection, path);
                    if (remoteObject != null) {
                        return remoteObject;
                    }
                    Notifier.error((String)Messages.ui_workspace_util_loadStreamFile, (String)MessageFormat.format(Messages.ui_workspace_util_failedToloadStreamFile, filenames[filenames.length - 1]));
                    throw new RuntimeException(path + " doesn't exist in the workspace store.");
                }
                IEclipseContext additionalContext = EclipseContextFactory.create();
                additionalContext.set(IConnection.class, (Object)connection);
                additionalContext.set(StreamFile.class, (Object)((StreamFile)file));
                additionalContext.set("miworkplace.ui.source.id", (Object)System.currentTimeMillis());
                DirectoryLoader loader = (DirectoryLoader)((Object)ContextInjectionFactory.make(DirectoryLoader.class, (IEclipseContext)WorkspaceUtil.getEclipseContext(), (IEclipseContext)additionalContext));
                IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
                if (status.isOK()) break;
                throw new RuntimeException(String.format(Messages.editor_handler_openinc_loadstmferror, file.getPath(), status.getMessage()));
            }
            ++i;
        }
        return WorkspaceUtil.getWorkspaceStore().get(connection, path);
    }

    private static IRemoteObject loadQsysLibPath(IConnection connection, String path) {
        IRemoteObject library;
        QSYSObjectPathName pathName = new QSYSObjectPathName(path);
        String libraryName = pathName.getLibraryName();
        boolean isLibrary = libraryName.equals("QSYS");
        if (isLibrary) {
            libraryName = pathName.getObjectName();
        }
        if ((library = WorkspaceUtil.getWorkspaceStore().getLibrary(connection, libraryName)) == null || !library.areChildrenLoaded()) {
            WorkspaceUtil.getWorkspaceStore().addLibrary(connection, libraryName);
            library = WorkspaceUtil.getWorkspaceStore().getLibrary(connection, libraryName);
            ObjectLoader loader = (ObjectLoader)((Object)ContextInjectionFactory.make(ObjectLoader.class, (IEclipseContext)WorkspaceUtil.getEclipseContext()));
            loader.setLibrary(library);
            IStatus status = loader.run((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                Notifier.error((String)Messages.ui_workspace_util_object_title, (String)String.format(Messages.ui_workspace_util_object_msg, libraryName, status.getMessage()));
                throw new RuntimeException(status.getMessage(), status.getException());
            }
        }
        if (isLibrary) {
            return WorkspaceUtil.getWorkspaceStore().get(connection, path);
        }
        QSYSObjectPathName filePath = new QSYSObjectPathName(libraryName, pathName.getObjectName(), "FILE");
        IRemoteObject file = WorkspaceUtil.getWorkspaceStore().get(connection, filePath.getPath());
        if (file == null) {
            IResource fileResource = WorkspaceUtil.buildObjectResource(library, filePath.getObjectName(), IRemoteObject.Type.file);
            IRemoteObject objectFile = QSYSObject.create((IConnection)connection, (IResource)fileResource, (IRemoteObject.Type)IRemoteObject.Type.file, (String)"*FILE", (IRemoteObject.Attribute)IRemoteObject.Attribute.sourcefile, (String)"PF");
            WorkspaceUtil.getWorkspaceStore().add(objectFile);
            IObjectPropertiesStore objectPropertiesStore = (IObjectPropertiesStore)ServiceUtils.getOSGiService(WorkspaceUtil.class, IObjectPropertiesStore.class);
            objectPropertiesStore.fetch(objectFile);
            ((IEventBroker)WorkspaceUtil.getEclipseContext().get(IEventBroker.class)).post("miworkplace/object/created", (Object)objectFile);
        }
        if ((file = WorkspaceUtil.getWorkspaceStore().get(connection, filePath.getPath())) == null) {
            Notifier.error((String)Messages.ui_workspace_util_loadObject, (String)MessageFormat.format(Messages.ui_workspace_util_failedToloadObject, pathName.getObjectName()));
            throw new RuntimeException(filePath.getPath() + " doesn't exist in the workspace store.");
        }
        MemberLoader memberLoader = (MemberLoader)((Object)ContextInjectionFactory.make(MemberLoader.class, (IEclipseContext)WorkspaceUtil.getEclipseContext()));
        memberLoader.setFile(file);
        IStatus status = memberLoader.run((IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            Notifier.error((String)Messages.ui_workspace_util_member_title, (String)String.format(Messages.ui_workspace_util_member_msg, pathName.getObjectName(), status.getMessage()));
            throw new RuntimeException(status.getMessage());
        }
        return WorkspaceUtil.getWorkspaceStore().get(connection, path);
    }

    private static IEclipseContext getEclipseContext() {
        if (eclipseContext == null) {
            eclipseContext = ((IWorkbench)ServiceUtils.getOSGiService(WorkspaceUtil.class, IWorkbench.class)).getApplication().getContext();
        }
        return eclipseContext;
    }

    private static IWorkspaceStore getWorkspaceStore() {
        if (workspaceStore == null && (workspaceStore = (IWorkspaceStore)ServiceUtils.getOSGiService(WorkspaceUtil.class, IWorkspaceStore.class)).getWorkspace() == null) {
            workspaceStore.setWorkspace(WorkspaceUtil.getWorkspace());
        }
        return workspaceStore;
    }

    private static IWorkspace getWorkspace() {
        if (workspace == null) {
            workspace = (IWorkspace)ServiceUtils.getOSGiService(WorkspaceUtil.class, IWorkspace.class);
        }
        return workspace;
    }
}

