/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.ui;

import jakarta.inject.Inject;
import java.util.List;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.i18n.Messages;
import miworkplace.services.api.ISavedResourceStore;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

public class RecentlyEditedMenuContribution {
    private static final String SELECT_RECENTLY_COMMAND_ID = "miworkplace.ui.command.open.recently";
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private ISavedResourceStore savedResourceStore;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> items, ESelectionService selectionService) {
        List recentlyEditedResources = this.savedResourceStore.list();
        List list = recentlyEditedResources = recentlyEditedResources.size() <= 5 ? recentlyEditedResources : recentlyEditedResources.subList(0, 5);
        if (recentlyEditedResources.isEmpty()) {
            MDirectMenuItem item = this.createNoRequestsItem();
            items.add((MMenuElement)item);
        } else {
            MCommand command = this.getCommandInstance(SELECT_RECENTLY_COMMAND_ID);
            for (String url : recentlyEditedResources) {
                String connectionName = EditorInputUriUtil.getConnectionName((String)url);
                String path = EditorInputUriUtil.getMemberPath((String)url);
                MHandledMenuItem dynamicItem = (MHandledMenuItem)this.modelService.createModelElement(MHandledMenuItem.class);
                dynamicItem.setLabel(path);
                dynamicItem.setCommand(command);
                dynamicItem.getTransientData().put("connection", connectionName);
                dynamicItem.getTransientData().put("path", path);
                items.add((MMenuElement)dynamicItem);
            }
        }
    }

    private MDirectMenuItem createNoRequestsItem() {
        MDirectMenuItem item = MMenuFactory.INSTANCE.createDirectMenuItem();
        item.setLabel(Messages.ui_recently_none);
        item.setEnabled(false);
        item.setVisible(true);
        return item;
    }

    private MCommand getCommandInstance(String commandId) {
        List commands = this.application.getCommands();
        for (MCommand command : commands) {
            if (!command.getElementId().equals(commandId)) continue;
            return command;
        }
        return null;
    }
}

