/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs.cl;

import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.annotation.PostConstruct;
import java.util.LinkedList;
import java.util.List;
import miworkplace.common.debug.Debug;
import miworkplace.common.debug.Option;
import miworkplace.common.model.IConnection;
import miworkplace.iledocs.IledocsBuilder;
import miworkplace.iledocs.Parser;
import miworkplace.iledocs.cl.ClIledocsRetriever;
import miworkplace.iledocs.model.Parameter;
import miworkplace.iledocs.model.Program;
import miworkplace.iledocs.model.Variable;
import miworkplace.ui.editor.cl.ast.Ast;
import miworkplace.ui.editor.cl.ast.File;
import miworkplace.ui.editor.cl.ast.Variable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.extensions.Preference;

public class ClIledocsBuilder
implements IledocsBuilder {
    private Debug logger = Debug.getInstance();
    private miworkplace.ui.editor.cl.ast.Parser parser = new miworkplace.ui.editor.cl.ast.Parser();
    private ClIledocsRetriever docsRetriever = new ClIledocsRetriever();
    private String iledocsPrefix;

    @PostConstruct
    private void postConstruct(@Preference(nodePath="miworkplace.application") IEclipsePreferences applicationPreferences) {
        this.iledocsPrefix = applicationPreferences.get("miworkplace.iledocs.pref.prefix", "\\");
    }

    @Override
    public Program build(IConnection connection, String code) throws Exception {
        Ast ast = this.parser.parse(code);
        List<String> text = this.docsRetriever.retrieve(code);
        if (text == null || text.isEmpty()) {
            return null;
        }
        Parser iledocsParser = new Parser(this.iledocsPrefix);
        Program program = (Program)iledocsParser.parse(text, new Program());
        if (ast.listFiles() != null) {
            if (program.getFiles() == null) {
                program.setFiles(new LinkedList<miworkplace.iledocs.model.File>());
            }
            for (File file : ast.listFiles()) {
                miworkplace.iledocs.model.File f = new miworkplace.iledocs.model.File();
                f.setName(file.getLibrary() + "/" + file.getFile());
                f.setDescription(this.getFileDescription(connection, file));
                program.getFiles().add(f);
            }
        }
        if (ast.listParameters() != null) {
            if (program.getParameters() == null) {
                program.setParameters(new LinkedList<Parameter>());
            }
            List parameters = ast.listParameters();
            int i = 0;
            while (i < parameters.size()) {
                Parameter p;
                miworkplace.ui.editor.cl.ast.Parameter parameter = (miworkplace.ui.editor.cl.ast.Parameter)parameters.get(i);
                Variable variable = this.getDeclaredVariable(parameter.getName(), ast);
                if (program.getParameters().size() >= i + 1) {
                    p = program.getParameters().get(i);
                } else {
                    p = new Parameter();
                    program.getParameters().add(p);
                }
                p.setName(parameter.getName());
                if (variable != null) {
                    p.setDecimalPositions(variable.getDecimalPositions());
                    p.setLength(variable.getLength());
                    p.setType(this.mapClVariableType(variable.getType()));
                }
                ++i;
            }
        }
        return program;
    }

    private Variable.Type mapClVariableType(Variable.Type type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case Boolean: {
                return Variable.Type.Char;
            }
            case Character: {
                return Variable.Type.Char;
            }
            case Decimal: {
                return Variable.Type.PackedDecimal;
            }
            case Integer: {
                return Variable.Type.Integer;
            }
            case Pointer: {
                return Variable.Type.Pointer;
            }
            case UnsignedInteger: {
                return Variable.Type.UnsignedInteger;
            }
        }
        return null;
    }

    private Variable getDeclaredVariable(String name, Ast ast) {
        if (!((String)name).startsWith("&")) {
            name = "&" + (String)name;
        }
        for (Variable var : ast.listVariables()) {
            if (!var.getName().value.equalsIgnoreCase((String)name)) continue;
            return var;
        }
        return null;
    }

    private String getFileDescription(IConnection conn, File file) {
        try {
            QSYSObjectPathName qsysPathName = new QSYSObjectPathName();
            qsysPathName.setObjectName(file.getFile());
            qsysPathName.setObjectType("FILE");
            if (file.getLibrary() == null) {
                qsysPathName.setLibraryName("*LIBL");
            } else {
                qsysPathName.setLibraryName(file.getLibrary());
            }
            ObjectDescription desc = new ObjectDescription(conn.getSystem(), qsysPathName);
            String text = desc.getValue(203).toString();
            return text;
        }
        catch (Exception e) {
            this.logger.warn((Option)miworkplace.iledocs.debug.Option.iledocs, "Could not load object description for " + file.getLibrary() + "/" + file.getFile() + ". Error: " + e.getMessage());
            return null;
        }
    }

    public void setIledocsPrefix(String prefix) {
        this.iledocsPrefix = prefix;
    }
}

