/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs;

import miworkplace.iledocs.model.Variable;
import org.apache.commons.lang3.StringUtils;

public class VariableDefinitionMapper {
    public Variable mapShortHand(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        Variable v = new Variable();
        Integer length = null;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!Character.isDigit((int)c) && !Character.isWhitespace((int)c) && Character.isAlphabetic(c)) {
                this.mapDataType(c);
            }
            ++i;
        }
        String[] defParts = value.split("[a-zA-Z]");
        if (defParts.length == 1 && StringUtils.isNumeric((CharSequence)defParts[0])) {
            length = Integer.parseInt(defParts[0]);
        }
        if (length == null) {
            return null;
        }
        return v;
    }

    private Variable.Type mapDataType(int c) {
        char rawType = (char)c;
        return switch (rawType) {
            case '*' -> Variable.Type.Pointer;
            case 'A' -> Variable.Type.Char;
            case 'I' -> Variable.Type.Integer;
            case 'U' -> Variable.Type.UnsignedInteger;
            case 'P' -> Variable.Type.PackedDecimal;
            case 'S' -> Variable.Type.ZonedDecimal;
            case 'F' -> Variable.Type.Float;
            case 'D' -> Variable.Type.Date;
            case 'B' -> Variable.Type.Binary;
            case 'N' -> Variable.Type.Boolean;
            case 'T' -> Variable.Type.Time;
            case 'Z' -> Variable.Type.Timestamp;
            default -> null;
        };
    }
}

