/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.iledocs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.as400.access.QSYSObjectPathName;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import miworkplace.common.EditorInputUriUtil;
import miworkplace.common.debug.Debug;
import miworkplace.common.model.ContentType;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import miworkplace.common.model.IWorkspaceStore;
import miworkplace.common.model.SourceMember;
import miworkplace.common.model.StreamFile;
import miworkplace.common.text.RpgSyntaxTypeChecker;
import miworkplace.connection.api.IConnectionManager;
import miworkplace.i18n.Messages;
import miworkplace.iledocs.Parser;
import miworkplace.iledocs.cl.ClIledocsBuilder;
import miworkplace.iledocs.debug.Option;
import miworkplace.iledocs.model.IledocsModel;
import miworkplace.iledocs.model.Program;
import miworkplace.iledocs.model.Project;
import miworkplace.iledocs.rpg.FreeRpgIledocsBuilder;
import miworkplace.iledocs.rpg.RpgIledocsBuilder;
import miworkplace.iledocs.rpg.RpgIledocsRetriever;
import miworkplace.notifications.Notifier;
import miworkplace.services.api.IContentTypeRegistry;
import miworkplace.ui.api.IRemoteEditor;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ITreeSelection;

public class UploadHandler {
    private static final String PROJECT_INFO_FILE_NAME = "project-info";
    private Debug logger = Debug.getInstance();
    @Inject
    private IEclipseContext context;
    @Inject
    private IContentTypeRegistry contentTypeRegistry;
    @Inject
    @Preference(nodePath="miworkplace.application")
    private IEclipsePreferences applicationPreferences;
    @Inject
    private IWorkspaceStore workspaceStore;
    @Inject
    private IConnectionManager connectionManager;
    private final String title = Messages.iledocs_upload_title;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        String url = this.applicationPreferences.get("miworkplace.iledocs.pref.server.url", null);
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        if (part.getObject() != null && part.getObject() instanceof IRemoteEditor) {
            return true;
        }
        if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof StreamFile) {
            StreamFile streamFile = (StreamFile)selection.getFirstElement();
            if (streamFile.getName().toLowerCase().startsWith(PROJECT_INFO_FILE_NAME)) {
                return true;
            }
            return this.isRpgStreamFile((IRemoteObject)streamFile) || this.isClStreamFile((IRemoteObject)streamFile);
        }
        return true;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="org.eclipse.ui.selection") ITreeSelection selection) {
        try {
            Object object = part.getObject();
            if (object instanceof IRemoteEditor) {
                IRemoteEditor editor = (IRemoteEditor)object;
                String inputUri = editor.getInputUri();
                String sourcePath = EditorInputUriUtil.getMemberPath((String)inputUri);
                String connectionName = EditorInputUriUtil.getConnectionName((String)inputUri);
                IConnection connection = this.connectionManager.get(connectionName);
                String sourceName = this.getSourceName(sourcePath);
                if (sourceName.equalsIgnoreCase(PROJECT_INFO_FILE_NAME)) {
                    this.uploadProjectInfo(connection, sourcePath, editor.getDocument().get());
                    return;
                }
                if (sourcePath.toUpperCase().startsWith("/QSYS.LIB/")) {
                    QSYSObjectPathName objPathName = new QSYSObjectPathName(sourcePath);
                    String memberName = objPathName.getMemberName();
                    if (this.isClSource(connection, sourcePath)) {
                        this.uploadCl(connection, memberName, sourcePath, editor.getDocument().get());
                    } else if (this.isRpgSource(connection, sourcePath)) {
                        this.uploadRpg(connection, memberName, sourcePath, editor.getDocument().get());
                    }
                } else {
                    IRemoteObject streamFile = this.workspaceStore.get(connection, sourcePath);
                    if (this.isRpgStreamFile(streamFile)) {
                        this.uploadRpg(connection, streamFile.getName(), sourcePath, editor.getDocument().get());
                    } else if (this.isClStreamFile(streamFile)) {
                        this.uploadCl(connection, streamFile.getName(), sourcePath, editor.getDocument().get());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Error uploading ILEDocs.", (Throwable)e);
            Notifier.error((String)this.title, (String)Messages.iledocs_upload_error);
        }
    }

    private String getSourceName(String sourcePath) {
        File f = new File(sourcePath);
        String name = f.getName();
        if (name.contains(".")) {
            int x = name.lastIndexOf(".");
            if (x == 0) {
                return name;
            }
            return name.substring(0, x);
        }
        return name;
    }

    private void uploadProjectInfo(IConnection connection, String path, String code) {
        Project projectInfo = new Project();
        try {
            RpgIledocsRetriever retriever = new RpgIledocsRetriever();
            Map<Integer, List<String>> iledocsBlockMap = retriever.retrieve(code);
            if (iledocsBlockMap.isEmpty()) {
                Notifier.error((String)this.title, (String)Messages.iledocs_upload_noblock);
                return;
            }
            String iledocsPrefix = this.applicationPreferences.get("miworkplace.iledocs.pref.prefix", "\\");
            Parser iledocsParser = new Parser(iledocsPrefix);
            projectInfo = (Project)iledocsParser.parse(iledocsBlockMap.values().iterator().next(), projectInfo);
            try {
                this.upload(projectInfo);
            }
            catch (Exception e) {
                this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Error uploading ILEDocs.", (Throwable)e);
                Notifier.error((String)this.title, (String)String.format(Messages.iledocs_upload_project_error, path));
            }
        }
        catch (Exception e) {
            this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Error building ILEDocs information.", (Throwable)e);
            Notifier.error((String)this.title, (String)String.format(Messages.iledocs_upload_project_build_error, path));
        }
    }

    private void uploadRpg(IConnection connection, String memberName, String memberPath, String code) {
        try {
            Program program = null;
            if (RpgSyntaxTypeChecker.isFullFree((String)code)) {
                iledocsBuilder = (FreeRpgIledocsBuilder)ContextInjectionFactory.make(FreeRpgIledocsBuilder.class, (IEclipseContext)this.context);
                program = ((FreeRpgIledocsBuilder)iledocsBuilder).build(connection, code);
            } else {
                iledocsBuilder = (RpgIledocsBuilder)ContextInjectionFactory.make(RpgIledocsBuilder.class, (IEclipseContext)this.context);
                program = ((RpgIledocsBuilder)iledocsBuilder).build(connection, code);
            }
            if (program == null) {
                Notifier.warn((String)this.title, (String)Messages.iledocs_upload_rpg_notvalid);
                return;
            }
            try {
                program.setSource(memberName);
                this.upload(program);
            }
            catch (Exception e) {
                this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Error uploading ILEDocs.", (Throwable)e);
                Notifier.error((String)this.title, (String)String.format(Messages.iledocs_upload_rpg_upload_error, memberPath));
            }
        }
        catch (Exception e) {
            this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Error building ILEDocs information.", (Throwable)e);
            Notifier.error((String)this.title, (String)("Error building ILEDocs for " + memberPath + "."));
        }
    }

    private void uploadCl(IConnection connection, String memberName, String memberPath, String code) {
        ClIledocsBuilder builder = (ClIledocsBuilder)ContextInjectionFactory.make(ClIledocsBuilder.class, (IEclipseContext)this.context);
        try {
            try {
                Program program = builder.build(connection, code);
                program.setSource(memberName);
                try {
                    this.upload(program);
                }
                catch (Exception e) {
                    this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Error uploading ILEDocs.", (Throwable)e);
                    Notifier.error((String)this.title, (String)("Error uploading ILEDocs for member " + memberName + "."));
                }
            }
            catch (Exception e) {
                this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Error building ILEDocs information.", (Throwable)e);
                Notifier.error((String)this.title, (String)("Error building ILEDocs for member " + memberName + "."));
            }
        }
        catch (Exception e) {
            this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Error parsing source member " + memberPath, (Throwable)e);
            Notifier.error((String)this.title, (String)("Error parsing source member " + memberName + "."));
        }
    }

    private void upload(Program program) throws UnsupportedEncodingException {
        if (program.getProject() == null) {
            String project = this.applicationPreferences.get("miworkplace.iledocs.pref.default", null);
            program.setProject(project);
        }
        if (!this.validate(program)) {
            return;
        }
        String url = this.applicationPreferences.get("miworkplace.iledocs.pref.server.url", null) + "/" + URLEncoder.encode(program.getProject(), "UTF-8") + "/modules/" + program.getSource();
        try {
            String serializedIledocs = this.serializeIledocs(program);
            HttpClient client = this.buildHttpClient();
            HttpPost post = new HttpPost(url);
            post.setEntity((HttpEntity)new StringEntity(serializedIledocs, org.apache.http.entity.ContentType.APPLICATION_JSON));
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 204) {
                Notifier.info((String)"Upload ILEDocs", (String)("ILEDocs uploaded for " + StringUtils.defaultString((String)program.getSource())));
            } else {
                Notifier.error((String)"Upload ILEDocs", (String)("The documentation could not be uploaded to the server. HTTP Code: " + response.getStatusLine().getStatusCode()));
                this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Could not upload documentation to server. Error: " + response.getStatusLine().getReasonPhrase());
            }
        }
        catch (Exception e) {
            this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "The documentation could not be uploaded to the server.", (Throwable)e);
            Notifier.error((String)"Upload ILEDocs", (String)"The documentation could not be uploaded to the server. See the log for more information.");
        }
    }

    private void upload(Project projectInfo) throws UnsupportedEncodingException {
        if (projectInfo.getProject() == null) {
            String project = this.applicationPreferences.get("miworkplace.iledocs.pref.default", null);
            projectInfo.setProject(project);
        }
        if (!this.validate(projectInfo)) {
            return;
        }
        String url = this.applicationPreferences.get("miworkplace.iledocs.pref.server.url", null) + "/" + URLEncoder.encode(projectInfo.getProject(), "UTF-8");
        try {
            String serializedIledocs = this.serializeIledocs(projectInfo);
            HttpClient client = this.buildHttpClient();
            HttpPost post = new HttpPost(url);
            post.setEntity((HttpEntity)new StringEntity(serializedIledocs, org.apache.http.entity.ContentType.APPLICATION_JSON));
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 204) {
                Notifier.info((String)"Upload ILEDocs", (String)"ILEDocs project info uploaded.");
            } else {
                Notifier.error((String)"Upload ILEDocs", (String)("The documentation could not be uploaded to the server. HTTP Code: " + response.getStatusLine().getStatusCode()));
                this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "Could not upload documentation to server. Error: " + response.getStatusLine().getReasonPhrase());
            }
        }
        catch (Exception e) {
            this.logger.error((miworkplace.common.debug.Option)Option.iledocs, "The documentation could not be uploaded to the server.", (Throwable)e);
            Notifier.error((String)"Upload ILEDocs", (String)"The documentation could not be uploaded to the server. See the log for more information.");
        }
    }

    private String serializeIledocs(Program program) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)program);
        return writer.toString();
    }

    private String serializeIledocs(Project projectInfo) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)projectInfo);
        return writer.toString();
    }

    private HttpClient buildHttpClient() {
        return HttpClientBuilder.create().build();
    }

    private boolean validate(IledocsModel iledocsDataModel) {
        if (StringUtils.isEmpty((CharSequence)iledocsDataModel.getProject())) {
            Notifier.error((String)"Validate ILEDocs", (String)"The ILEDocs section has no project tag.");
            return false;
        }
        return true;
    }

    private boolean isClSource(IConnection connection, String ifsPath) {
        IRemoteObject obj = this.workspaceStore.get(connection, ifsPath);
        if (obj == null) {
            throw new RuntimeException("Couldn't determine content type for " + ifsPath + " for uploading ILEDocs.");
        }
        return this.isClSource((SourceMember)obj);
    }

    private boolean isClSource(SourceMember member) {
        List contentTypes = this.contentTypeRegistry.getContentType((IRemoteObject)member);
        for (ContentType contentType : contentTypes) {
            if (!contentType.getId().equals("miworkplace.ui.editor.cl")) continue;
            this.logger.debug((miworkplace.common.debug.Option)Option.iledocs, member.getPath() + " is CL source");
            return true;
        }
        return false;
    }

    private boolean isClStreamFile(IRemoteObject streamFile) {
        List contentTypes = this.contentTypeRegistry.getContentType(streamFile);
        for (ContentType contentType : contentTypes) {
            if (!contentType.getId().equals("miworkplace.ui.editor.cl")) continue;
            this.logger.debug((miworkplace.common.debug.Option)Option.iledocs, streamFile.getPath() + " is CL stream file");
            return true;
        }
        return false;
    }

    private boolean isRpgSource(IConnection connection, String ifsPath) {
        IRemoteObject obj = this.workspaceStore.get(connection, ifsPath);
        if (obj == null) {
            throw new RuntimeException("Couldn't determine content type for " + ifsPath + " for uploading ILEDocs.");
        }
        return this.isRpgSource((SourceMember)obj);
    }

    private boolean isRpgSource(SourceMember member) {
        List contentTypes = this.contentTypeRegistry.getContentType((IRemoteObject)member);
        for (ContentType contentType : contentTypes) {
            if (!contentType.getId().equals("miworkplace.ui.editor.rpg")) continue;
            this.logger.debug((miworkplace.common.debug.Option)Option.iledocs, member.getPath() + " is RPG source");
            return true;
        }
        return false;
    }

    private boolean isRpgStreamFile(IRemoteObject streamFile) {
        List contentTypes = this.contentTypeRegistry.getContentType(streamFile);
        for (ContentType contentType : contentTypes) {
            if (!contentType.getId().equals("miworkplace.ui.editor.rpg")) continue;
            this.logger.debug((miworkplace.common.debug.Option)Option.iledocs, streamFile.getPath() + " is RPG source");
            return true;
        }
        return false;
    }
}

