/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework.java;

import com.ibm.as400.ui.framework.java.GroupDescriptor;
import com.ibm.as400.ui.framework.java.JGroupingTableHeader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class GroupingTableHeaderUI
extends BasicTableHeaderUI {
    private TableCellRenderer m_emptyRenderer = new EmptyTableHeaderRenderer();
    private static boolean includeMargin = false;
    private static boolean dbgFlag = false;

    public GroupingTableHeaderUI() {
        String string = System.getProperty("java.version");
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        String string3 = string.substring(0, string.indexOf("."));
        if (new Integer(string2) <= 1 && new Integer(string3) <= 2) {
            includeMargin = true;
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        GroupingTableHeaderUI.debug("createUI called!");
        return new GroupingTableHeaderUI();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        if (((JGroupingTableHeader)this.header).getGroups().length > 0) {
            dimension.height *= 2;
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (((JGroupingTableHeader)this.header).getGroups().length > 0) {
            dimension.height *= 2;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = super.getMaximumSize(jComponent);
        if (((JGroupingTableHeader)this.header).getGroups().length > 0) {
            dimension.height *= 2;
        }
        return dimension;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        TableColumn tableColumn;
        Rectangle rectangle = graphics.getClipBounds();
        if (this.header.getColumnModel() == null) {
            return;
        }
        int n = 0;
        boolean bl = false;
        int n2 = -1;
        Rectangle rectangle2 = null;
        Dimension dimension = this.header.getSize();
        Rectangle rectangle3 = new Rectangle(0, 0, 0, dimension.height / 2);
        GroupDescriptor[] groupDescriptorArray = ((JGroupingTableHeader)this.header).getGroups();
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        for (int i = 0; i < groupDescriptorArray.length; ++i) {
            for (int j = 0; j < groupDescriptorArray[i].m_numberOfColumns; ++j) {
                TableColumn tableColumn2 = enumeration.nextElement();
                int n3 = this.header.getColumnModel().getColumnMargin();
                rectangle3.width += tableColumn2.getWidth() + n3;
            }
            this.paintGroup(graphics, rectangle3, groupDescriptorArray[i].m_name);
            rectangle3.x += rectangle3.width;
            rectangle3.width = 0;
        }
        Rectangle rectangle4 = groupDescriptorArray.length > 0 ? new Rectangle(0, dimension.height / 2, dimension.width, dimension.height / 2) : new Rectangle(0, 0, dimension.width, dimension.height);
        enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn3 = enumeration.nextElement();
            int n4 = this.header.getColumnModel().getColumnMargin();
            rectangle4.width = tableColumn3.getWidth();
            if (includeMargin) {
                rectangle4.width += n4;
            }
            if (rectangle4.intersects(rectangle)) {
                bl = true;
                if (tableColumn3 != this.header.getDraggedColumn()) {
                    this.paintCell(graphics, rectangle4, n);
                } else {
                    graphics.setColor(this.header.getParent().getBackground());
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    rectangle2 = new Rectangle(rectangle4);
                    n2 = n;
                }
            } else if (bl) break;
            rectangle4.x += rectangle4.width;
            ++n;
        }
        if ((tableColumn = this.header.getDraggedColumn()) != null && rectangle2 != null) {
            rectangle2.x += this.header.getDraggedDistance();
            this.paintCell(graphics, rectangle2, n2);
        }
        JTable jTable = this.header.getTable();
        Dimension dimension2 = jTable.getParent().getSize();
        if (rectangle4.x < dimension2.width) {
            Rectangle rectangle5 = new Rectangle(rectangle4.x, 0, dimension2.width - rectangle4.x, dimension.height);
            this.paintEmptyCell(graphics, rectangle5);
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.createDefaultHeaderRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private TableCellRenderer createDefaultHeaderRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setText(object == null ? "" : object.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(0);
        return defaultTableCellRenderer;
    }

    private void paintEmptyCell(Graphics graphics, Rectangle rectangle) {
        Component component = this.m_emptyRenderer.getTableCellRendererComponent(this.header.getTable(), null, false, false, -1, -1);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private void paintGroup(Graphics graphics, Rectangle rectangle, String string) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(0);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), string, false, false, -1, 0);
        this.rendererPane.add(component);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    protected MouseInputListener createMouseInputListener() {
        return new GroupMouseHandler(this.header);
    }

    private static void debug(String string) {
        if (dbgFlag) {
            System.out.println("GroupingTableHeaderUI: " + string);
        }
    }

    class EmptyTableHeaderRenderer
    extends DefaultTableCellRenderer {
        EmptyTableHeaderRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    public class GroupMouseHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        JTableHeader m_header;

        public GroupMouseHandler(JTableHeader jTableHeader) {
            super(GroupingTableHeaderUI.this);
            this.m_header = jTableHeader;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (((JGroupingTableHeader)this.m_header).getGroups().length <= 0) {
                super.mousePressed(mouseEvent);
                return;
            }
            Point point = mouseEvent.getPoint();
            if (this.getResizingColumn(point) != -1) {
                super.mousePressed(mouseEvent);
                return;
            }
            Dimension dimension = this.m_header.getSize();
            if (point.y > dimension.height / 2) {
                super.mousePressed(mouseEvent);
                return;
            }
        }

        private int getResizingColumn(Point point) {
            int n = 0;
            Rectangle rectangle = new Rectangle(-3, 0, 6, this.m_header.getSize().height);
            int n2 = this.m_header.getColumnModel().getColumnMargin();
            Enumeration<TableColumn> enumeration = this.m_header.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                rectangle.x += tableColumn.getWidth() + n2;
                if (rectangle.x > point.x) break;
                if (rectangle.contains(point)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }
}

