/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.framework;

import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.ActionHandler;
import com.ibm.as400.ui.framework.java.JGroupingTableHeader;
import com.ibm.as400.ui.framework.java.MenuManager;
import com.ibm.as400.ui.framework.java.PaneManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class ContextButtonHelpHandler
extends ActionHandler
implements MouseListener {
    private Component m_component = null;
    private JToggleButton m_toggleButton = null;
    private Container m_container = null;
    private Cursor m_customCursor = null;
    private Cursor m_panelCursor = null;

    public ContextButtonHelpHandler(MenuManager menuManager) {
        super(menuManager);
        PaneManager paneManager = menuManager.getPaneManager();
        if (paneManager instanceof PanelManager) {
            this.m_container = ((PanelManager)paneManager).getContainer();
        } else {
            System.out.println("ContextHelpHandler not on PanelManager");
        }
    }

    public ContextButtonHelpHandler(Container container, JToggleButton jToggleButton) {
        super((MenuManager)null);
        this.m_container = container;
        this.m_toggleButton = jToggleButton;
    }

    void createCustomCursor() {
        ImageIcon imageIcon = SystemResourceFinder.getImageResource("com/ibm/as400/ui/framework/helpques1.gif");
        Image image = imageIcon.getImage();
        this.m_customCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 3), "helpques1");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_component == null) {
            while (!(this.m_container instanceof JFrame) && !(this.m_container instanceof JDialog)) {
                this.m_container = this.m_container.getParent();
            }
            if (this.m_container instanceof JFrame) {
                this.m_component = ((JFrame)this.m_container).getRootPane().getGlassPane();
            } else if (this.m_container instanceof JDialog) {
                this.m_component = ((JDialog)this.m_container).getRootPane().getGlassPane();
            }
        }
        this.m_component.addMouseListener(this);
        this.m_component.setVisible(true);
        this.m_panelCursor = this.m_component.getCursor();
        if (this.m_customCursor == null) {
            this.createCustomCursor();
        }
        this.m_component.setCursor(this.m_customCursor);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Component[] componentArray;
        this.m_component.removeMouseListener(this);
        this.m_component.setCursor(this.m_panelCursor);
        if (this.m_toggleButton != null) {
            this.m_toggleButton.setSelected(false);
        }
        this.m_component.setVisible(false);
        Point point = mouseEvent.getPoint();
        Object object = this.m_container;
        object = this.m_container instanceof JFrame ? ((JFrame)this.m_container).getContentPane() : ((JDialog)this.m_container).getRootPane().getContentPane();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, (Component)object);
        Component component = ((Component)object).getComponentAt(point);
        if (!component.isVisible()) {
            componentArray = ((Container)object).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Point point2 = SwingUtilities.convertPoint((Component)object, point, componentArray[i]);
                if (!componentArray[i].contains(point2) || !componentArray[i].isVisible()) continue;
                component = componentArray[i];
                break;
            }
        }
        point = SwingUtilities.convertPoint((Component)object, point, component);
        object = component;
        componentArray = null;
        block1: while (object instanceof Container && object != componentArray) {
            if (object instanceof JTabbedPane) {
                point = SwingUtilities.convertPoint((Component)object, point, ((JTabbedPane)object).getSelectedComponent());
                object = ((JTabbedPane)object).getSelectedComponent();
            }
            if (object == null) break;
            componentArray = object;
            if (!(object instanceof Container)) continue;
            Component[] componentArray2 = ((Container)object).getComponents();
            for (int i = 0; i < componentArray2.length; ++i) {
                Point point3 = SwingUtilities.convertPoint((Component)object, point, componentArray2[i]);
                if (!componentArray2[i].contains(point3) || !componentArray2[i].isVisible()) continue;
                object = componentArray2[i];
                point = point3;
                continue block1;
            }
        }
        if (object == null) {
            object = componentArray;
        }
        mouseEvent.consume();
        if (object instanceof JScrollBar || object instanceof JGroupingTableHeader) {
            object = ((Component)object).getParent();
        }
        if (object instanceof JViewport) {
            object = ((Component)object).getParent();
        }
        KeyEvent keyEvent = new KeyEvent((Component)object, 401, 0L, 0, 112, '\u0001');
        KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent((Component)object, keyEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public String toString() {
        return this.getClass().getName() + "[menuManager=" + this.menuManager + "]";
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 2000";
    }
}

