/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTF;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class PTFGroup {
    static final String USERSPACE_NAME = "JT4PTF    QTEMP     ";
    static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC";
    private AS400 system_;
    private String PTFGroupName_;
    private boolean includeRelatedPTFGroups_ = false;
    private String PTFgroupDescription_;
    private int PTFGroupLevel_;
    private int PTFGroupStatus_;
    private String targetRelease_;
    public static final int PTF_GROUP_STATUS_UNKNOWN = 0;
    public static final int PTF_GROUP_STATUS_NOT_APPLICABLE = 1;
    public static final int PTF_GROUP_STATUS_SUPPORTED_ONLY = 2;
    public static final int PTF_GROUP_STATUS_NOT_INSTALLED = 3;
    public static final int PTF_GROUP_STATUS_INSTALLED = 4;
    public static final int PTF_GROUP_STATUS_ERROR = 5;
    public static final int PTF_GROUP_STATUS_NOT_FOUND = 6;
    public static final int PTF_GROUP_STATUS_APPLY_AT_NEXT_IPL = 7;
    public static final int PTF_GROUP_STATUS_RELATED_GROUP = 8;
    public static final int PTF_GROUP_STATUS_ON_ORDER = 9;

    PTFGroup(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("ptfGroupName");
        }
        this.system_ = aS400;
        this.PTFGroupName_ = string.trim();
    }

    PTFGroup(AS400 aS400, String string, String string2, int n, int n2, String string3) {
        this(aS400, string);
        this.PTFGroupLevel_ = n;
        this.PTFgroupDescription_ = string2;
        this.PTFGroupStatus_ = n2;
        this.targetRelease_ = string3.trim();
    }

    public AS400 getSystem() {
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTFGroup[] getRelatedPTFGroups() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            PTFGroup[] pTFGroupArray;
            int n;
            int n2 = 164;
            int n3 = this.system_.getCcsid();
            ConvTable convTable = ConvTable.getTable(n3, null);
            ProgramParameter[] programParameterArray = new ProgramParameter[5];
            programParameterArray[0] = new ProgramParameter(convTable.stringToByteArray(USERSPACE_NAME));
            programParameterArray[0].setParameterType(2);
            byte[] byArray = new byte[69];
            AS400Text aS400Text = new AS400Text(60, n3, this.system_);
            BinaryConverter.intToByteArray(69, byArray, 0);
            aS400Text.toBytes(this.PTFGroupName_, byArray, 4);
            BinaryConverter.intToByteArray(n3, byArray, 64);
            byArray[68] = this.includeRelatedPTFGroups_ ? -15 : -16;
            programParameterArray[1] = new ProgramParameter(byArray);
            programParameterArray[1].setParameterType(2);
            programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("GRPR0500"));
            programParameterArray[2].setParameterType(2);
            programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
            programParameterArray[3].setParameterType(2);
            programParameterArray[4] = new ProgramParameter(new byte[4]);
            programParameterArray[4].setParameterType(2);
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroupDetails", 0, programParameterArray);
            boolean bl = serviceProgramCall.isStayOnThread();
            Object object = bl ? USERSPACE_PATH : this.system_;
            byte[] byArray2 = null;
            Object object2 = object;
            synchronized (object2) {
                UserSpace userSpace = new UserSpace(this.system_, USERSPACE_PATH);
                userSpace.setMustUseProgramCall(true);
                if (!bl) {
                    userSpace.setMustUseSockets(true);
                }
                try {
                    userSpace.create(262144, true, "", (byte)0, "User space for PTF Group", "*EXCLUDE");
                    if (!serviceProgramCall.run()) {
                        throw new AS400Exception(serviceProgramCall.getMessageList());
                    }
                    n = userSpace.getLength();
                    byArray2 = new byte[n];
                    userSpace.read(byArray2, 0);
                    pTFGroupArray = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    try {
                        userSpace.delete();
                    }
                    catch (Exception exception) {
                        Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                    }
                    throw throwable;
                }
                try {
                    userSpace.delete();
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                }
            }
            int n4 = BinaryConverter.byteArrayToInt(byArray2, 124);
            int n5 = BinaryConverter.byteArrayToInt(byArray2, 132);
            n = BinaryConverter.byteArrayToInt(byArray2, 136);
            int n6 = BinaryConverter.byteArrayToInt(byArray2, 140);
            convTable = ConvTable.getTable(n6, null);
            pTFGroupArray = new PTFGroup[n5];
            int n7 = 0;
            for (int i = 0; i < n5; ++i) {
                n7 = n4 + i * n;
                String string = convTable.byteArrayToString(byArray2, n7, 60);
                String string2 = convTable.byteArrayToString(byArray2, n7 += 60, 100);
                int n8 = BinaryConverter.byteArrayToInt(byArray2, n7 += 100);
                int n9 = BinaryConverter.byteArrayToInt(byArray2, n7 += 4);
                n7 += 4;
                pTFGroupArray[i] = new PTFGroup(this.system_, string, string2, n8, n9, "");
            }
            return pTFGroupArray;
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
            throw new InternalErrorException(10, (Throwable)propertyVetoException);
        }
    }

    public String getPTFGroupDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFgroupDescription_;
    }

    public String getPTFGroupName() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupName_;
    }

    public int getPTFGroupLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupLevel_;
    }

    public int getPTFGroupStatus() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupStatus_;
    }

    public String getTargetRelease() {
        return this.targetRelease_;
    }

    public void includeRelatedPTFGroups(boolean bl) {
        this.includeRelatedPTFGroups_ = bl;
    }

    public boolean areRelatedPTFGroupsIncluded() {
        return this.includeRelatedPTFGroups_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTF[] getPTFs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        try {
            PTF[] pTFArray;
            int n;
            int n2 = 73;
            int n3 = this.system_.getCcsid();
            ConvTable convTable = ConvTable.getTable(n3, null);
            ProgramParameter[] programParameterArray = new ProgramParameter[5];
            programParameterArray[0] = new ProgramParameter(convTable.stringToByteArray(USERSPACE_NAME));
            programParameterArray[0].setParameterType(2);
            int n4 = 69;
            byte[] byArray = new byte[69];
            if (this.PTFGroupLevel_ != 0) {
                byArray = new byte[76];
                n4 = 76;
            }
            AS400Text aS400Text = new AS400Text(60, n3, this.system_);
            BinaryConverter.intToByteArray(n4, byArray, 0);
            aS400Text.toBytes(this.PTFGroupName_, byArray, 4);
            BinaryConverter.intToByteArray(n3, byArray, 64);
            int n5 = byArray[68] = this.includeRelatedPTFGroups_ ? -15 : -16;
            if (this.PTFGroupLevel_ != 0) {
                BinaryConverter.intToByteArray(this.PTFGroupLevel_, byArray, 72);
            }
            programParameterArray[1] = new ProgramParameter(byArray);
            programParameterArray[1].setParameterType(2);
            programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("GRPR0300"));
            programParameterArray[2].setParameterType(2);
            programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
            programParameterArray[3].setParameterType(2);
            programParameterArray[4] = new ProgramParameter(new byte[4]);
            programParameterArray[4].setParameterType(2);
            ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroupDetails", 0, programParameterArray);
            boolean bl = serviceProgramCall.isStayOnThread();
            Object object = bl ? USERSPACE_PATH : this.system_;
            byte[] byArray2 = null;
            Object object2 = object;
            synchronized (object2) {
                UserSpace userSpace = new UserSpace(this.system_, USERSPACE_PATH);
                userSpace.setMustUseProgramCall(true);
                if (!bl) {
                    userSpace.setMustUseSockets(true);
                }
                try {
                    userSpace.create(262144, true, "", (byte)0, "User space for PTF Group", "*EXCLUDE");
                    if (!serviceProgramCall.run()) {
                        throw new AS400Exception(serviceProgramCall.getMessageList());
                    }
                    n = userSpace.getLength();
                    byArray2 = new byte[n];
                    userSpace.read(byArray2, 0);
                    pTFArray = null;
                }
                catch (Throwable throwable) {
                    Object var16_19 = null;
                    try {
                        userSpace.delete();
                    }
                    catch (Exception exception) {
                        Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                    }
                    throw throwable;
                }
                try {
                    userSpace.delete();
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                }
            }
            int n6 = BinaryConverter.byteArrayToInt(byArray2, 124);
            int n7 = BinaryConverter.byteArrayToInt(byArray2, 132);
            n = BinaryConverter.byteArrayToInt(byArray2, 136);
            int n8 = BinaryConverter.byteArrayToInt(byArray2, 140);
            convTable = ConvTable.getTable(n8, null);
            pTFArray = new PTF[n7];
            int n9 = 0;
            for (int i = 0; i < n7; ++i) {
                n9 = n6 + i * n;
                String string = convTable.byteArrayToString(byArray2, n9, 7);
                String string2 = convTable.byteArrayToString(byArray2, n9 += 7, 7);
                String string3 = convTable.byteArrayToString(byArray2, n9 += 7, 6);
                String string4 = convTable.byteArrayToString(byArray2, n9 += 6, 4);
                String string5 = convTable.byteArrayToString(byArray2, n9 += 4, 4);
                String string6 = convTable.byteArrayToString(byArray2, n9 += 4, 2);
                String string7 = convTable.byteArrayToString(byArray2, n9 += 2, 2);
                n9 += 2;
                String string8 = convTable.byteArrayToString(byArray2, n9++, 1);
                int n10 = byArray2[n9++] & 0xF;
                String string9 = convTable.byteArrayToString(byArray2, n9++, 1);
                String string10 = convTable.byteArrayToString(byArray2, n9++, 1);
                String string11 = convTable.byteArrayToString(byArray2, n9++, 1);
                String string12 = convTable.byteArrayToString(byArray2, n9++, 1);
                String string13 = convTable.byteArrayToString(byArray2, n9++, 1);
                String string14 = convTable.byteArrayToString(byArray2, n9, 10);
                String string15 = convTable.byteArrayToString(byArray2, n9 += 10, 10);
                String string16 = convTable.byteArrayToString(byArray2, n9 += 10, 7);
                String string17 = convTable.byteArrayToString(byArray2, n9 += 7, 7);
                n9 += 7;
                String string18 = convTable.byteArrayToString(byArray2, n9++, 1);
                String string19 = convTable.byteArrayToString(byArray2, n9++, 1);
                pTFArray[i] = new PTF(this.system_, string, string2, string3, string4, string5, string6, string7, string8, n10, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19);
            }
            return pTFArray;
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
            throw new InternalErrorException(10, (Throwable)propertyVetoException);
        }
    }
}

