/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AbstractProxyImpl;
import com.ibm.as400.access.JDBlobProxy;
import com.ibm.as400.access.JDClobProxy;
import com.ibm.as400.access.JDConnectionProxy;
import com.ibm.as400.access.JDInputStreamProxy;
import com.ibm.as400.access.JDNClobProxy;
import com.ibm.as400.access.JDReaderProxy;
import com.ibm.as400.access.JDResultSetMetaDataProxy;
import com.ibm.as400.access.JDRowIdProxy;
import com.ibm.as400.access.JDSQLXMLProxy;
import com.ibm.as400.access.JDStatementProxy;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.ProxyClientConnection;
import com.ibm.as400.access.ProxyReturnValue;
import com.ibm.as400.access.SerializableInputStream;
import com.ibm.as400.access.SerializableReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDResultSetProxy
extends AbstractProxyImpl
implements ResultSet {
    static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JDConnectionProxy jdConnection_;
    private JDStatementProxy cachedStatement_;
    private static final String NOT_SERIALIZABLE = "Parameter is not serializable.";

    public JDResultSetProxy(JDConnectionProxy jDConnectionProxy) {
        this.jdConnection_ = jDConnectionProxy;
    }

    public JDResultSetProxy(JDConnectionProxy jDConnectionProxy, JDStatementProxy jDStatementProxy) {
        this.jdConnection_ = jDConnectionProxy;
        this.cachedStatement_ = jDStatementProxy;
    }

    private void callMethod(String string) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private void callMethod(String string, Class[] classArray, Object[] objectArray) throws SQLException {
        try {
            this.connection_.callMethod(this.pxId_, string, classArray, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private boolean callMethodRtnBool(String string) throws SQLException {
        try {
            return this.connection_.callMethodReturnsBoolean(this.pxId_, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private JDInputStreamProxy callMethodRtnInpStrm(String string, int n) throws SQLException {
        try {
            JDInputStreamProxy jDInputStreamProxy = new JDInputStreamProxy();
            return (JDInputStreamProxy)this.connection_.callFactoryMethod(this.pxId_, string, new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDInputStreamProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private int callMethodRtnInt(String string) throws SQLException {
        try {
            return this.connection_.callMethodReturnsInt(this.pxId_, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private Object callMethodRtnObj(String string) throws SQLException {
        try {
            return this.connection_.callMethodReturnsObject(this.pxId_, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private Object callMethodRtnObj(String string, Class[] classArray, Object[] objectArray) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, string, classArray, objectArray).getReturnValue();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    private ProxyReturnValue callMethodRtnRaw(String string, Class[] classArray, Object[] objectArray) throws SQLException {
        try {
            return this.connection_.callMethod(this.pxId_, string, classArray, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.callMethod("clearWarnings");
    }

    @Override
    public void close() throws SQLException {
        this.callMethod("close");
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.callMethodRtnRaw("findColumn", new Class[]{String.class}, new Object[]{string}).getReturnValueInt();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.callMethodRtnInt("getConcurrency");
    }

    @Override
    public String getCursorName() throws SQLException {
        return (String)this.callMethodRtnObj("getCursorName");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.callMethodRtnInt("getFetchDirection");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.callMethodRtnInt("getFetchSize");
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.cachedStatement_ == null) {
            try {
                JDStatementProxy jDStatementProxy = new JDStatementProxy(this.jdConnection_);
                this.cachedStatement_ = (JDStatementProxy)this.connection_.callFactoryMethod(this.pxId_, "getStatement", jDStatementProxy);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw JDConnectionProxy.rethrow1(invocationTargetException);
            }
        }
        return this.cachedStatement_;
    }

    @Override
    public int getType() throws SQLException {
        return this.callMethodRtnInt("getType");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return (SQLWarning)this.callMethodRtnObj("getWarnings");
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.callMethod("setFetchDirection", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.callMethod("setFetchSize", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public String toString() {
        try {
            return (String)this.connection_.callMethodReturnsObject(this.pxId_, "toString");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw ProxyClientConnection.rethrow(invocationTargetException);
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        return this.callMethodRtnRaw("absolute", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueBoolean();
    }

    @Override
    public void afterLast() throws SQLException {
        this.callMethod("afterLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.callMethod("beforeFirst");
    }

    @Override
    public boolean first() throws SQLException {
        return this.callMethodRtnBool("first");
    }

    @Override
    public int getRow() throws SQLException {
        return this.callMethodRtnInt("getRow");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.callMethodRtnBool("isAfterLast");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.callMethodRtnBool("isBeforeFirst");
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.callMethodRtnBool("isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.callMethodRtnBool("isLast");
    }

    @Override
    public boolean last() throws SQLException {
        return this.callMethodRtnBool("last");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.callMethod("moveToCurrentRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.callMethod("moveToInsertRow");
    }

    @Override
    public boolean next() throws SQLException {
        return this.callMethodRtnBool("next");
    }

    @Override
    public boolean previous() throws SQLException {
        return this.callMethodRtnBool("previous");
    }

    @Override
    public void refreshRow() throws SQLException {
        this.callMethod("refreshRow");
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return this.callMethodRtnRaw("relative", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueBoolean();
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return (Array)this.callMethodRtnObj("getArray", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return this.callMethodRtnInpStrm("getAsciiStream", n);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.callMethodRtnObj("getBigDecimal", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return (BigDecimal)this.callMethodRtnObj("getBigDecimal", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        return this.callMethodRtnInpStrm("getBinaryStream", n);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        try {
            JDBlobProxy jDBlobProxy = new JDBlobProxy();
            return (JDBlobProxy)this.connection_.callFactoryMethod(this.pxId_, "getBlob", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDBlobProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        return this.callMethodRtnRaw("getBoolean", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueBoolean();
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        return this.callMethodRtnRaw("getByte", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueByte();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.callMethodRtnObj("getBytes", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        try {
            JDReaderProxy jDReaderProxy = new JDReaderProxy();
            return (JDReaderProxy)this.connection_.callFactoryMethod(this.pxId_, "getCharacterStream", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDReaderProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        try {
            JDClobProxy jDClobProxy = new JDClobProxy();
            return (JDClobProxy)this.connection_.callFactoryMethod(this.pxId_, "getClob", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDClobProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{String.class}, new Object[]{string});
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return (Date)this.callMethodRtnObj("getDate", new Class[]{Integer.TYPE, Calendar.class}, new Object[]{new Integer(n), calendar});
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        return this.callMethodRtnRaw("getDouble", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueDouble();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return this.callMethodRtnRaw("getFloat", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueFloat();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        return this.callMethodRtnRaw("getInt", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueInt();
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        return this.callMethodRtnRaw("getLong", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueLong();
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            JDResultSetMetaDataProxy jDResultSetMetaDataProxy = new JDResultSetMetaDataProxy(this.jdConnection_);
            return (JDResultSetMetaDataProxy)this.connection_.callFactoryMethod(this.pxId_, "getMetaData", jDResultSetMetaDataProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        String string = this.getMetaData().getColumnTypeName(n);
        AbstractProxyImpl abstractProxyImpl = null;
        try {
            if (string.equalsIgnoreCase("BLOB")) {
                abstractProxyImpl = new JDBlobProxy();
            } else if (string.equalsIgnoreCase("CLOB")) {
                abstractProxyImpl = new JDClobProxy();
            } else {
                return this.callMethodRtnObj("getObject", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
            }
            return this.connection_.callFactoryMethod(this.pxId_, "getObject", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, abstractProxyImpl);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        String string = this.getMetaData().getColumnTypeName(n);
        AbstractProxyImpl abstractProxyImpl = null;
        try {
            if (string.equalsIgnoreCase("BLOB")) {
                abstractProxyImpl = new JDBlobProxy();
            } else if (string.equalsIgnoreCase("CLOB")) {
                abstractProxyImpl = new JDClobProxy();
            } else {
                return this.callMethodRtnObj("getObject", new Class[]{Integer.TYPE, Map.class}, new Object[]{new Integer(n), map});
            }
            return this.connection_.callFactoryMethod(this.pxId_, "getObject", new Class[]{Integer.TYPE, Map.class}, new Object[]{new Integer(n), map}, abstractProxyImpl);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        return (Ref)this.callMethodRtnObj("getRef", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public short getShort(int n) throws SQLException {
        return this.callMethodRtnRaw("getShort", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}).getReturnValueShort();
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public String getString(int n) throws SQLException {
        return (String)this.callMethodRtnObj("getString", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return (Time)this.callMethodRtnObj("getTime", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return (Time)this.callMethodRtnObj("getTime", new Class[]{Integer.TYPE, Calendar.class}, new Object[]{new Integer(n), calendar});
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.callMethodRtnObj("getTimestamp", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return (Timestamp)this.callMethodRtnObj("getTimestamp", new Class[]{Integer.TYPE, Calendar.class}, new Object[]{new Integer(n), calendar});
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.callMethodRtnInpStrm("getUnicodeStream", n);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public URL getURL(int n) throws SQLException {
        return (URL)this.callMethodRtnObj("getURL", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return (URL)this.callMethodRtnObj("getURL", new Class[]{String.class}, new Object[]{string});
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.callMethodRtnBool("wasNull");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.callMethod("cancelRowUpdates");
    }

    @Override
    public void deleteRow() throws SQLException {
        this.callMethod("deleteRow");
    }

    @Override
    public void insertRow() throws SQLException {
        this.callMethod("insertRow");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.callMethodRtnBool("rowDeleted");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.callMethodRtnBool("rowInserted");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.callMethodRtnBool("rowUpdated");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        if (array != null && !(array instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateArray", new Class[]{Integer.TYPE, Array.class}, new Object[]{new Integer(n), array});
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        if (array != null && !(array instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateArray", new Class[]{String.class, Array.class}, new Object[]{string, array});
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.getMessage());
                try {
                    sQLException.initCause(iOException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        this.callMethod("updateAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, new Object[]{new Integer(n), inputStream2, new Integer(n2)});
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.callMethod("updateBigDecimal", new Class[]{Integer.TYPE, BigDecimal.class}, new Object[]{new Integer(n), bigDecimal});
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.getMessage());
                try {
                    sQLException.initCause(iOException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        this.callMethod("updateBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE}, new Object[]{new Integer(n), inputStream2, new Integer(n2)});
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        this.callMethod("updateBlob", new Class[]{Integer.TYPE, Blob.class}, new Object[]{new Integer(n), blob});
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.callMethod("updateBlob", new Class[]{String.class, Blob.class}, new Object[]{string, blob});
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.callMethod("updateBoolean", new Class[]{Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(n), new Boolean(bl)});
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        this.callMethod("updateByte", new Class[]{Integer.TYPE, Byte.TYPE}, new Object[]{new Integer(n), new Byte(by)});
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.callMethod("updateBytes", new Class[]{Integer.TYPE, byte[].class}, new Object[]{new Integer(n), byArray});
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader, Math.max(0, n2));
            this.callMethod("updateCharacterStream", new Class[]{Integer.TYPE, Reader.class, Integer.TYPE}, new Object[]{new Integer(n), serializableReader, new Integer(n2)});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        this.callMethod("updateClob", new Class[]{Integer.TYPE, Clob.class}, new Object[]{new Integer(n), clob});
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.callMethod("updateClob", new Class[]{String.class, Clob.class}, new Object[]{string, clob});
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.callMethod("updateDate", new Class[]{Integer.TYPE, Date.class}, new Object[]{new Integer(n), date});
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.callMethod("updateDouble", new Class[]{Integer.TYPE, Double.TYPE}, new Object[]{new Integer(n), new Double(d)});
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.callMethod("updateFloat", new Class[]{Integer.TYPE, Float.TYPE}, new Object[]{new Integer(n), new Float(f)});
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.callMethod("updateInt", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.callMethod("updateLong", new Class[]{Integer.TYPE, Long.TYPE}, new Object[]{new Integer(n), new Long(l)});
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        this.callMethod("updateNull", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        if (object != null && !(object instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateObject", new Class[]{Integer.TYPE, Object.class}, new Object[]{new Integer(n), object});
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (object != null && !(object instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateObject", new Class[]{Integer.TYPE, Object.class, Integer.TYPE}, new Object[]{new Integer(n), object, new Integer(n2)});
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        if (ref != null && !(ref instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateRef", new Class[]{Integer.TYPE, Ref.class}, new Object[]{new Integer(n), ref});
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        if (ref != null && !(ref instanceof Serializable)) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, NOT_SERIALIZABLE);
            }
            throw new SQLException();
        }
        this.callMethod("updateRef", new Class[]{String.class, Ref.class}, new Object[]{string, ref});
    }

    @Override
    public void updateRow() throws SQLException {
        this.callMethod("updateRow");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        this.callMethod("updateShort", new Class[]{Integer.TYPE, Short.TYPE}, new Object[]{new Integer(n), new Short(s)});
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.callMethod("updateString", new Class[]{Integer.TYPE, String.class}, new Object[]{new Integer(n), string});
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.callMethod("updateTime", new Class[]{Integer.TYPE, Time.class}, new Object[]{new Integer(n), time});
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.callMethod("updateTimestamp", new Class[]{Integer.TYPE, Timestamp.class}, new Object[]{new Integer(n), timestamp});
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.callMethodRtnInt("getHoldability");
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        try {
            JDReaderProxy jDReaderProxy = new JDReaderProxy();
            return (JDReaderProxy)this.connection_.callFactoryMethod(this.pxId_, "getNCharacterStream", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDReaderProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        try {
            JDNClobProxy jDNClobProxy = new JDNClobProxy();
            return (JDNClobProxy)this.connection_.callFactoryMethod(this.pxId_, "getNClob", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDNClobProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        return (String)this.callMethodRtnObj("getNString", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        try {
            JDRowIdProxy jDRowIdProxy = new JDRowIdProxy();
            return (JDRowIdProxy)this.connection_.callFactoryMethod(this.pxId_, "getRowId", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDRowIdProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        try {
            JDSQLXMLProxy jDSQLXMLProxy = new JDSQLXMLProxy();
            return (JDSQLXMLProxy)this.connection_.callFactoryMethod(this.pxId_, "getSQLXML", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)}, jDSQLXMLProxy);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JDConnectionProxy.rethrow1(invocationTargetException);
        }
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader, Math.max(0, (int)l));
            this.callMethod("updateNCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{new Integer(n), serializableReader, new Long(l)});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.callMethod("updateNClob", new Class[]{Integer.TYPE, NClob.class}, new Object[]{new Integer(n), nClob});
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        this.callMethod("updateNString", new Class[]{Integer.TYPE, String.class}, new Object[]{new Integer(n), string});
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        this.callMethod("updateRowId", new Class[]{Integer.TYPE, RowId.class}, new Object[]{new Integer(n), rowId});
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.callMethod("updateSQLXML", new Class[]{Integer.TYPE, SQLXML.class}, new Object[]{new Integer(n), sQLXML});
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    protected String[] getValidWrappedList() {
        return new String[]{"java.sql.ResultSet"};
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.getMessage());
                try {
                    sQLException.initCause(iOException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        this.callMethod("updateAsciiStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{new Integer(n), inputStream2, new Long(l)});
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.getMessage());
                try {
                    sQLException.initCause(iOException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        this.callMethod("updateBinaryStream", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{new Integer(n), inputStream2, new Long(l)});
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.getMessage());
                try {
                    sQLException.initCause(iOException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        this.callMethod("updateBlob", new Class[]{Integer.TYPE, InputStream.class, Long.TYPE}, new Object[]{new Integer(n), inputStream2, new Long(l)});
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader, Math.max(0, (int)l));
            this.callMethod("updateCharacterStream", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{new Integer(n), serializableReader, new Long(l)});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader, Math.max(0, (int)l));
            this.callMethod("updateClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{new Integer(n), serializableReader, new Long(l)});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader, Math.max(0, (int)l));
            this.callMethod("updateNClob", new Class[]{Integer.TYPE, Reader.class, Long.TYPE}, new Object[]{new Integer(n), serializableReader, new Long(l)});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.callMethodRtnBool("isClosed");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.getMessage());
                try {
                    sQLException.initCause(iOException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        this.callMethod("updateAsciiStream", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{new Integer(n), inputStream2});
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.getMessage());
                try {
                    sQLException.initCause(iOException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        this.callMethod("updateBinaryStream", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{new Integer(n), inputStream2});
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        InputStream inputStream2;
        if (inputStream == null || inputStream instanceof Serializable) {
            inputStream2 = inputStream;
        } else {
            try {
                inputStream2 = new SerializableInputStream(inputStream);
            }
            catch (IOException iOException) {
                SQLException sQLException = new SQLException(iOException.getMessage());
                try {
                    sQLException.initCause(iOException);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw sQLException;
            }
        }
        this.callMethod("updateBlob", new Class[]{Integer.TYPE, InputStream.class}, new Object[]{new Integer(n), inputStream2});
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("updateCharacterStream", new Class[]{Integer.TYPE, Reader.class}, new Object[]{new Integer(n), serializableReader});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("updateClob", new Class[]{Integer.TYPE, Reader.class}, new Object[]{new Integer(n), serializableReader});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("updateNCharacterStream", new Class[]{Integer.TYPE, Reader.class}, new Object[]{new Integer(n), serializableReader});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        try {
            SerializableReader serializableReader = reader == null ? null : new SerializableReader(reader);
            this.callMethod("updateNClob", new Class[]{Integer.TYPE, Reader.class}, new Object[]{new Integer(n), serializableReader});
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.getMessage());
            try {
                sQLException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(string), reader);
    }

    public void updateDB2Default(int n) throws SQLException {
        this.callMethod("updateDB2Default", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    public void updateDBDefault(int n) throws SQLException {
        this.updateDB2Default(n);
    }

    public void updateDB2Default(String string) throws SQLException {
        this.updateDB2Default(this.findColumn(string));
    }

    public void updateDBDefault(String string) throws SQLException {
        this.updateDB2Default(this.findColumn(string));
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return null;
    }
}

