/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.internal.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.core.internal.util.Util;

public class PaperClipsUtil {
    private PaperClipsUtil() {
    }

    public static void dispose(PrintPiece piece) {
        if (piece != null) {
            piece.dispose();
        }
    }

    public static void dispose(PrintPiece p1, PrintPiece p2) {
        PaperClipsUtil.dispose(p1);
        PaperClipsUtil.dispose(p2);
    }

    public static void dispose(PrintPiece[] pieces) {
        if (pieces != null) {
            int i = 0;
            while (i < pieces.length) {
                PaperClipsUtil.dispose(pieces[i]);
                ++i;
            }
        }
    }

    public static void dispose(PrintPiece[] pages, int start, int end) {
        int i = start;
        while (i < end) {
            pages[i].dispose();
            ++i;
        }
    }

    public static void dispose(List<PrintPiece> pages) {
        Iterator<PrintPiece> it = pages.iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
        pages.clear();
    }

    public static void dispose(PrintPiece piece, PrintPiece[] pieces) {
        PaperClipsUtil.dispose(piece);
        PaperClipsUtil.dispose(pieces);
    }

    public static int[] copy(int[] array) {
        Util.notNull(array);
        return (int[])array.clone();
    }

    public static int[][] copy(int[][] array) {
        Util.notNull(array);
        int[][] result = (int[][])array.clone();
        int i = 0;
        while (i < result.length) {
            result[i] = PaperClipsUtil.copy(result[i]);
            ++i;
        }
        return result;
    }

    public static int sum(int[] array) {
        return PaperClipsUtil.sum(array, 0, array.length);
    }

    public static int sum(int[] array, int start, int count) {
        Util.notNull(array);
        int result = 0;
        int end = start + count;
        int i = start;
        while (i < end) {
            result += array[i];
            ++i;
        }
        return result;
    }

    public static int sumByIndex(int[] array, int[] indices) {
        Util.notNull(array);
        int result = 0;
        int i = 0;
        while (i < indices.length) {
            result += array[indices[i]];
            ++i;
        }
        return result;
    }

    public static int[] toIntArray(List<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public static int[][] toIntIntArray(List<int[]> list) {
        int[][] array = new int[list.size()][];
        int i = 0;
        while (i < array.length) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    public static int firstMatch(int value, int[] masks, int defaultMask) {
        Util.notNull(masks);
        int i = 0;
        while (i < masks.length) {
            int mask = masks[i];
            if ((value & mask) == mask) {
                return mask;
            }
            ++i;
        }
        return defaultMask;
    }
}

