/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.notifications.internal;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import miworkplace.i18n.Messages;
import miworkplace.notifications.Notifier;
import miworkplace.ui.pref.api.IPreferenceNode;
import miworkplace.ui.pref.api.IPreferenceProvider;
import miworkplace.ui.pref.api.IPreferencesService;
import miworkplace.ui.pref.api.Preference;
import miworkplace.ui.pref.api.PreferenceNode;
import miworkplace.ui.pref.api.SelectionPreference;

public class PreferenceProvider
implements IPreferenceProvider {
    private final List<IPreferenceNode> preferenceNodes = new LinkedList<IPreferenceNode>();

    public PreferenceProvider() {
        PreferenceNode node = (PreferenceNode)new PreferenceNode().setId("miworkplace.notifications").setName(Messages.ui_pref_notifications);
        node.setPreferences(this.buildPreferences());
        this.preferenceNodes.add((IPreferenceNode)node);
    }

    private Set<Preference> buildPreferences() {
        HashSet<Preference> preferences = new HashSet<Preference>();
        SelectionPreference preference = new SelectionPreference();
        preference.setId("miworkplace.notifications.position");
        preference.setType(Set.class);
        preference.setName(Messages.ui_pref_notifications_pos);
        preference.setValue(Notifier.Placement.WINDOW_BOTTOM.name());
        preference.addSuggestion(Notifier.Placement.SCREEN_CENTER.name());
        preference.addSuggestion(Notifier.Placement.SCREEN_BOTTOM.name());
        preference.addSuggestion(Notifier.Placement.WINDOW_BOTTOM.name());
        preference.addSuggestion(Notifier.Placement.WINDOW_CENTER.name());
        preferences.add((Preference)preference);
        return preferences;
    }

    public void bindPreferenceService(IPreferencesService service) {
        for (IPreferenceNode node : this.getPreferenceNodes()) {
            service.add(node);
        }
    }

    public void unbindPreferenceService(IPreferencesService service) {
        for (IPreferenceNode node : this.getPreferenceNodes()) {
            service.remove(node);
        }
    }

    public List<IPreferenceNode> getPreferenceNodes() {
        return this.preferenceNodes;
    }
}

