/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.ui.framework.SystemResourceFinder;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.framework.java.WindowManager;
import com.ibm.as400.ui.util.MessagesBean;
import com.ibm.as400.ui.util.ResourceLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MessageViewer
implements ListSelectionListener {
    public static final int STYLE_OK_SINGLE = 0;
    public static final int STYLE_OKCANCEL_DUAL = 1;
    public static final String DETAILS_BUTTON = "IDC_CM_MSG_DETAILS";
    public static final String OK_SINGLE_BUTTON = "IDC_CM_MSG_OK_SINGLE";
    public static final String OK_DUAL_BUTTON = "IDC_OK_DUAL";
    public static final String CANCEL_BUTTON = "IDC_CANCEL";
    public static final String ACTION_BUTTON = "IDC_CM_MSG_ACTION";
    public static final String COPY_BUTTON = "IDC_CM_MSG_COPY";
    static ResourceLoader resourceLoader = new ResourceLoader();
    MessagesBean m_msgBean = new MessagesBean();
    DynamicPanelManager m_panelManager = null;
    JList m_listMsg = null;
    int m_iStyle = 0;

    public MessageViewer(String string) {
        this(string, null, null);
    }

    public MessageViewer(String string, Frame frame) {
        this(string, frame, null);
    }

    public MessageViewer(String string, PanelManager panelManager) {
        this(string, null, panelManager);
    }

    private MessageViewer(String string, Frame frame, PanelManager panelManager) {
        this.m_msgBean.load();
        DataBean[] dataBeanArray = new DataBean[]{this.m_msgBean};
        try {
            this.m_panelManager = new DynamicPanelManager("com.ibm.as400.ui.util.MessageViewerPanels", "IDD_CM_MESSAGE_VIEWER", dataBeanArray, frame);
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
            System.exit(-1);
        }
        if (panelManager != null) {
            this.m_panelManager.setModalRelativeTo((WindowManager)panelManager);
        }
        this.m_listMsg = null;
        this.m_listMsg = (JList)this.m_panelManager.getComponent("IDC_CM_MESSAGE_DISPLAY");
        if (this.m_listMsg != null) {
            this.m_listMsg.addListSelectionListener(this);
        }
        Component component = this.m_panelManager.getComponent(DETAILS_BUTTON);
        component.setEnabled(false);
        component = this.m_panelManager.getComponent(ACTION_BUTTON);
        component.setVisible(false);
        this.setStyle(this.m_iStyle);
        this.setTitle(string);
        this.setInstructionText("");
    }

    public void setVisible(boolean bl) {
        if (this.m_msgBean.getMessageCount() > 0) {
            this.m_msgBean.setSelection(0);
        }
        boolean bl2 = this.m_msgBean.getMessageCount() > 1;
        Component component = this.m_panelManager.getComponent("IDC_CM_MESSAGE_DISPLAY");
        component.setVisible(bl2);
        Container container = component.getParent();
        container.setVisible(bl2);
        Container container2 = container.getParent();
        container2.setVisible(bl2);
        Component component2 = this.m_panelManager.getComponent("IDC_CM_SINGLE_MESSAGE_DISPLAY");
        component2.setVisible(!bl2);
        Container container3 = component2.getParent();
        container3.setVisible(!bl2);
        Container container4 = container3.getParent();
        container4.setVisible(!bl2);
        ((JTextArea)component2).setText(this.m_msgBean.getSelectedMessage());
        Component component3 = this.m_panelManager.getComponent(DETAILS_BUTTON);
        component3.setVisible(this.m_msgBean.hasAnyMessageDetail());
        this.m_panelManager.setVisible(bl);
    }

    public void setStyle(int n) {
        if (n == 1) {
            this.m_iStyle = 1;
            Component component = this.m_panelManager.getComponent("IDC_OK_SINGLE");
            component.setVisible(false);
            component = this.m_panelManager.getComponent(OK_DUAL_BUTTON);
            component.setVisible(true);
            component = this.m_panelManager.getComponent(CANCEL_BUTTON);
            component.setVisible(true);
        } else {
            this.m_iStyle = 0;
            Component component = this.m_panelManager.getComponent("IDC_OK_SINGLE");
            component.setVisible(true);
            component = this.m_panelManager.getComponent(OK_DUAL_BUTTON);
            component.setVisible(false);
            component = this.m_panelManager.getComponent(CANCEL_BUTTON);
            component.setVisible(false);
        }
    }

    public int getStyle() {
        return this.m_iStyle;
    }

    public void setExitOnClose(boolean bl) {
        this.m_panelManager.setExitOnClose(bl);
    }

    public boolean getExitOnClose() {
        return this.m_panelManager.getExitOnClose();
    }

    public void setTitle(String string) {
        if (string != null && string.length() > 0) {
            this.m_panelManager.setTitle(string);
        }
    }

    public String getTitle() {
        return this.m_panelManager.getTitle();
    }

    public void setInstructionText(String string) {
        if (string != null) {
            Component component = this.m_panelManager.getComponent("IDC_CM_STATIC_MESSAGE_INSTRUCTIONS");
            if (component == null) {
                return;
            }
            if (JLabel.class.isAssignableFrom(component.getClass())) {
                ((JLabel)component).setText(string);
            } else {
                ((JTextArea)component).setText(string);
            }
        }
    }

    public String getInstructionText() {
        Component component = this.m_panelManager.getComponent("IDC_CM_STATIC_MESSAGE_INSTRUCTIONS");
        if (component == null) {
            return "";
        }
        if (JLabel.class.isAssignableFrom(component.getClass())) {
            return ((JLabel)component).getText();
        }
        return ((JTextArea)component).getText();
    }

    public void addActionListenerButtonOKDual(ActionListener actionListener) {
        JButton jButton = (JButton)this.m_panelManager.getComponent(OK_DUAL_BUTTON);
        jButton.addActionListener(actionListener);
    }

    public void addActionListenerButtonCancel(ActionListener actionListener) {
        JButton jButton = (JButton)this.m_panelManager.getComponent(CANCEL_BUTTON);
        jButton.addActionListener(actionListener);
    }

    public void addActionListenerButtonOKSingle(ActionListener actionListener) {
        JButton jButton = (JButton)this.m_panelManager.getComponent("IDC_OK_SINGLE");
        jButton.addActionListener(actionListener);
    }

    public String getButtonTextOKDual() {
        JButton jButton = (JButton)this.m_panelManager.getComponent(OK_DUAL_BUTTON);
        if (jButton != null) {
            return jButton.getText();
        }
        return "";
    }

    public String getButtonTextOKSingle() {
        JButton jButton = (JButton)this.m_panelManager.getComponent("IDC_OK_SINGLE");
        if (jButton != null) {
            return jButton.getText();
        }
        return "";
    }

    public String getButtonTextCancel() {
        JButton jButton = (JButton)this.m_panelManager.getComponent(CANCEL_BUTTON);
        if (jButton != null) {
            return jButton.getText();
        }
        return "";
    }

    public void setButtonTextOKDual(String string) {
        if (string != null) {
            JButton jButton = (JButton)this.m_panelManager.getComponent(OK_DUAL_BUTTON);
            jButton.setText(string);
        }
    }

    public void setButtonTextOKSingle(String string) {
        if (string != null) {
            JButton jButton = (JButton)this.m_panelManager.getComponent("IDC_OK_SINGLE");
            jButton.setText(string);
        }
    }

    public void setButtonTextCancel(String string) {
        if (string != null) {
            JButton jButton = (JButton)this.m_panelManager.getComponent(CANCEL_BUTTON);
            jButton.setText(string);
        }
    }

    public String getButtonText(String string) {
        JButton jButton = (JButton)this.m_panelManager.getComponent(string);
        if (jButton != null) {
            return jButton.getText();
        }
        return "";
    }

    public void setButtonText(String string, String string2) {
        JButton jButton;
        if (string2 != null && (jButton = (JButton)this.m_panelManager.getComponent(string)) != null) {
            jButton.setText(string2);
        }
    }

    public void setButtonFlyoverText(String string, String string2) {
        JButton jButton;
        if (string2 != null && (jButton = (JButton)this.m_panelManager.getComponent(string)) != null) {
            jButton.setToolTipText(string2);
        }
    }

    public String getButtonFlyoverText(String string) {
        JButton jButton = (JButton)this.m_panelManager.getComponent(string);
        if (jButton != null) {
            return jButton.getToolTipText();
        }
        return "";
    }

    public void addActionListenerButtonDetails(ActionListener actionListener) {
        JButton jButton = (JButton)this.m_panelManager.getComponent(DETAILS_BUTTON);
        jButton.addActionListener(actionListener);
    }

    public void addActionListenerButtonAction(ActionListener actionListener) {
        JButton jButton = (JButton)this.m_panelManager.getComponent(ACTION_BUTTON);
        jButton.addActionListener(actionListener);
        jButton.setVisible(true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.m_listMsg) {
            JButton jButton = (JButton)this.m_panelManager.getComponent(DETAILS_BUTTON);
            int[] nArray = this.m_listMsg.getSelectedIndices();
            if (nArray.length == 1) {
                this.m_msgBean.setSelection(nArray[0]);
            } else {
                this.m_msgBean.setSelection(-1);
            }
            jButton.setEnabled(this.m_msgBean.selectedMessageHasDetail());
            JButton jButton2 = (JButton)this.m_panelManager.getComponent(COPY_BUTTON);
            jButton2.setEnabled(nArray.length > 0);
        }
    }

    public void addMessage(String string, String string2, String string3) {
        this.m_msgBean.addMessage(string, string2, string3);
    }

    public void addMessage(String string, String string2, String string3, String string4) {
        this.m_msgBean.addMessage(string, string2, string3, string4);
    }

    public void addMessage(String string, String string2, URL uRL) {
        this.m_msgBean.addMessage(string, string2, uRL);
    }

    public void addMessage(String string) {
        this.m_msgBean.addMessage(string, "", "");
    }

    public void addMessage(AS400Message aS400Message) {
        this.m_msgBean.addMessage(aS400Message);
    }

    public void addMessages(AS400Message[] aS400MessageArray) {
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            this.m_msgBean.addMessage(aS400MessageArray[i]);
        }
    }

    public void addMessages(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_msgBean.addMessage(stringArray[i], stringArray2[i], stringArray3[i]);
        }
    }

    public static void showMessage(String string, String string2, String string3, String string4, String string5, Frame frame) {
        MessageViewer messageViewer = new MessageViewer(string, frame);
        messageViewer.addMessage(string2, string3, string4);
        messageViewer.setInstructionText(string5);
        messageViewer.setStyle(0);
        messageViewer.setVisible(true);
    }

    public static void showMessage(String string, String string2, String string3, String string4, String string5, String string6, Frame frame) {
        MessageViewer messageViewer = new MessageViewer(string, frame);
        messageViewer.addMessage(string2, string3, string4, string5);
        messageViewer.setInstructionText(string6);
        messageViewer.setStyle(0);
        messageViewer.setVisible(true);
    }

    public static void showMessage(String string, AS400Message[] aS400MessageArray, AS400 aS400, String string2, Frame frame) {
        MessageViewer messageViewer = new MessageViewer(string, frame);
        messageViewer.setSystem(aS400);
        messageViewer.setInstructionText(string2);
        messageViewer.addMessages(aS400MessageArray);
        messageViewer.setStyle(0);
        messageViewer.setVisible(true);
    }

    public void setSystem(AS400 aS400) {
        this.m_msgBean.setSystem(aS400);
    }

    public AS400 getSystem() {
        return this.m_msgBean.getSystem();
    }

    public void setIconName(String string) {
        this.m_panelManager.setIconName(string);
        Container container = this.m_panelManager.getContainer();
        Window window = this.m_panelManager.getWindow();
        if (window instanceof Frame) {
            ImageIcon imageIcon = null;
            try {
                imageIcon = SystemResourceFinder.getImageResource((String)string);
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println(missingResourceException);
            }
            if (imageIcon != null) {
                ((Frame)window).setIconImage(imageIcon.getImage());
            }
        }
    }

    public String getIconName() {
        return this.m_panelManager.getIconName();
    }

    public void setHelpSet(String string) {
        this.m_msgBean.setHelpSet(string);
    }

    public String getHelpSet() {
        return this.m_msgBean.getHelpSet();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }

    static {
        resourceLoader.setResourceName("com.ibm.as400.ui.util.MessageViewerPanels");
    }
}

