/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClSyntax;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

final class ClTypes {
    static final int UNSUPPORTED = 0;
    static final int DEC = 1;
    static final int LGL = 2;
    static final int CHAR = 3;
    static final int NAME = 4;
    static final int SNAME = 5;
    static final int CNAME = 6;
    static final int PNAME = 7;
    static final int GENERIC = 8;
    static final int CMDSTR = 9;
    static final int DATE = 10;
    static final int TIME = 11;
    static final int HEX = 12;
    static final int X = 13;
    static final int INT2 = 14;
    static final int INT4 = 15;
    static final int VARNAME = 16;
    static final int CMD = 17;
    static final int ELEM = 18;
    static final int QUAL = 19;
    static final int ZELEM = 20;
    static final int UINT2 = 21;
    static final int UINT4 = 22;
    static final int ALWAYS = 200;
    static final int SPCFD = 201;
    static final int UNSPCFD = 202;
    static final int GT = 203;
    static final int EQ = 204;
    static final int NL = 205;
    static final int LT = 206;
    static final int NE = 207;
    static final int LE = 208;
    static final int NG = 209;
    static final int GE = 210;
    static final int NONE = 999;
    static final int MESSAGE_MAX_NESTING = 10;
    static final int MESSAGE_UNMATCHED_PAREN = 13;
    static final int MESSAGE_UNMATCHED_APOST = 14;
    static final int MESSAGE_INVALID_NOT_QUOTED = 18;
    static final int MESSAGE_NOTVALID_FOLLOWING = 20;
    static final int MESSAGE_LIBRARY_NOT_FOUND = 28;
    static final int MESSAGE_COMMAND_NOT_FOUND = 30;
    static final int MESSAGE_NOT_AUTHORIZED_CMD = 32;
    static final int MESSAGE_INVALID_CMD_NAME = 33;
    static final int MESSAGE_INVALID_LIB_NAME = 35;
    static final int MESSAGE_MULTIPLE_SPECIFIED = 42;
    static final int MESSAGE_INVALID_KEYWORD = 43;
    static final int MESSAGE_POS_AFTER_KWD = 44;
    static final int MESSAGE_TOO_MANY_QUALIFIERS = 45;
    static final int MESSAGE_TOO_MANY_VALUES = 46;
    static final int MESSAGE_LIST_NOT_NEEDED = 47;
    static final int MESSAGE_LIST_NOT_NEEDED_QUAL = 48;
    static final int MESSAGE_NOT_ENOUGH_IN_LIST = 62;
    static final int MESSAGE_TOO_MANY_LIST_ITEMS = 63;
    static final int MESSAGE_TOO_MANY_POS_PARMS = 65;
    static final int MESSAGE_QUALIFIER_REQUIRED = 70;
    static final int MESSAGE_PARM_REQUIRED = 71;
    static final int MESSAGE_VALUE_TOO_LONG = 74;
    static final int MESSAGE_VALUE_REQ_LENGTH = 75;
    static final int MESSAGE_VALUE_NOT_NUMERIC = 76;
    static final int MESSAGE_INVALID_DEC_POINT = 77;
    static final int MESSAGE_INVALID_NAME = 78;
    static final int MESSAGE_INVALID_GNAME = 79;
    static final int MESSAGE_INVALID_LOGICAL = 80;
    static final int MESSAGE_VARIABLE_REQUIRED = 81;
    static final int MESSAGE_INVALID_DATE = 82;
    static final int MESSAGE_INVALID_TIME = 83;
    static final int MESSAGE_RESTRICTED_VALUE = 84;
    static final int MESSAGE_WITHIN_RANGE = 85;
    static final int MESSAGE_RANGE_GT = 86;
    static final int MESSAGE_RANGE_EQ = 87;
    static final int MESSAGE_RANGE_GE = 88;
    static final int MESSAGE_RANGE_LT = 89;
    static final int MESSAGE_RANGE_NE = 90;
    static final int MESSAGE_RANGE_LE = 91;
    static final int MESSAGE_SPC_VALUE_IN_LIST = 94;
    static final int MESSAGE_NUM_TOO_LARGE = 95;
    static final int MESSAGE_INVALID_HEX = 97;
    static final int MESSAGE_INVALID_DEC = 98;
    static final int MESSAGE_FLOAT_LARGE = 100;
    static final int MESSAGE_VARIABLE_TOO_LONG = 106;
    static final int MESSAGE_FLOAT_SMALL = 111;
    static final int MESSAGE_FLOAT_EXPONENT = 112;
    static final int MESSAGE_SIGN = 127;
    static final int MESSAGE_INVALID_SNAME = 133;
    static final int MESSAGE_INVALID_CNAME = 134;
    static final int MESSAGE_REL_GT = 141;
    static final int MESSAGE_REL_EQ = 142;
    static final int MESSAGE_REL_GE = 143;
    static final int MESSAGE_REL_LT = 144;
    static final int MESSAGE_REL_NE = 145;
    static final int MESSAGE_REL_LE = 146;
    static final int MESSAGE_CMD_TOO_LONG = 183;
    static final int MESSAGE_PATH_ASTERISK = 186;
    static final int MESSAGE_WILDCARD_IN_PATH = 188;
    static final int MESSAGE_PATH_MISMATCHED = 189;
    static final int MESSAGE_HELP_NOT_DEFINED = 6839;

    ClTypes() {
    }

    static final int getType(String string) {
        if (string == null || string.equals("")) {
            return 999;
        }
        if (string.equals("DEC")) {
            return 1;
        }
        if (string.equals("LGL")) {
            return 2;
        }
        if (string.equals("CHAR")) {
            return 3;
        }
        if (string.equals("NAME")) {
            return 4;
        }
        if (string.equals("SNAME")) {
            return 5;
        }
        if (string.equals("CNAME")) {
            return 6;
        }
        if (string.equals("PNAME")) {
            return 7;
        }
        if (string.equals("GENERIC")) {
            return 8;
        }
        if (string.equals("CMDSTR")) {
            return 9;
        }
        if (string.equals("DATE")) {
            return 10;
        }
        if (string.equals("TIME")) {
            return 11;
        }
        if (string.equals("HEX")) {
            return 12;
        }
        if (string.equals("X")) {
            return 13;
        }
        if (string.equals("INT2")) {
            return 14;
        }
        if (string.equals("INT4")) {
            return 15;
        }
        if (string.equals("VARNAME")) {
            return 16;
        }
        if (string.equals("CMD")) {
            return 17;
        }
        if (string.equals("ELEM")) {
            return 18;
        }
        if (string.equals("QUAL")) {
            return 19;
        }
        if (string.equals("ZELEM")) {
            return 20;
        }
        if (string.equals("UINT2")) {
            return 21;
        }
        if (string.equals("UINT4")) {
            return 22;
        }
        if (string.equals("ALWAYS")) {
            return 200;
        }
        if (string.equals("SPCFD")) {
            return 201;
        }
        if (string.equals("UNSPCFD")) {
            return 202;
        }
        if (string.equals("GT")) {
            return 203;
        }
        if (string.equals("GE")) {
            return 210;
        }
        if (string.equals("EQ")) {
            return 204;
        }
        if (string.equals("NL")) {
            return 205;
        }
        if (string.equals("LT")) {
            return 206;
        }
        if (string.equals("NE")) {
            return 207;
        }
        if (string.equals("LE")) {
            return 208;
        }
        if (string.equals("NG")) {
            return 209;
        }
        return 0;
    }

    static final boolean compare(int n, int n2, String string, String string2, String string3) {
        switch (n) {
            case 10: 
            case 11: {
                if (!ClSyntax.getDateAndTimeFormats()) {
                    return false;
                }
                if (n == 11) {
                    int n3 = string.indexOf(ClPanel.m_timeSeparator);
                    while (n3 != -1) {
                        string = string.substring(0, n3) + string.substring(n3 + 1, string.length());
                        n3 = string.indexOf(ClPanel.m_timeSeparator);
                    }
                } else {
                    int n4 = string.indexOf(ClPanel.m_dateSeparator);
                    while (n4 != -1) {
                        string = string.substring(0, n4) + string.substring(n4 + 1, string.length());
                        n4 = string.indexOf(ClPanel.m_dateSeparator);
                    }
                }
            }
            case 1: 
            case 2: 
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                return ClTypes.compareLong(n2, string, string2, string3, 10);
            }
            case 3: {
                if (string != null && !ClSyntax.quoted(string)) {
                    string = string.toUpperCase(Locale.ENGLISH);
                }
                if (string3 != null && !ClSyntax.quoted(string3)) {
                    string3 = string3.toUpperCase(Locale.ENGLISH);
                }
                if (string2 != null && !ClSyntax.quoted(string2)) {
                    string2 = string2.toUpperCase(Locale.ENGLISH);
                }
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: {
                String string4;
                if ((string == null || string.equals("")) && string2 != null && !(string4 = ClSyntax.convertHex(string2)).equals(string2)) {
                    int n5 = string4.length();
                    boolean bl = true;
                    if (n5 == 0) {
                        bl = false;
                    }
                    for (int i = 0; i < n5; ++i) {
                        if (string4.charAt(i) == ' ') continue;
                        bl = false;
                    }
                    if (bl) {
                        string2 = string4;
                    }
                }
                return ClTypes.compareString(n2, string, string2, string3);
            }
            case 12: {
                String string5;
                if (string != null && !(string5 = ClSyntax.convertHex(string)).equals("")) {
                    string = string5;
                }
                if (string2 != null && !(string5 = ClSyntax.convertHex(string2)).equals("")) {
                    string2 = string5;
                }
                return ClTypes.compareString(n2, string, string2, string3);
            }
            case 19: {
                String string6;
                if ((string == null || string.equals("")) && string2 != null && !(string6 = ClSyntax.convertHex(string2)).equals(string2)) {
                    int n6 = string6.length();
                    boolean bl = true;
                    if (n6 == 0) {
                        bl = false;
                    }
                    for (int i = 0; i < n6; ++i) {
                        if (string6.charAt(i) == ' ') continue;
                        bl = false;
                    }
                    if (bl) {
                        string2 = string6;
                    }
                }
                return ClTypes.compareString(n2, string, string2, string3);
            }
            case 18: {
                String string7;
                if (string2 == null) {
                    return ClTypes.compareString(n2, string, string2, string3);
                }
                if ((string == null || string.equals("")) && string2 != null && !(string7 = ClSyntax.convertHex(string2)).equals(string2)) {
                    int n7 = string7.length();
                    boolean bl = true;
                    if (n7 == 0) {
                        bl = false;
                    }
                    for (int i = 0; i < n7; ++i) {
                        if (string7.charAt(i) == ' ') continue;
                        bl = false;
                    }
                    if (bl) {
                        string2 = string7;
                    }
                }
                return ClTypes.compareString(n2, string, string2, string3);
            }
        }
        MessageLog.logError((Object)("CP: Unknown type in compare " + n));
        return false;
    }

    static final boolean compareLong(int n, long l, long l2) {
        return ClTypes.compareLong(n, String.valueOf(l), String.valueOf(l2), null, 10);
    }

    static final boolean compareLong(int n, String string, long l) {
        return ClTypes.compareLong(n, string, String.valueOf(l), null, 10);
    }

    static final boolean compareLong(int n, String string, String string2) {
        return ClTypes.compareLong(n, string, string2, null, 10);
    }

    static final boolean compareLong(int n, String string, String string2, String string3, int n2) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            if (string != null && !(string = string.trim()).equals("")) {
                l = n2 == 10 ? Double.valueOf(string).longValue() : Long.valueOf(string, n2).longValue();
            }
            if (string2 != null && !(string2 = string2.trim()).equals("")) {
                l2 = n2 == 10 ? Double.valueOf(string2).longValue() : Long.valueOf(string2, n2).longValue();
            }
            if (string3 != null && !(string3 = string3.trim()).equals("")) {
                l3 = n2 == 10 ? Double.valueOf(string3).longValue() : Long.valueOf(string3, n2).longValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            MessageLog.logError((Object)("CP: Number format exception in compareInt 1:'" + string + "'  2:'" + string2 + "' d:'" + string3 + "'"));
            numberFormatException.printStackTrace();
        }
        switch (n) {
            case 200: {
                return true;
            }
            case 201: {
                if (string == null || string.equals("")) {
                    return false;
                }
                return l3 != l;
            }
            case 202: {
                if (string == null || string.equals("")) {
                    return true;
                }
                return l3 == l;
            }
            case 203: 
            case 205: {
                return l > l2;
            }
            case 204: {
                return l == l2;
            }
            case 210: {
                return l >= l2;
            }
            case 206: {
                return l < l2;
            }
            case 207: {
                return l != l2;
            }
            case 208: 
            case 209: {
                return l <= l2;
            }
        }
        MessageLog.logError((Object)("CP: Unknown relation " + n + " in compareInt"));
        return true;
    }

    static final boolean compareString(int n, String string, String string2, String string3) {
        String string4 = "";
        if (string != null) {
            string4 = string.trim();
        }
        string2 = string2 == null ? "" : string2.trim();
        if (string3 != null) {
            string3 = string3.trim();
        }
        switch (n) {
            case 200: {
                return true;
            }
            case 201: {
                if (string4 == null) {
                    return false;
                }
                if (string4.equals(string3)) {
                    return false;
                }
                return string4.length() != 0;
            }
            case 202: {
                if (string4 == null) {
                    return true;
                }
                if (string4.equals(string3)) {
                    return true;
                }
                return string4.length() == 0;
            }
            case 203: {
                return ClTypes.ebcdicCompare(string4, string2) > 0;
            }
            case 204: {
                return string2.equals(string4);
            }
            case 205: 
            case 210: {
                return ClTypes.ebcdicCompare(string4, string2) >= 0;
            }
            case 206: {
                return ClTypes.ebcdicCompare(string4, string2) < 0;
            }
            case 207: {
                return !string2.equals(string4);
            }
            case 208: 
            case 209: {
                return ClTypes.ebcdicCompare(string4, string2) <= 0;
            }
        }
        MessageLog.logError((Object)("CP: Unknown relation " + n + " in compareString."));
        return false;
    }

    static final int ebcdicCompare(String string, String string2) {
        try {
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                byArray = string.getBytes("cp037");
                byArray2 = string2.getBytes("cp037");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes("Cp037");
                byArray2 = string2.getBytes("Cp037");
            }
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                if (i == byArray2.length - 1) {
                    if (i == byArray.length - 1) {
                        if (byArray[i] < byArray2[i]) {
                            return -1;
                        }
                        if (byArray[i] > byArray2[i]) {
                            return 1;
                        }
                        return 0;
                    }
                    return 1;
                }
                if (byArray[i] < byArray2[i]) {
                    return -1;
                }
                if (byArray[i] <= byArray2[i]) continue;
                return 1;
            }
            return -1;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MessageLog.logError((Object)"CP: Unsupported Encoding Exception.");
            unsupportedEncodingException.printStackTrace();
            return -1;
        }
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

