/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.Job;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClCmd;
import com.ibm.as400.ui.util.ClCommonLayout;
import com.ibm.as400.ui.util.ClElem;
import com.ibm.as400.ui.util.ClNode;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClParm;
import com.ibm.as400.ui.util.ClQual;
import com.ibm.as400.ui.util.ClTypes;
import com.ibm.as400.ui.util.ClValue;
import com.ibm.as400.ui.util.ClValues;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;

final class ClSyntax {
    private static final String BASE_CHAR = "ABCDEFGHIJKLMNOPQRSTUVWXYZ$@#";
    private static final String NAME_CHAR = "0123456789_.";
    private static final String SNAME_CHAR = "0123456789_";
    private static final String CNAME_CHAR = "0123456789";
    private static final String NUMERIC = "0123456789";
    private static final String HEX_CHAR = "0123456789ABCDEF";
    private static final String INT_CHAR = "+-0123456789";
    private static final String INVALID_QUOTED = " *?'\"";
    private static final String COMBO_CHARS = "<>=\u00ac|";
    private static final String LOWER_CHARS = "abcdefghijklmnopqrstuvwxyz";
    private static final int MAX_MONTH = 12;
    private static final int MAX_DAY = 31;
    private static final int MAX_DAYS = 366;
    private static final int MAX_HOUR = 23;
    private static final int MAX_MINUTE = 59;
    private static final int MAX_SECOND = 59;
    private static CharConverter m_converter = null;

    ClSyntax() {
    }

    public static void cleanup() {
        m_converter = null;
    }

    static final boolean quoted(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() < 2) {
            return false;
        }
        if (string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            return true;
        }
        return string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final String quote(int n, String string) {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string == null) {
            return "";
        }
        string = string.trim();
        if (n == 3 || n == 13 || n == 7) {
            String string2;
            int n5;
            String string3;
            n4 = string.length();
            if (n4 == 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            if (n4 > 1 && stringBuffer.charAt(0) == '\'' && stringBuffer.charAt(n4 - 1) == '\'') {
                n3 = 0;
                for (string3 = string.substring(1, n4 - 1); string3 != null && !string3.equals("") && (n5 = string3.indexOf(39)) != -1; string3 = string3.substring(n5 + 2, string3.length())) {
                    if (stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(n4 - 1) == '\"' && (n == 3 || n == 13)) {
                        n3 = 1;
                        break;
                    }
                    if (string3.length() - 1 > n5) {
                        if (string3.charAt(n5 + 1) == '\'') {
                            continue;
                        }
                        n3 = 1;
                        break;
                    }
                    n3 = 1;
                    break;
                }
                if (n3 == 0) {
                    return string;
                }
            }
            if (n4 > 1 && stringBuffer.charAt(0) == '(' && stringBuffer.charAt(n4 - 1) == ')') {
                string3 = new String(stringBuffer);
                string3 = string3.substring(1, n4 - 2);
                stringBuffer = new StringBuffer(string3);
                n4 = stringBuffer.length();
                string = new String(stringBuffer);
                bl3 = true;
                if (n4 == 2) {
                    return "";
                }
            }
            if ((n2 = stringBuffer.charAt(0)) == 42) {
                if (n4 <= 1 || n != 7) return string;
                if (stringBuffer.charAt(1) != '*') return string;
                bl = true;
            }
            n3 = 1;
            n5 = 0;
            boolean bl4 = false;
            if (n2 == 95) {
                bl = true;
            }
            int n6 = 0;
            if (n4 > 3 && (stringBuffer.charAt(0) == 'x' || stringBuffer.charAt(0) == 'X') && stringBuffer.charAt(1) == '\'' && stringBuffer.charAt(n4 - 1) == '\'') {
                bl2 = true;
                string2 = new String(stringBuffer);
                string2 = string2.substring(2, n4 - 2);
                stringBuffer = new StringBuffer(string2);
                n4 = stringBuffer.length();
                n6 = 2;
            }
            if ((n == 3 || n == 13) && n4 > 2 && stringBuffer.charAt(0) == '\"' && stringBuffer.charAt(n4 - 1) == '\"') {
                string2 = new String(stringBuffer);
                string2 = string2.substring(1, n4 - 2);
                stringBuffer = new StringBuffer(string2);
                n4 = stringBuffer.length();
                n6 = 1;
            }
            for (int i = 0; i < n4; ++i) {
                char c;
                int n7;
                n2 = stringBuffer.charAt(i);
                if (n2 == 32 || n2 == 58 || n2 == 37 || n2 == 63 || n2 == 59 || n2 == 44 || n2 == 40 || n2 == 41 || n2 == 92) {
                    if (n3 != 0 && n2 == 44) {
                        if (n4 > 1) {
                            bl4 = true;
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (n2 == 46) {
                    if (i == 0) {
                        bl4 = true;
                        if (n4 == 1) {
                            bl = true;
                        }
                    } else if ("0123456789".indexOf(stringBuffer.charAt(0)) != -1) {
                        for (n7 = 0; n7 < i; ++n7) {
                            c = stringBuffer.charAt(n7);
                            if ("0123456789".indexOf(c) != -1) continue;
                            bl = true;
                        }
                        bl4 = true;
                    }
                    if (n3 != 0 && n5 != 0) {
                        bl = true;
                    }
                    n5 = 1;
                    continue;
                }
                if (n2 == 43 || n2 == 45 || n2 == 42 || n2 == 47 || n2 == 38) {
                    if (n2 == 42 && i + 1 == n4 || i == 0 && n2 == 38) continue;
                    if (i == 0 && (n2 == 43 || n2 == 45)) {
                        bl4 = true;
                        continue;
                    }
                    if (n4 <= 1) continue;
                    bl = true;
                    continue;
                }
                if (n2 == 60 || n2 == 62 || n2 == 61 || n2 == 124 || n2 == 172) {
                    if (n4 == 1) continue;
                    if (n4 == 2) {
                        if (i + 1 < n4) {
                            if (i == 0) {
                                if (COMBO_CHARS.indexOf(stringBuffer.charAt(i + 1)) != -1) continue;
                                bl = true;
                                continue;
                            }
                            n7 = 0;
                            if (COMBO_CHARS.indexOf(stringBuffer.charAt(i + 1)) != -1) {
                                n7 = 1;
                            }
                            char c2 = c = COMBO_CHARS.indexOf(stringBuffer.charAt(i - 1)) != -1 ? (char)'\u0001' : '\u0000';
                            if (n7 != 0 && c != '\u0000') {
                                bl = true;
                                continue;
                            }
                            if (n7 != 0 || c != '\u0000') continue;
                            bl = true;
                            continue;
                        }
                        if (COMBO_CHARS.indexOf(stringBuffer.charAt(i - 1)) != -1) continue;
                        bl = true;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (n2 == 39) {
                    string = string.substring(0, i + n6) + "'" + string.substring(i + n6, string.length());
                    ++n6;
                    bl = true;
                    continue;
                }
                if (BASE_CHAR.indexOf(n2) == -1 && NAME_CHAR.indexOf(n2) == -1 && LOWER_CHARS.indexOf(n2) == -1) {
                    bl = true;
                }
                if ("0123456789".indexOf(n2) != -1) continue;
                n3 = 0;
                if (!bl4) continue;
                bl = true;
            }
        } else if (n == 10 || n == 11) {
            String string4;
            n4 = string.length();
            if (n4 == 0) {
                return string;
            }
            if (n4 > 1 && string.charAt(0) == '\'' && string.charAt(n4 - 1) == '\'') {
                return string;
            }
            char c = string.charAt(0);
            if (c == '*') {
                return string;
            }
            ClSyntax.getDateAndTimeFormats();
            if (n == 10) {
                string4 = "";
                for (n3 = 0; n3 < n4; ++n3) {
                    c = string.charAt(n3);
                    if (c == ClPanel.m_dateSeparator.charAt(0)) continue;
                    string4 = string4 + c;
                }
                string = string4;
            } else if (n == 11) {
                string4 = "";
                for (n3 = 0; n3 < n4; ++n3) {
                    c = string.charAt(n3);
                    if (c == ClPanel.m_timeSeparator.charAt(0)) continue;
                    string4 = string4 + c;
                }
                string = string4;
            }
            n4 = string.length();
            for (n2 = 0; n2 < n4; ++n2) {
                c = string.charAt(n2);
                if ("0123456789".indexOf(c) != -1) continue;
                bl = true;
                break;
            }
        }
        if (!bl && bl2) {
            String string5 = string.substring(2, string.length() - 1).toUpperCase(Locale.ENGLISH);
            for (int i = 0; i < string5.length(); ++i) {
                if (HEX_CHAR.indexOf(string5.charAt(i)) != -1) continue;
                bl = true;
                break;
            }
        }
        if (bl && bl2) {
            string = string.substring(0, 2) + "'" + string.substring(2, string.length()) + "'";
        }
        if (bl && bl3) {
            string = "(" + string + ")";
        }
        if (!bl) return string;
        return "'" + string + "'";
    }

    static final String upperCase(int n, String string) {
        if (string == null) {
            return "";
        }
        if (!ClSyntax.quoted(string) && n != 7 && n != 9 && (n != 3 || string.startsWith("*"))) {
            return string.toUpperCase(Locale.ENGLISH);
        }
        return string;
    }

    static final String convertHex(String string) {
        int n = string.length();
        if (n < 3) {
            return string;
        }
        if ((string.charAt(0) == 'X' || string.charAt(0) == 'x') && string.charAt(1) == '\'' && string.charAt(n - 1) == '\'') {
            if (n == 3) {
                return "";
            }
            string = string.toUpperCase(Locale.ENGLISH);
            string = string.substring(2, n - 1);
            n -= 3;
        } else {
            return string;
        }
        if (m_converter == null) {
            try {
                m_converter = new CharConverter(ClPanel.m_commandCCSID, ClPanel.m_system);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return string;
            }
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)(ClSyntax.getByteFromChar(string.charAt(i)) << 4 | ClSyntax.getByteFromChar(string.charAt(i + 1)));
        }
        return m_converter.byteArrayToString(byArray);
    }

    static final byte getByteFromChar(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        return 0;
    }

    static final boolean isSpecialValueSelected(String string, ClCommonLayout clCommonLayout) {
        Enumeration enumeration = clCommonLayout.getChildren();
        ClNode clNode = null;
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClValues) || !ClSyntax.isSpecialValueSelected(string, (ClValues)clNode)) continue;
                return true;
            }
        }
        if (clCommonLayout.getNodeType() != 2) {
            enumeration = clCommonLayout.getParent().getChildren();
            clNode = null;
            if (enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    clNode = (ClNode)enumeration.nextElement();
                    if (!(clNode instanceof ClElem) && !(clNode instanceof ClQual)) continue;
                    if (clNode == clCommonLayout) break;
                    return false;
                }
            }
            return ClSyntax.isSpecialValueSelected(string, (ClCommonLayout)clCommonLayout.getParent());
        }
        return false;
    }

    static final boolean isSpecialValueSelected(String string, ClValues clValues) {
        boolean bl = false;
        Enumeration enumeration = clValues.getChildren();
        string = string.toUpperCase(Locale.ENGLISH);
        string = string.trim();
        while (enumeration.hasMoreElements()) {
            ClNode clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClValue) || !string.equals(((ClValue)clNode).getVal().toUpperCase(Locale.ENGLISH))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static final String getChoicePgmValue(String string, ClValues clValues) {
        int n;
        if (clValues == null || string == null) {
            return string;
        }
        boolean bl = ClSyntax.isSpecialValueSelected(string, clValues);
        if (bl && !ClSyntax.quoted(string) && (n = string.indexOf(32)) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    static final boolean verifyCommandName(ClPanel clPanel, String string) {
        if (!ClSyntax.checkQuotes(string, '\"')) {
            clPanel.displayAS400Message(33, (Object)string.toUpperCase(Locale.ENGLISH));
            return false;
        }
        return true;
    }

    static final boolean verifyTextField(ClPanel clPanel, JTextComponent jTextComponent, ClCommonLayout clCommonLayout) {
        return ClSyntax.verifyTextField(clPanel, jTextComponent, clCommonLayout, 0, true);
    }

    static final boolean verifyTextField(ClPanel clPanel, JTextComponent jTextComponent, ClCommonLayout clCommonLayout, int n, boolean bl) {
        boolean bl2;
        String string = jTextComponent.getText().trim();
        String string2 = clCommonLayout.getMapToValue(string);
        if (clCommonLayout.getAlwVar() && string2.length() > 1 && (string2.charAt(0) == '$' || string2.charAt(0) == '&' && clCommonLayout.getType() != 16)) {
            return true;
        }
        ClCommonLayout clCommonLayout2 = clCommonLayout;
        while (!(clCommonLayout2 instanceof ClParm)) {
            clCommonLayout2 = (ClCommonLayout)clCommonLayout2.getParent();
        }
        String string3 = ((ClParm)clCommonLayout2).getKwd();
        boolean bl3 = bl2 = !string2.equals(string);
        if (bl2) {
            return true;
        }
        if (string2.equals("") && (clCommonLayout.getMin() == 0 || !bl)) {
            return true;
        }
        if (bl && clCommonLayout.getMin() >= 1) {
            int n2 = n;
            if (!string2.equals("")) {
                ++n2;
            }
            if (n2 < clCommonLayout.getMin()) {
                if (clCommonLayout.getMin() > 1) {
                    clPanel.displayAS400Message(62, (Object)string3);
                } else {
                    clPanel.displayAS400Message(71, (Object)string3);
                }
                jTextComponent.requestFocus();
                return false;
            }
        }
        if (clCommonLayout.getType() == 2) {
            return true;
        }
        if (clCommonLayout.getFull() && (n == 0 || !string2.equals(""))) {
            String string4 = ClSyntax.stripQuotes(string2);
            int n3 = string4.length();
            String string5 = string4.toUpperCase(Locale.ENGLISH);
            if (!string5.equals(clCommonLayout.getDft()) && !ClSyntax.isSpecialValueSelected(string5, clCommonLayout)) {
                if (clCommonLayout.getType() == 12 && n3 != 0) {
                    n3 /= 2;
                }
                if (string5.length() > 3 && string5.charAt(0) == 'X' && string5.charAt(1) == '\'' && string5.charAt(string5.length() - 1) == '\'') {
                    n3 = string5.substring(2, string5.length() - 1).length() / 2;
                }
                if (n3 != clCommonLayout.getLen1()) {
                    clPanel.displayAS400Message(75, (Object)string3, (Object)("'" + string2 + "'"), (Object)new Integer(clCommonLayout.getLen1()));
                    jTextComponent.requestFocus();
                    return false;
                }
            }
        }
        if (!ClSyntax.checkCharacters(clPanel, string2, clCommonLayout.getType(), string3, clCommonLayout.getRstd(), clCommonLayout)) {
            jTextComponent.requestFocus();
            return false;
        }
        if (!ClSyntax.checkRelation(clPanel, string2, clCommonLayout, string3)) {
            jTextComponent.requestFocus();
            return false;
        }
        if (!ClSyntax.checkRange(clPanel, string2, clCommonLayout, string3)) {
            jTextComponent.requestFocus();
            return false;
        }
        return true;
    }

    static final boolean verifyComboBox(ClPanel clPanel, JComboBox jComboBox, ClCommonLayout clCommonLayout) {
        return ClSyntax.verifyComboBox(clPanel, jComboBox, clCommonLayout, 0, true);
    }

    static final boolean verifyComboBox(ClPanel clPanel, JComboBox jComboBox, ClCommonLayout clCommonLayout, int n, boolean bl) {
        String string;
        String string2;
        String string3;
        boolean bl2;
        String string4 = ClPanel.getComboText(jComboBox);
        int n2 = clCommonLayout.getType();
        boolean bl3 = false;
        if (n2 == 3 || n2 == 13 || n2 == 7) {
            string4 = ClSyntax.stripQuotes(string4);
            bl3 = true;
        }
        string4 = ClSyntax.getChoicePgmValue(string4, clCommonLayout.getChoicePgmValues());
        String string5 = "";
        ClCommonLayout clCommonLayout2 = clCommonLayout;
        while (!(clCommonLayout2 instanceof ClParm)) {
            clCommonLayout2 = (ClCommonLayout)clCommonLayout2.getParent();
        }
        string5 = ((ClParm)clCommonLayout2).getKwd();
        string4 = string4 == null ? "" : string4.trim();
        if (clCommonLayout.getAlwVar() && string4.length() > 1 && (string4.charAt(0) == '$' || string4.charAt(0) == '&' && clCommonLayout.getType() != 16)) {
            return true;
        }
        if (clCommonLayout.getRstd() && !string4.equals("")) {
            int n3 = jComboBox.getItemCount();
            bl2 = false;
            string3 = string4.toUpperCase(Locale.ENGLISH);
            Double d = null;
            if (n2 == 1 || n2 == 14 || n2 == 15) {
                try {
                    d = new Double(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string2 = null;
            Object var15_19 = null;
            for (int i = 0; i < n3; ++i) {
                var15_19 = jComboBox.getItemAt(i);
                if (!(var15_19 instanceof String)) continue;
                string2 = var15_19;
                if (string3.equals(string2 = string2.toUpperCase(Locale.ENGLISH)) || bl3 && string3.equals(ClSyntax.stripQuotes(string2).toUpperCase(Locale.ENGLISH))) {
                    bl2 = true;
                    break;
                }
                if (n2 == 12) {
                    if (string2.equals("X'" + string3 + "'")) {
                        bl2 = true;
                        break;
                    }
                    if (!string3.equals("X'" + string2 + "'")) continue;
                    bl2 = true;
                    break;
                }
                if (n2 != 1 && n2 != 14 && n2 != 15) continue;
                try {
                    Double d2;
                    if (d == null || (d2 = new Double(string2)).doubleValue() != d.doubleValue()) continue;
                    bl2 = true;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!bl2) {
                clPanel.displayAS400Message(84, (Object)string5, (Object)("'" + string4 + "'"));
                ClPanel.comboRequestFocus(jComboBox);
                return false;
            }
        }
        boolean bl4 = bl2 = !(string = string4).equals(string4 = clCommonLayout.getMapToValue(string4));
        if (bl2) {
            return true;
        }
        if (string4.equals("") && (clCommonLayout.getMin() == 0 || !bl)) {
            return true;
        }
        if (bl && clCommonLayout.getMin() >= 1) {
            int n4 = n;
            if (!string4.equals("")) {
                ++n4;
            }
            if (n4 < clCommonLayout.getMin()) {
                clPanel.displayAS400Message(71, (Object)string5);
                ClPanel.comboRequestFocus(jComboBox);
                return false;
            }
        }
        if (clCommonLayout.getType() == 2) {
            return true;
        }
        if (clCommonLayout.getFull() && (n == 0 || !string4.equals(""))) {
            string3 = ClSyntax.stripQuotes(string4);
            int n5 = string3.length();
            string2 = string3.toUpperCase(Locale.ENGLISH);
            if (!string2.equals(clCommonLayout.getDft()) && !ClSyntax.isSpecialValueSelected(string2, clCommonLayout)) {
                if (clCommonLayout.getType() == 12 && n5 != 0) {
                    n5 /= 2;
                }
                if (n5 != clCommonLayout.getLen1()) {
                    clPanel.displayAS400Message(75, (Object)string5, (Object)("'" + string4 + "'"), (Object)new Integer(clCommonLayout.getLen1()));
                    ClPanel.comboRequestFocus(jComboBox);
                    return false;
                }
            }
        }
        if (!ClSyntax.checkCharacters(clPanel, string4, clCommonLayout.getType(), string5, clCommonLayout.getRstd(), clCommonLayout)) {
            ClPanel.comboRequestFocus(jComboBox);
            return false;
        }
        if (!ClSyntax.checkRelation(clPanel, string4, clCommonLayout, string5)) {
            ClPanel.comboRequestFocus(jComboBox);
            return false;
        }
        if (!ClSyntax.checkRange(clPanel, string4, clCommonLayout, string5)) {
            ClPanel.comboRequestFocus(jComboBox);
            return false;
        }
        return true;
    }

    static final boolean verifyRadioButtons(ClPanel clPanel, ButtonGroup buttonGroup, ClCommonLayout clCommonLayout) {
        return ClSyntax.verifyRadioButtons(clPanel, buttonGroup, clCommonLayout, 0, true);
    }

    static final boolean verifyRadioButtons(ClPanel clPanel, ButtonGroup buttonGroup, ClCommonLayout clCommonLayout, int n, boolean bl) {
        ButtonModel buttonModel = buttonGroup.getSelection();
        if (bl && clCommonLayout.getMin() >= 1) {
            int n2 = n;
            if (buttonModel != null) {
                ++n2;
            }
            if (n2 < clCommonLayout.getMin()) {
                ClCommonLayout clCommonLayout2 = clCommonLayout;
                while (!(clCommonLayout2 instanceof ClParm)) {
                    clCommonLayout2 = (ClCommonLayout)clCommonLayout2.getParent();
                }
                String string = ((ClParm)clCommonLayout2).getKwd();
                clPanel.displayAS400Message(71, (Object)string);
                ((JRadioButton)buttonGroup.getElements().nextElement()).requestFocus();
                return false;
            }
        }
        return true;
    }

    static final boolean checkRelation(ClPanel clPanel, String string, ClCommonLayout clCommonLayout, String string2) {
        if (string != null && string.length() > 0 && string.charAt(0) == '*' && ClSyntax.isSpecialValueSelected(string, clCommonLayout)) {
            return true;
        }
        switch (clCommonLayout.getType()) {
            case 2: 
            case 9: 
            case 13: 
            case 17: {
                return true;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                try {
                    if (clCommonLayout.getRel() != 999 || clCommonLayout.getRel() != 0) {
                        if (clCommonLayout.getRelVal() != null && !clCommonLayout.getRelVal().equals("")) {
                            boolean bl = false;
                            switch (clCommonLayout.getType()) {
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: 
                                case 16: {
                                    string = string.toUpperCase(Locale.ENGLISH);
                                    bl = ClTypes.compareString(clCommonLayout.getRel(), string, clCommonLayout.getRelVal(), null);
                                    break;
                                }
                                case 1: 
                                case 14: 
                                case 15: 
                                case 21: 
                                case 22: {
                                    bl = ClTypes.compareLong(clCommonLayout.getRel(), string, clCommonLayout.getRelVal());
                                }
                            }
                            if (bl) {
                                return true;
                            }
                            switch (clCommonLayout.getRel()) {
                                case 204: {
                                    clPanel.displayAS400Message(87, (Object)string2, (Object)clCommonLayout.getRelVal(), (Object)("'" + string + "'"));
                                    break;
                                }
                                case 203: {
                                    clPanel.displayAS400Message(86, (Object)string2, (Object)clCommonLayout.getRelVal(), (Object)("'" + string + "'"));
                                    break;
                                }
                                case 205: 
                                case 210: {
                                    clPanel.displayAS400Message(88, (Object)string2, (Object)clCommonLayout.getRelVal(), (Object)("'" + string + "'"));
                                    break;
                                }
                                case 206: {
                                    clPanel.displayAS400Message(89, (Object)string2, (Object)clCommonLayout.getRelVal(), (Object)("'" + string + "'"));
                                    break;
                                }
                                case 207: {
                                    clPanel.displayAS400Message(90, (Object)string2, (Object)clCommonLayout.getRelVal(), (Object)("'" + string + "'"));
                                    break;
                                }
                                case 208: 
                                case 209: {
                                    clPanel.displayAS400Message(91, (Object)string2, (Object)clCommonLayout.getRelVal(), (Object)("'" + string + "'"));
                                }
                            }
                            return false;
                        }
                        if (clCommonLayout.getRelKwd() != null && !clCommonLayout.getRelKwd().equals("")) {
                            ClNode clNode = clCommonLayout;
                            while (!(clNode instanceof ClCmd)) {
                                clNode = clNode.getParent();
                            }
                            String string3 = ((ClCmd)clNode).getParmCompareValue(clCommonLayout.getRelKwd());
                            boolean bl = false;
                            switch (clCommonLayout.getType()) {
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    string = string.toUpperCase(Locale.ENGLISH);
                                    bl = ClTypes.compareString(clCommonLayout.getRel(), string, string3, null);
                                    break;
                                }
                                case 1: 
                                case 14: 
                                case 15: 
                                case 21: 
                                case 22: {
                                    bl = ClTypes.compareLong(clCommonLayout.getRel(), string, string3);
                                }
                            }
                            if (bl) {
                                return true;
                            }
                            switch (clCommonLayout.getRel()) {
                                case 204: {
                                    clPanel.displayAS400Message(142, (Object)string2, (Object)clCommonLayout.getRelKwd());
                                    break;
                                }
                                case 203: {
                                    clPanel.displayAS400Message(141, (Object)string2, (Object)clCommonLayout.getRelKwd());
                                    break;
                                }
                                case 205: 
                                case 210: {
                                    clPanel.displayAS400Message(143, (Object)string2, (Object)clCommonLayout.getRelKwd());
                                    break;
                                }
                                case 206: {
                                    clPanel.displayAS400Message(144, (Object)string2, (Object)clCommonLayout.getRelKwd());
                                    break;
                                }
                                case 207: {
                                    clPanel.displayAS400Message(145, (Object)string2, (Object)clCommonLayout.getRelKwd());
                                    break;
                                }
                                case 208: 
                                case 209: {
                                    clPanel.displayAS400Message(146, (Object)string2, (Object)clCommonLayout.getRelKwd());
                                }
                            }
                            return false;
                        }
                        return true;
                    }
                    break;
                }
                catch (Exception exception) {
                    return true;
                }
            }
        }
        return true;
    }

    static final boolean checkHexRange(ClPanel clPanel, String string, ClCommonLayout clCommonLayout, String string2) {
        String string3 = clCommonLayout.getRangeMinVal();
        String string4 = clCommonLayout.getRangeMaxVal();
        if (string3 == null || string4 == null) {
            return true;
        }
        if (string3.length() <= 3 || string4.length() <= 3) {
            return true;
        }
        if ((string = string.toUpperCase(Locale.ENGLISH)).length() > 3 && string.charAt(0) == 'X' && string.charAt(1) == '\'' && string.charAt(string.length() - 1) == '\'') {
            string = string.substring(2, string.length() - 1);
        }
        String string5 = string3.substring(2, string3.length() - 1);
        String string6 = string4.substring(2, string4.length() - 1);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            l = Long.valueOf(string5, 16);
            l2 = Long.valueOf(string6, 16);
            l3 = Long.valueOf(string, 16);
        }
        catch (Exception exception) {
            return true;
        }
        if (l3 > l2 || l3 < l) {
            clPanel.displayAS400Message(85, (Object)string2, (Object)string5, (Object)string, (Object)string6);
            return false;
        }
        return true;
    }

    static final boolean checkRange(ClPanel clPanel, String string, ClCommonLayout clCommonLayout, String string2) {
        if (string != null && string.length() > 0 && string.charAt(0) == '*' && ClSyntax.isSpecialValueSelected(string, clCommonLayout)) {
            return true;
        }
        switch (clCommonLayout.getType()) {
            case 2: 
            case 9: 
            case 13: 
            case 17: {
                break;
            }
            case 12: {
                return ClSyntax.checkHexRange(clPanel, string, clCommonLayout, string2);
            }
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                String string3 = clCommonLayout.getRangeMinVal();
                String string4 = clCommonLayout.getRangeMaxVal();
                if (string3 == null || string4 == null) {
                    return true;
                }
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                try {
                    l = Long.valueOf(string3, 10);
                    l2 = Long.valueOf(string4, 10);
                    l3 = Long.valueOf(string, 10);
                }
                catch (Exception exception) {
                    return true;
                }
                if (l3 > l2 || l3 < l) {
                    clPanel.displayAS400Message(85, (Object)string2, (Object)new Long(string3), (Object)new Long(l3), (Object)new Long(string4));
                    return false;
                }
                return true;
            }
            case 1: {
                String string5 = clCommonLayout.getRangeMinVal();
                String string6 = clCommonLayout.getRangeMaxVal();
                if (string5 == null || string6 == null) {
                    return true;
                }
                string5 = string5.replace(',', '.');
                string6 = string6.replace(',', '.');
                String string7 = string.replace(',', '.');
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                try {
                    d = Double.valueOf(string5).floatValue();
                    d2 = Double.valueOf(string6).floatValue();
                    d3 = Double.valueOf(string7).floatValue();
                }
                catch (Exception exception) {
                    return true;
                }
                if (d3 > d2 || d3 < d) {
                    clPanel.displayAS400Message(85, (Object)string2, (Object)new Double(string5), (Object)string, (Object)new Double(string6));
                    return false;
                }
                return true;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: {
                boolean bl;
                String string8 = clCommonLayout.getRangeMinVal();
                String string9 = clCommonLayout.getRangeMaxVal();
                if (string8 == null || string9 == null) {
                    return true;
                }
                string8 = string8.trim();
                string9 = string9.trim();
                if (string != null) {
                    string = string.trim();
                }
                string = string.toUpperCase(Locale.ENGLISH);
                String string10 = ClSyntax.convertHex(string8);
                String string11 = ClSyntax.convertHex(string9);
                String string12 = ClSyntax.convertHex(string);
                if (!(string10.equals(string8) || string10.length() != 1 || string11.equals(string9) || string11.length() != 1 || string12.equals(string) || string12.length() != 1)) {
                    return ClSyntax.checkHexRange(clPanel, string, clCommonLayout, string2);
                }
                boolean bl2 = ClTypes.ebcdicCompare(string, string8) >= 0;
                boolean bl3 = bl = ClTypes.ebcdicCompare(string, string9) <= 0;
                if (bl2 && bl) break;
                clPanel.displayAS400Message(85, (Object)string2, (Object)string8, (Object)string, (Object)string9);
                return false;
            }
        }
        return true;
    }

    static final boolean checkCharacters(ClPanel clPanel, String string, int n, String string2, boolean bl, ClCommonLayout clCommonLayout) {
        if (string == null || string.equals("")) {
            return true;
        }
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 13: {
                if (ClSyntax.checkQuotes(string, '\'')) break;
                clPanel.error(3, string2);
                return false;
            }
            case 4: 
            case 8: 
            case 16: {
                if (!ClSyntax.checkQuotes(string, '\"')) {
                    clPanel.error(3, string2);
                    return false;
                }
                if (ClSyntax.checkName(clPanel, string, NAME_CHAR, string2, clCommonLayout)) break;
                return false;
            }
            case 5: {
                if (ClSyntax.checkName(clPanel, string, SNAME_CHAR, string2, clCommonLayout)) break;
                return false;
            }
            case 6: {
                if (ClSyntax.checkName(clPanel, string, "0123456789", string2, clCommonLayout)) break;
                return false;
            }
            case 7: {
                int n2;
                if (!ClSyntax.checkQuotes(string, '\'')) {
                    clPanel.displayAS400Message(189, (Object)string2, (Object)string);
                    return false;
                }
                int n3 = string.length();
                if (n3 <= 1) break;
                if ((clCommonLayout.getDft() == null || clCommonLayout.getDft() != null && !clCommonLayout.getDft().equals(string)) && !ClSyntax.isSpecialValueSelected(string, clCommonLayout) && string.charAt(0) == '*' && string.charAt(1) != '*') {
                    clPanel.displayAS400Message(186, (Object)string2, (Object)string);
                    return false;
                }
                int n4 = 0;
                int n5 = 0;
                String string3 = ClSyntax.quote(7, string);
                int n6 = string3.length();
                for (n2 = 0; n2 < n6; ++n2) {
                    if (string3.charAt(n2) == '\'') {
                        if (n2 + 1 < n6 && string3.charAt(n2 + 1) == '\'') {
                            ++n2;
                        }
                        ++n4;
                        continue;
                    }
                    if (string3.charAt(n2) != '\"') continue;
                    ++n5;
                }
                if (n4 % 2 == 1 || n5 % 2 == 1) {
                    clPanel.displayAS400Message(189, (Object)string2, (Object)string);
                    return false;
                }
                n2 = string.indexOf(34);
                int n7 = string.indexOf(42);
                int n8 = string.indexOf(63);
                int n9 = string.lastIndexOf(92);
                int n10 = string.lastIndexOf(47);
                int n11 = string.indexOf(39, 1);
                if (n7 != -1 && (n7 < n9 || n7 < n10)) {
                    if (n2 != -1 && n2 < n7 || n11 != -1 && n11 < n7) break;
                    clPanel.displayAS400Message(188, (Object)string2, (Object)string);
                    return false;
                }
                if (n8 == -1 || n8 >= n9 && n8 >= n10 || n2 != -1 && n2 < n8 || n11 != -1 && n11 < n8) break;
                clPanel.displayAS400Message(188, (Object)string2, (Object)string);
                return false;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                if (!ClSyntax.checkQuotes(string, '\'')) {
                    clPanel.displayAS400Message(14);
                    return false;
                }
                return ClSyntax.checkDateTime(clPanel, string, string2, n, clCommonLayout);
            }
            case 12: {
                if (!ClSyntax.checkQuotes(string, '\'')) {
                    clPanel.displayAS400Message(14);
                    return false;
                }
                return ClSyntax.checkHex(clPanel, string, string2, clCommonLayout);
            }
            case 14: 
            case 15: 
            case 21: 
            case 22: {
                return ClSyntax.checkInt(clPanel, string, string2, n, bl, clCommonLayout);
            }
        }
        return true;
    }

    static final boolean checkQuotes(String string, char c) {
        char c2 = string.charAt(0);
        char c3 = string.charAt(string.length() - 1);
        if (c2 == c) {
            if (string.length() == 1) {
                return false;
            }
            if (c3 != c) {
                return false;
            }
        } else if (c3 == c) {
            return true;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static final boolean checkName(ClPanel clPanel, String string, String string2, String string3, ClCommonLayout clCommonLayout) {
        boolean bl;
        boolean bl2;
        String string4;
        block36: {
            char c;
            block35: {
                block34: {
                    c = string.charAt(0);
                    string4 = "";
                    bl2 = false;
                    bl = false;
                    if (clCommonLayout.getType() == 16) {
                        if (c == '&' && string.length() > 1) {
                            string = string.toUpperCase(Locale.ENGLISH);
                            c = string.charAt(1);
                            string4 = string.length() > 2 ? string.substring(2, string.length()) : "";
                            bl = true;
                            break block34;
                        } else {
                            clPanel.displayAS400Message(81, (Object)string3);
                            return false;
                        }
                    }
                    if (c == '\"') {
                        if (string2 == SNAME_CHAR) {
                            clPanel.displayAS400Message(133, (Object)string3, (Object)("'" + string + "'"));
                            return false;
                        }
                        if (string2 == "0123456789") {
                            clPanel.displayAS400Message(134, (Object)string3, (Object)("'" + string + "'"));
                            return false;
                        }
                        bl2 = true;
                        c = string.charAt(1);
                        if (string.length() > 2) {
                            string4 = string.substring(2, string.length() - 1);
                        }
                    } else {
                        string = string.toUpperCase(Locale.ENGLISH);
                        c = string.charAt(0);
                        if (string.length() > 1) {
                            string4 = string.substring(1, string.length());
                        }
                    }
                }
                if (bl2 || BASE_CHAR.indexOf(c) != -1) break block35;
                if (c != '*') {
                    if (string2 == SNAME_CHAR) {
                        clPanel.displayAS400Message(133, (Object)string3, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (string2 == "0123456789") {
                        clPanel.displayAS400Message(134, (Object)string3, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (string2 == NAME_CHAR) {
                        if (bl) {
                            clPanel.displayAS400Message(81, (Object)string3);
                            return false;
                        }
                        if (clCommonLayout.getType() == 8) {
                            clPanel.displayAS400Message(79, (Object)string3, (Object)("'" + string + "'"));
                            return false;
                        }
                        clPanel.displayAS400Message(18, (Object)("'" + string + "'"), (Object)("'" + string + "'"));
                        return false;
                    }
                    break block36;
                } else if (!ClSyntax.isSpecialValueSelected(string, clCommonLayout)) {
                    if (string2 == SNAME_CHAR) {
                        clPanel.displayAS400Message(133, (Object)string3, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (string2 == "0123456789") {
                        clPanel.displayAS400Message(134, (Object)string3, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (clCommonLayout.getType() == 8) {
                        clPanel.displayAS400Message(79, (Object)string3, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (string2 == NAME_CHAR) {
                        clPanel.displayAS400Message(78, (Object)string3, (Object)("'" + string + "'"));
                        return false;
                    }
                }
                break block36;
            }
            if (INVALID_QUOTED.indexOf(c) != -1) {
                char[] cArray = new char[]{c};
                String string5 = new String(cArray);
                clPanel.displayAS400Message(20, (Object)string.substring(0, 1), (Object)("'" + string5 + "'"));
                return false;
            }
        }
        int n = string4.length();
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string4.charAt(n2);
            if (BASE_CHAR.indexOf(c) == -1) {
                if (!bl2 && string2.indexOf(c) == -1) {
                    if (string2 == SNAME_CHAR) {
                        clPanel.displayAS400Message(133, (Object)string3, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (string2 == "0123456789") {
                        clPanel.displayAS400Message(134, (Object)string3, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (string2 == NAME_CHAR) {
                        if (bl) {
                            clPanel.displayAS400Message(81, (Object)string3);
                            return false;
                        }
                        if (clCommonLayout.getType() != 8) {
                            clPanel.displayAS400Message(18, (Object)("'" + string + "'"), (Object)("'" + string + "'"));
                            return false;
                        }
                        if (c != '*' || n2 + 1 != n) {
                            clPanel.displayAS400Message(79, (Object)string3, (Object)("'" + string + "'"));
                            return false;
                        }
                    }
                } else if (bl2 && INVALID_QUOTED.indexOf(c) != -1 && (c != '*' || n2 + 1 != n || clCommonLayout.getType() != 8)) {
                    char[] cArray = new char[]{c};
                    String string6 = new String(cArray);
                    clPanel.displayAS400Message(20, (Object)string.substring(0, n2 + 2), (Object)("'" + string6 + "'"));
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    static final boolean checkInt(ClPanel clPanel, String string, String string2, int n, boolean bl, ClCommonLayout clCommonLayout) {
        if (string.charAt(0) == '*') {
            if (!string.equals("*N") && !ClSyntax.isSpecialValueSelected(string, clCommonLayout)) {
                clPanel.displayAS400Message(76, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            return true;
        }
        int n2 = string.length();
        char c = '\u0000';
        for (int i = 0; i < n2; ++i) {
            c = string.charAt(i);
            if (INT_CHAR.indexOf(c) != -1) continue;
            if (bl) {
                clPanel.displayAS400Message(84, (Object)string2, (Object)("'" + string + "'"));
            } else {
                clPanel.displayAS400Message(76, (Object)string2, (Object)("'" + string + "'"));
            }
            return false;
        }
        long l = Long.parseLong(string);
        switch (n) {
            case 21: {
                if (l <= 65535L && l >= 0L) break;
                clPanel.displayAS400Message(95, (Object)string2, (Object)"*N", (Object)"", (Object)"*UINT2");
                return false;
            }
            case 22: {
                if (l <= 0xFFFFFFFFL && l >= 0L) break;
                clPanel.displayAS400Message(95, (Object)string2, (Object)"", (Object)"*N", (Object)"*UINT4");
                return false;
            }
            case 14: {
                if (l <= 32767L && l >= -32768L) break;
                clPanel.displayAS400Message(95, (Object)string2, (Object)"", (Object)"*N", (Object)"*INT2");
                return false;
            }
            case 15: {
                if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) break;
                clPanel.displayAS400Message(95, (Object)string2, (Object)"", (Object)"*N", (Object)"*INT4");
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final boolean checkDateTime(ClPanel clPanel, String string, String string2, int n, ClCommonLayout clCommonLayout) {
        if (string.charAt(0) == '*') {
            if (ClSyntax.isSpecialValueSelected(string, clCommonLayout)) return true;
            if (n == 10) {
                clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            if (n != 11) return true;
            clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
            return false;
        }
        if (!ClSyntax.getDateAndTimeFormats()) {
            return true;
        }
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if ("0123456789".indexOf(string.charAt(i)) != -1) continue;
            if (n == 10 && string.charAt(i) != ClPanel.m_dateSeparator.charAt(0)) {
                clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            if (n != 11 || string.charAt(i) == ClPanel.m_timeSeparator.charAt(0)) continue;
            clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
            return false;
        }
        if (n == 10) {
            if (ClPanel.m_dateFormat.equals("*YMD")) {
                if (n2 == 6 || n2 == 8 || n2 == 10) {
                    if (string.indexOf(ClPanel.m_dateSeparator.charAt(0)) != -1) {
                        if (n2 == 6) {
                            clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                            return false;
                        }
                        String string3 = string.substring(0, n2 - 6);
                        String string4 = string.substring(n2 - 5, n2 - 3);
                        String string5 = string.substring(n2 - 2, n2);
                        if (!(ClSyntax.hasOnlyNumeric(string4) && ClSyntax.hasOnlyNumeric(string5) && ClSyntax.hasOnlyNumeric(string3) && string.charAt(n2 - 3) == ClPanel.m_dateSeparator.charAt(0) && string.charAt(n2 - 6) == ClPanel.m_dateSeparator.charAt(0))) {
                            clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                            return false;
                        }
                        int n3 = new Integer(string4);
                        int n4 = new Integer(string5);
                        if (n3 <= 12 && n4 <= 31) return true;
                        clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (!ClSyntax.hasOnlyNumeric(string)) {
                        clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                        return false;
                    }
                    String string6 = string.substring(n2 - 4, n2 - 2);
                    String string7 = string.substring(n2 - 2, n2);
                    int n5 = new Integer(string6);
                    int n6 = new Integer(string7);
                    if (n5 <= 12 && n6 <= 31) return true;
                    clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                    return false;
                }
                clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            if (ClPanel.m_dateFormat.equals("*MDY")) {
                if (n2 == 6 || n2 == 8 || n2 == 10) {
                    if (string.indexOf(ClPanel.m_dateSeparator.charAt(0)) != -1) {
                        if (n2 == 6) {
                            clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                            return false;
                        }
                        String string8 = string.substring(0, 2);
                        String string9 = string.substring(3, 5);
                        String string10 = string.substring(6, n2);
                        if (!(ClSyntax.hasOnlyNumeric(string8) && ClSyntax.hasOnlyNumeric(string9) && ClSyntax.hasOnlyNumeric(string10) && string.charAt(2) == ClPanel.m_dateSeparator.charAt(0) && string.charAt(5) == ClPanel.m_dateSeparator.charAt(0))) {
                            clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                            return false;
                        }
                        int n7 = new Integer(string8);
                        int n8 = new Integer(string9);
                        if (n7 <= 12 && n8 <= 31) return true;
                        clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (!ClSyntax.hasOnlyNumeric(string)) {
                        clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                        return false;
                    }
                    String string11 = string.substring(0, 2);
                    String string12 = string.substring(2, 4);
                    int n9 = new Integer(string11);
                    int n10 = new Integer(string12);
                    if (n9 <= 12 && n10 <= 31) return true;
                    clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                    return false;
                }
                clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            if (ClPanel.m_dateFormat.equals("*DMY")) {
                if (n2 == 6 || n2 == 8 || n2 == 10) {
                    if (string.indexOf(ClPanel.m_dateSeparator.charAt(0)) != -1) {
                        if (n2 == 6) {
                            clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                            return false;
                        }
                        String string13 = string.substring(0, 2);
                        String string14 = string.substring(3, 5);
                        String string15 = string.substring(6, n2);
                        if (!(ClSyntax.hasOnlyNumeric(string14) && ClSyntax.hasOnlyNumeric(string13) && ClSyntax.hasOnlyNumeric(string15) && string.charAt(2) == ClPanel.m_dateSeparator.charAt(0) && string.charAt(5) == ClPanel.m_dateSeparator.charAt(0))) {
                            clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                            return false;
                        }
                        int n11 = new Integer(string14);
                        int n12 = new Integer(string13);
                        if (n11 <= 12 && n12 <= 31) return true;
                        clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                        return false;
                    }
                    if (!ClSyntax.hasOnlyNumeric(string)) {
                        clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                        return false;
                    }
                    String string16 = string.substring(0, 2);
                    String string17 = string.substring(2, 4);
                    int n13 = new Integer(string17);
                    int n14 = new Integer(string16);
                    if (n13 <= 12 && n14 <= 31) return true;
                    clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                    return false;
                }
                clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            if (!ClPanel.m_dateFormat.equals("*JUL")) return true;
            if (n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8) {
                if (string.indexOf(ClPanel.m_dateSeparator.charAt(0)) != -1) {
                    if (n2 == 5 || n2 == 7) {
                        clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                        return false;
                    }
                    String string18 = string.substring(0, 3);
                    String string19 = string.substring(5, n2);
                    if (!ClSyntax.hasOnlyNumeric(string18) || !ClSyntax.hasOnlyNumeric(string19) || string.charAt(3) != ClPanel.m_dateSeparator.charAt(0)) {
                        clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                        return false;
                    }
                    int n15 = new Integer(string18);
                    if (n15 <= 366) return true;
                    clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                    return false;
                }
                if (!ClSyntax.hasOnlyNumeric(string)) {
                    clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                    return false;
                }
                String string20 = string.substring(0, 3);
                int n16 = new Integer(string20);
                if (n16 <= 366) return true;
                clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            clPanel.displayAS400Message(82, (Object)string2, (Object)("'" + string + "'"));
            return false;
        }
        if (n != 11) return true;
        if (n2 != 4 && n2 != 5 && n2 != 6 && n2 != 8) {
            clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
            return false;
        }
        if (string.indexOf(ClPanel.m_timeSeparator.charAt(0)) != -1) {
            if (n2 != 5 && n2 != 8) {
                clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            if (n2 == 5) {
                String string21 = string.substring(0, 2);
                String string22 = string.substring(3, 5);
                if (ClPanel.m_timeSeparator.charAt(0) != string.charAt(2) || !ClSyntax.hasOnlyNumeric(string21) || !ClSyntax.hasOnlyNumeric(string22)) {
                    clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
                    return false;
                }
                int n17 = new Integer(string21);
                int n18 = new Integer(string22);
                if (n17 <= 23 && n18 <= 59) return true;
                clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            if (n2 != 8) return true;
            String string23 = string.substring(0, 2);
            String string24 = string.substring(3, 5);
            String string25 = string.substring(6, 8);
            if (ClPanel.m_timeSeparator.charAt(0) != string.charAt(2) || ClPanel.m_timeSeparator.charAt(0) != string.charAt(5) || !ClSyntax.hasOnlyNumeric(string23) || !ClSyntax.hasOnlyNumeric(string24)) {
                clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
                return false;
            }
            int n19 = new Integer(string23);
            int n20 = new Integer(string24);
            int n21 = new Integer(string25);
            if (n19 <= 23 && n20 <= 59 && n21 <= 59) return true;
            clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
            return false;
        }
        if (!ClSyntax.hasOnlyNumeric(string)) {
            clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
            return false;
        }
        String string26 = string.substring(0, 2);
        String string27 = string.substring(2, 4);
        String string28 = "0";
        if (n2 != 4) {
            string28 = string.substring(4, 6);
        }
        int n22 = new Integer(string26);
        int n23 = new Integer(string27);
        int n24 = new Integer(string28);
        if (n22 <= 23 && n23 <= 59 && n24 <= 59) return true;
        clPanel.displayAS400Message(83, (Object)string2, (Object)("'" + string + "'"));
        return false;
    }

    static final boolean checkHex(ClPanel clPanel, String string, String string2, ClCommonLayout clCommonLayout) {
        if ((string = string.toUpperCase(Locale.ENGLISH)).charAt(0) == '*') {
            if (!ClSyntax.isSpecialValueSelected(string, clCommonLayout)) {
                clPanel.displayAS400Message(97, (Object)string2);
                return false;
            }
            return true;
        }
        boolean bl = false;
        if (string.length() >= 3 && (string = string.toUpperCase(Locale.ENGLISH)).charAt(0) == 'X' && string.charAt(1) == '\'' && string.charAt(string.length() - 1) == '\'') {
            string = string.substring(2, string.length() - 1);
            bl = true;
        }
        if (string.length() % 2 == 1 && bl) {
            clPanel.displayAS400Message(97, (Object)string2);
            return false;
        }
        int n = string.length();
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (HEX_CHAR.indexOf(c) != -1) continue;
            clPanel.displayAS400Message(97, (Object)string2);
            return false;
        }
        return true;
    }

    static final boolean hasOnlyNumeric(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if ("0123456789".indexOf(string.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    static final String stripQuotes(String string) {
        return ClSyntax.stripQuotes(string, true);
    }

    static final String stripQuotes(String string, boolean bl) {
        if (string != null) {
            int n = string.length();
            if (string.length() > 1 && (string.charAt(0) == '\"' && string.charAt(n - 1) == '\"' && bl ? (string = string.substring(1, n - 1)).equals("") : string.charAt(0) == '\'' && string.charAt(n - 1) == '\'' && (string = string.substring(1, n - 1)).equals(""))) {
                return "";
            }
        }
        return string;
    }

    static final boolean getDateAndTimeFormats() {
        if (ClPanel.m_dateFormat == null) {
            try {
                Job job = new Job(ClPanel.m_system, "*", "", "");
                ClPanel.m_dateFormat = job.getDateFormat();
                ClPanel.m_dateSeparator = job.getDateSeparator();
                ClPanel.m_timeSeparator = job.getTimeSeparator();
            }
            catch (Exception exception) {
                MessageLog.logError((Object)"CP: Date format not retrieved due to error");
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

