/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.access.AS400;
import com.ibm.as400.ui.framework.java.DataBean;
import com.ibm.as400.ui.framework.java.DisplayManagerException;
import com.ibm.as400.ui.framework.java.DynamicPanelManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.framework.java.PanelManager;
import com.ibm.as400.ui.util.ClChangeExitException;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClContextMenuManager;
import com.ibm.as400.ui.util.ClCopyKeyListener;
import com.ibm.as400.ui.util.ClDocument;
import com.ibm.as400.ui.util.ClFieldMouseHandler;
import com.ibm.as400.ui.util.ClHelpId;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClParseException;
import com.ibm.as400.ui.util.ClSelectCommandBean;
import com.ibm.as400.ui.util.ClSpecificationException;
import com.ibm.as400.ui.util.ClStringBean;
import com.ibm.as400.ui.util.ClSyntax;
import com.ibm.as400.ui.util.ParseException;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;

class ClLayoutPanel
extends ClPanel
implements KeyListener {
    private String m_commandLine;
    private ClDocument m_doc;
    private JDialog m_dialog;
    private boolean m_advanced;
    private boolean m_bShowParmNames;
    private String m_library;

    public void cleanup() {
        this.m_dialog = null;
        this.m_doc = null;
        this.m_library = null;
    }

    ClLayoutPanel(AS400 aS400, String string) {
        this.m_commandLine = string;
        m_system = aS400;
        this.m_advanced = false;
        this.m_bShowParmNames = false;
        this.m_library = null;
        this.setLayout(new GridBagLayout());
    }

    ClLayoutPanel() {
    }

    boolean loadDocument() throws ClCommandException {
        Object object;
        int n;
        int n2 = this.m_commandLine.indexOf(" ");
        int n3 = this.m_commandLine.indexOf("/");
        boolean bl = false;
        if (n2 != -1 && n3 != -1 && n3 < n2) {
            bl = true;
        } else if (n2 == -1 && n3 != -1) {
            bl = true;
        }
        if (bl) {
            this.m_library = this.m_commandLine.substring(0, n3);
            this.m_commandLine = this.m_commandLine.substring(n3 + 1, this.m_commandLine.length());
        }
        if (this.m_commandLine.endsWith("*") && (n = this.m_commandLine.indexOf(32)) == -1) {
            object = new ClSelectCommandBean(this.m_commandLine);
            DataBean[] dataBeanArray = new DataBean[]{object};
            ((ClSelectCommandBean)object).load();
            Container container = this;
            if (container != null) {
                while (!(container instanceof Frame)) {
                    container = container.getParent();
                }
            }
            DynamicPanelManager dynamicPanelManager = null;
            try {
                dynamicPanelManager = new DynamicPanelManager("com.ibm.as400.ui.util.ClMRI", "SELECT_COMMAND_PANEL", dataBeanArray, (Frame)container);
            }
            catch (DisplayManagerException displayManagerException) {
                displayManagerException.displayUserMessage(null);
                return false;
            }
            dynamicPanelManager.setVisible(true);
            this.m_commandLine = ((ClSelectCommandBean)object).getCommandNameSelection()[0];
            this.m_library = ((ClSelectCommandBean)object).getCommandLibSelection()[0];
            object = null;
        }
        if (this.m_commandLine == null) {
            return false;
        }
        try {
            this.m_commandLine = this.m_commandLine.trim();
            if (this.m_commandLine.equals("")) {
                return false;
            }
            n = this.m_commandLine.indexOf(" ");
            object = this.m_commandLine;
            if (n != -1) {
                object = this.m_commandLine.substring(0, n);
            }
            if (((String)object).length() > 10) {
                this.displayAS400Message(33, (Object)((String)object).toUpperCase(Locale.ENGLISH));
                return false;
            }
            if (!ClSyntax.verifyCommandName(this, (String)object)) {
                return false;
            }
            try {
                this.m_doc = new ClDocument((String)object, this.m_library, m_system, this, this.m_commandLine, true);
            }
            catch (ClChangeExitException clChangeExitException) {
                this.m_commandLine = clChangeExitException.getCommand();
                this.m_commandLine = this.m_commandLine.trim();
                n = this.m_commandLine.indexOf(" ");
                object = this.m_commandLine;
                if (n != -1) {
                    object = this.m_commandLine.substring(0, n);
                }
                try {
                    this.m_doc = new ClDocument((String)object, this.m_library, m_system, this, this.m_commandLine, false);
                }
                catch (ClChangeExitException clChangeExitException2) {}
            }
        }
        catch (ParseException parseException) {
            MessageLog.logError((Object)"CP: ClLayoutPanel: parse exception");
            return false;
        }
        catch (ClSpecificationException clSpecificationException) {
            MessageLog.logError((Object)"CP: ClLayoutPanel: specification exception");
            clSpecificationException.reportErrors();
            return false;
        }
        catch (IOException iOException) {
            MessageLog.logError((Object)"CP: ClLayoutPanel: io exception: ");
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    boolean layoutPanel(JDialog jDialog) throws ClParseException, ClCommandException {
        this.m_dialog = jDialog;
        this.m_doc.layoutPanel(this, this.m_commandLine);
        return true;
    }

    boolean hasAdvanced() {
        return this.m_doc.hasAdvanced();
    }

    void showAdvanced(boolean bl) {
        this.m_doc.showAdvanced(this, bl);
        ((JViewport)this.getParent().getParent()).revalidate();
        ((JViewport)this.getParent().getParent()).repaint();
    }

    void showAll(boolean bl) {
        this.m_doc.showAll(this, bl);
        ((JViewport)this.getParent().getParent()).revalidate();
        ((JViewport)this.getParent().getParent()).repaint();
    }

    boolean processPromptOverride() throws ClCommandException {
        return this.m_doc.processPromptOverride();
    }

    void assignFocus() {
        this.m_doc.assignFocus();
    }

    String getCLString() {
        if (this.m_library != null) {
            return this.m_library.toUpperCase(Locale.ENGLISH) + "/" + this.m_doc.getCLString();
        }
        return this.m_doc.getCLString();
    }

    JDialog getDialog() {
        return this.m_dialog;
    }

    String getCommandLine() {
        return this.m_commandLine;
    }

    void setCommandLine(String string) {
        this.m_commandLine = string;
    }

    boolean verify() {
        return this.m_doc.verify();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 113: {
                if (!keyEvent.isShiftDown()) break;
                this.showCommandString();
                keyEvent.consume();
                break;
            }
            case 116: {
                this.refresh();
                keyEvent.consume();
                break;
            }
            case 119: {
                if (this.m_doc == null) {
                    return;
                }
                if (this.verify()) {
                    MessageLog.logError((Object)"CP: All parms were verified.");
                }
                keyEvent.consume();
                break;
            }
            case 122: {
                this.toggleKeywords();
                keyEvent.consume();
                break;
            }
            case 34: {
                JScrollBar jScrollBar = ((JScrollPane)this.getParent().getParent().getParent()).getVerticalScrollBar();
                int n = jScrollBar.getValue();
                if ((n += jScrollBar.getBlockIncrement(1)) > jScrollBar.getMaximum()) {
                    n = jScrollBar.getMaximum();
                }
                jScrollBar.setValue(n);
                keyEvent.consume();
                break;
            }
            case 33: {
                JScrollBar jScrollBar = ((JScrollPane)this.getParent().getParent().getParent()).getVerticalScrollBar();
                int n = jScrollBar.getValue();
                if ((n -= jScrollBar.getBlockIncrement(1)) < jScrollBar.getMinimum()) {
                    n = jScrollBar.getMinimum();
                }
                jScrollBar.setValue(n);
                keyEvent.consume();
                break;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    void showCommandString() {
        if (this.m_doc == null) {
            return;
        }
        ClStringBean clStringBean = new ClStringBean(this.m_doc.getCLString(true));
        DataBean[] dataBeanArray = new DataBean[]{clStringBean};
        PanelManager panelManager = ClPanel.loadPanel("PANEL_COMMANDPREVIEW", dataBeanArray, this);
        JTextComponent jTextComponent = (JTextComponent)panelManager.getComponent("CP_TEXT_COMMANDPREVIEW");
        jTextComponent.setEditable(false);
        jTextComponent.requestFocus();
        ClContextMenuManager clContextMenuManager = null;
        try {
            clContextMenuManager = new ClContextMenuManager("com.ibm.as400.ui.util.ClMRI", null, "COPY_MENU", null);
        }
        catch (DisplayManagerException displayManagerException) {
            displayManagerException.displayUserMessage(null);
        }
        ClCopyKeyListener clCopyKeyListener = new ClCopyKeyListener();
        ClFieldMouseHandler clFieldMouseHandler = new ClFieldMouseHandler(jTextComponent, clContextMenuManager);
        jTextComponent.addMouseListener(clFieldMouseHandler);
        jTextComponent.addKeyListener(clCopyKeyListener);
        panelManager.setVisible(true);
        ClLayoutPanel.repaintDialog(this);
        clStringBean = null;
        jTextComponent.removeMouseListener(clFieldMouseHandler);
        jTextComponent.removeKeyListener(clCopyKeyListener);
        clFieldMouseHandler = null;
        clCopyKeyListener = null;
    }

    void refresh() {
        if (this.m_doc == null) {
            return;
        }
        this.m_doc.refresh();
    }

    String getPrdLib() {
        if (this.m_doc == null) {
            return null;
        }
        return this.m_doc.getPrdLib();
    }

    String getCmd() {
        return this.m_doc.getDocName();
    }

    String getCmdLib() {
        if (this.m_doc == null) {
            return null;
        }
        return this.m_doc.getCmdLib();
    }

    String getCommandDescription() {
        if (this.m_doc == null) {
            return null;
        }
        return this.m_doc.getCommandDescription();
    }

    void toggleKeywords() {
        if (this.m_doc == null) {
            return;
        }
        this.m_bShowParmNames = !this.m_bShowParmNames;
        this.m_doc.showParmNames(this.m_bShowParmNames);
        ((JViewport)this.getParent().getParent()).revalidate();
        ((JViewport)this.getParent().getParent()).repaint();
    }

    ClHelpId[] getHelpIds() {
        if (this.m_doc == null) {
            return null;
        }
        return this.m_doc.getHelpIds();
    }

    boolean isBatchCommand() {
        return this.m_doc.isBatchCommand();
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

