/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClAttributeList;
import com.ibm.as400.ui.util.ClCmd;
import com.ibm.as400.ui.util.ClDocNode;
import com.ibm.as400.ui.util.ClSyntax;
import com.ibm.as400.ui.util.ClTypes;

class ClDepParm
extends ClDocNode {
    private String m_Kwd;
    private int m_Rel;
    private String m_CmpKwd;
    private String m_CmpVal;

    ClDepParm() {
    }

    ClDepParm(ClAttributeList clAttributeList) {
        super(clAttributeList);
        this.setNodeType(14);
        this.setKwd(this.getAttributeValue("Kwd"));
        this.setRel(this.getAttributeValue("Rel"));
        this.setCmpKwd(this.getAttributeValue("CmpKwd"));
        this.setCmpVal(this.getAttributeValue("CmpVal"));
        this.setName("depparm." + this.m_Kwd);
    }

    void setKwd(String string) {
        this.m_Kwd = string == null || string.equals("") ? null : string;
    }

    String getKwd() {
        return this.m_Kwd;
    }

    void setRel(String string) {
        this.m_Rel = ClTypes.getType(string);
    }

    int getRel() {
        return this.m_Rel;
    }

    void setCmpKwd(String string) {
        this.m_CmpKwd = string == null || string.equals("") ? null : string;
    }

    String getCmpKwd() {
        return this.m_CmpKwd;
    }

    void setCmpVal(String string) {
        if (string == null || string.equals("")) {
            this.m_CmpVal = null;
        } else {
            this.m_CmpVal = string;
            String string2 = ClSyntax.convertHex(this.m_CmpVal.trim());
            if (!string2.trim().equals("")) {
                this.m_CmpVal = string2;
            }
        }
    }

    String getCmpVal() {
        return this.m_CmpVal;
    }

    boolean verify() {
        if (this.getKwd() == null) {
            MessageLog.logError((Object)"CP: DepParm: keyword is null, cannot continue verification");
            return true;
        }
        String string = ((ClCmd)this.getParent().getParent()).getParmCompareValue(this.getKwd());
        int n = ((ClCmd)this.getParent().getParent()).getParmType(this.getKwd());
        String string2 = ((ClCmd)this.getParent().getParent()).getParmDft(this.getKwd());
        if (string != null && string.equals("*N") && string2 == null) {
            string = "";
        }
        if (this.getCmpVal() != null) {
            if (!ClTypes.compare(n, this.getRel(), string, this.getCmpVal(), string2)) {
                MessageLog.logError((Object)("CP: specified value: '" + string + "' does not equal '" + this.getCmpVal() + "' for kwd " + this.getKwd()));
                return false;
            }
        } else if (this.getCmpKwd() != null) {
            String string3 = ((ClCmd)this.getParent().getParent()).getParmCompareValue(this.getCmpKwd());
            if (!ClTypes.compare(n, this.getRel(), string, string3, string2)) {
                return false;
            }
        } else if (!ClTypes.compare(n, this.getRel(), string, null, string2)) {
            return false;
        }
        return true;
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

