/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.ui.util;

import com.ibm.as400.ui.framework.java.MenuManager;
import com.ibm.as400.ui.framework.java.MessageLog;
import com.ibm.as400.ui.util.ClAttributeList;
import com.ibm.as400.ui.util.ClCommandException;
import com.ibm.as400.ui.util.ClCommandLineDialog;
import com.ibm.as400.ui.util.ClDep;
import com.ibm.as400.ui.util.ClDocNode;
import com.ibm.as400.ui.util.ClHelpId;
import com.ibm.as400.ui.util.ClLayoutPanel;
import com.ibm.as400.ui.util.ClNode;
import com.ibm.as400.ui.util.ClPanel;
import com.ibm.as400.ui.util.ClParm;
import com.ibm.as400.ui.util.ClParseException;
import com.ibm.as400.ui.util.ClPmtCtl;
import com.ibm.as400.ui.util.ClPromptOverride;
import com.ibm.as400.ui.util.ClSyntax;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;

class ClCmd
extends ClDocNode {
    private String m_CmdName;
    private String m_CmdLib;
    private String m_Ccsid;
    private String m_Prompt;
    private String m_HlpPnlGrp;
    private String m_HlpPnlGrpLib;
    private String m_HlpId;
    private String m_CurLib;
    private String m_PrdLib;
    private String m_PmtOvrPgm;
    private String m_PmtOvrLib;
    private String m_MsgF;
    private String m_MsgFLib;
    private boolean m_ExecBatch;
    private int m_MaxPos;
    private boolean m_ChgCmdExit;
    private String m_BackupPmtOvrPgm = null;
    private JLabel m_addParmLabel;
    private Hashtable m_commandHash;
    private Hashtable m_parmHash;
    private ClLayoutPanel m_panel;
    private boolean m_layoutAdvanced = true;

    ClCmd() {
    }

    ClCmd(ClAttributeList clAttributeList) {
        super(clAttributeList);
        this.m_addParmLabel = null;
        this.m_commandHash = new Hashtable(30);
        this.m_parmHash = new Hashtable(50);
        this.setCmdName(this.getAttributeValue("CmdName"));
        this.setCmdLib(this.getAttributeValue("CmdLib"));
        this.setCcsid(this.getAttributeValue("CCSID"));
        this.setPrompt(this.getAttributeValue("Prompt"));
        this.setHlpPnlGrp(this.getAttributeValue("HlpPnlGrp"));
        this.setHlpPnlGrpLib(this.getAttributeValue("HlpPnlGrpLib"));
        this.setHlpId(this.getAttributeValue("HlpID"));
        this.setCurLib(this.getAttributeValue("CurLib"));
        this.setPrdLib(this.getAttributeValue("PrdLib"));
        this.setPmtOvrPgm(this.getAttributeValue("PmtOvrPgm"));
        this.setPmtOvrLib(this.getAttributeValue("PmtOvrLib"));
        this.setMsgF(this.getAttributeValue("MsgF"));
        this.setMsgFLib(this.getAttributeValue("MsgFLib"));
        this.setExecBatch(this.getAttributeValue("ExecBatch"));
        this.setMaxPos(this.getAttributeValue("MaxPos"));
        this.setChgCmdExit(this.getAttributeValue("ChgCmdExit"));
        this.setName("cmd");
    }

    void setCmdName(String string) {
        this.m_CmdName = string == null || string.equals("") ? null : string;
    }

    String getCmdName() {
        return this.m_CmdName;
    }

    void setCmdLib(String string) {
        this.m_CmdLib = string == null || string.equals("") ? null : string;
    }

    String getCmdLib() {
        return this.m_CmdLib;
    }

    void setCcsid(String string) {
        if (string == null || string.equals("")) {
            this.m_Ccsid = null;
        } else {
            this.m_Ccsid = string;
            ClPanel.m_commandCCSID = new Integer(string);
        }
    }

    String getCcsid() {
        return this.m_Ccsid;
    }

    void setPrompt(String string) {
        this.m_Prompt = string != null ? string : "";
    }

    String getPrompt() {
        return this.m_Prompt;
    }

    void setHlpPnlGrp(String string) {
        this.m_HlpPnlGrp = string == null || string.equals("") ? null : string;
    }

    String getHlpPnlGrp() {
        return this.m_HlpPnlGrp;
    }

    void setHlpPnlGrpLib(String string) {
        this.m_HlpPnlGrpLib = string == null || string.equals("") ? null : (string.equals("__LIBL") ? "*LIBL" : string);
    }

    String getHlpPnlGrpLib() {
        return this.m_HlpPnlGrpLib;
    }

    void setHlpId(String string) {
        this.m_HlpId = string == null || string.equals("") ? null : string;
    }

    String getHlpId() {
        return this.m_HlpId;
    }

    void setCurLib(String string) {
        this.m_CurLib = string == null || string.equals("") ? null : string;
    }

    String getCurLib() {
        return this.m_CurLib;
    }

    void setPrdLib(String string) {
        this.m_PrdLib = string == null || string.equals("") ? null : string;
    }

    String getPrdLib() {
        return this.m_PrdLib;
    }

    void setPmtOvrPgm(String string) {
        this.m_PmtOvrPgm = string == null || string.equals("") || !ClPanel.m_bAllowPrograms ? null : string;
    }

    String getPmtOvrPgm() {
        return this.m_PmtOvrPgm;
    }

    void setPmtOvrLib(String string) {
        this.m_PmtOvrLib = string == null || string.equals("") ? null : string;
    }

    String getPmtOvrLib() {
        return this.m_PmtOvrLib;
    }

    void setMsgF(String string) {
        this.m_MsgF = string == null || string.equals("") ? null : string;
    }

    String getMsgF() {
        return this.m_MsgF;
    }

    void setMsgFLib(String string) {
        this.m_MsgFLib = string == null || string.equals("") ? null : string;
    }

    String getMsgFLib() {
        return this.m_MsgFLib;
    }

    void setExecBatch(String string) {
        this.m_ExecBatch = this.getBoolean(string);
    }

    void setExecBatch(boolean bl) {
        this.m_ExecBatch = bl;
    }

    boolean getExecBatch() {
        return this.m_ExecBatch;
    }

    void setMaxPos(String string) {
        this.m_MaxPos = string != null && !string.equals("") ? new Integer(string) : 0;
    }

    int getMaxPos() {
        return this.m_MaxPos;
    }

    void setChgCmdExit(String string) {
        this.m_ChgCmdExit = !ClPanel.m_bAllowPrograms ? false : this.getBoolean(string);
    }

    void setChgCmdExit(boolean bl) {
        this.m_ChgCmdExit = !ClPanel.m_bAllowPrograms ? false : bl;
    }

    boolean getChgCmdExit() {
        return this.m_ChgCmdExit;
    }

    ClPanel getPanel() {
        return this.m_panel;
    }

    void layoutPanel(ClLayoutPanel clLayoutPanel, String string) throws ClParseException, ClCommandException {
        ClNode clNode;
        String string2 = this.getPrompt() + " (" + this.getCmdName().toUpperCase(Locale.ENGLISH) + ")";
        clLayoutPanel.getDialog().setTitle(string2);
        clLayoutPanel.setCmdTitle(string2);
        this.m_panel = clLayoutPanel;
        if (!this.getExecBatch() && !ClPanel.m_bPromptInteractive) {
            clLayoutPanel.error(10, this.getCmdName());
            throw new ClCommandException(1);
        }
        Enumeration enumeration = this.getChildren();
        String string3 = null;
        this.m_parmHash.clear();
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm)) continue;
            this.m_parmHash.put(((ClParm)clNode).getKwd(), clNode);
        }
        if (this.m_parmHash.size() == 0) {
            clLayoutPanel.error(4, this.getCmdName());
            throw new ClCommandException();
        }
        this.parseCommandLine(string);
        this.reorderChildren();
        enumeration = this.getChildren();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm)) continue;
            ClParm clParm = (ClParm)clNode;
            string3 = (String)this.m_commandHash.get(clParm.getKwd());
            clParm.layoutPanel((ClPanel)clLayoutPanel, null, string3);
            if (string3 != null && clParm.getPmtCtl() != null && clParm.getPmtCtl().equals("PMTRQS")) {
                bl = true;
                MessageLog.logError((Object)"CP: Laying out advanced early...");
            }
            if (this.m_PmtOvrPgm == null) continue;
            if (clParm.getKeyParm()) {
                clParm.setVisible(true);
                continue;
            }
            clParm.setVisible(false);
        }
        int n = 0;
        int n2 = 0;
        enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm) || (n2 = ((ClParm)clNode).getLongestLabelWidth()) <= n) continue;
            n = n2;
        }
        JLabel jLabel = new JLabel("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        jLabel.setFont(ClPanel.m_scaledFont);
        Dimension dimension = jLabel.getPreferredSize();
        if (dimension.width > n) {
            n = dimension.width;
        }
        dimension.width = n;
        jLabel.setText(" ");
        jLabel.setPreferredSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        clLayoutPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        clLayoutPanel.add((Component)new JLabel(" "), gridBagConstraints);
        enumeration = this.getChildren();
        if (enumeration.hasMoreElements()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.insets = new Insets(14, 7, 14, 7);
            this.m_addParmLabel = new JLabel(ClPanel.loadString("IDS_ADDITIONAL_PARAMETERS"));
            this.m_addParmLabel.setFont(ClPanel.m_scaledFont);
            clLayoutPanel.add((Component)this.m_addParmLabel, gridBagConstraints);
            if (bl) {
                this.m_addParmLabel.setVisible(true);
            } else {
                this.m_addParmLabel.setVisible(false);
            }
        }
        if (bl) {
            while (enumeration.hasMoreElements()) {
                clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClParm)) continue;
                ((ClParm)clNode).layoutPanel((ClPanel)clLayoutPanel, "PMTRQS");
            }
            this.m_layoutAdvanced = false;
        }
        this.processPromptOverride(false, false);
    }

    void assignFocus() {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            ClNode clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm) || !((ClParm)clNode).assignFocus()) continue;
            return;
        }
    }

    void showParmNames(boolean bl) {
        Enumeration enumeration = this.getChildren();
        ClNode clNode = null;
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm)) continue;
            ((ClParm)clNode).setNamesVisible(bl);
        }
    }

    boolean hasAdvanced() {
        Enumeration enumeration = this.getChildren();
        ClNode clNode = null;
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm) || !((ClParm)clNode).displayPanel("PMTRQS", false)) continue;
            return true;
        }
        return false;
    }

    void showAdvanced(ClPanel clPanel, boolean bl) {
        boolean bl2 = false;
        Enumeration enumeration = this.getChildren();
        if (this.m_addParmLabel != null) {
            this.showAdvancedLabel(bl);
        }
        while (enumeration.hasMoreElements()) {
            ClNode clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm)) continue;
            ClParm clParm = (ClParm)clNode;
            if (this.m_layoutAdvanced) {
                try {
                    clParm.layoutPanel(clPanel, "PMTRQS");
                }
                catch (ClParseException clParseException) {
                    MessageLog.logError((Object)"CP: Parse exception in show advanced!!");
                }
            }
            if (clParm.getPmtCtl() == null && clPanel.getTopLevelAncestor().isVisible()) {
                clParm.displayPanel(null, true);
            }
            if (!clParm.displayPanel("PMTRQS", bl)) continue;
            bl2 = true;
        }
        this.m_layoutAdvanced = false;
        if (this.m_addParmLabel != null && !bl2) {
            this.showAdvancedLabel(false);
        }
    }

    void showAdvancedLabel(boolean bl) {
        this.m_addParmLabel.setVisible(bl);
    }

    void showAll(ClPanel clPanel, boolean bl) {
        ClNode clNode;
        boolean bl2 = false;
        Enumeration enumeration = this.getChildren();
        if (this.m_addParmLabel != null) {
            this.showAdvancedLabel(bl);
        }
        if (this.m_layoutAdvanced) {
            this.showAdvanced(clPanel, bl);
        }
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm) || !((ClParm)clNode).showAll(bl)) continue;
            bl2 = true;
        }
        if (this.m_addParmLabel != null && !bl2) {
            this.showAdvancedLabel(false);
        }
        if (!bl) {
            enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClParm)) continue;
                ((ClParm)clNode).promptOtherParms();
            }
            this.showAdvanced(clPanel, true);
            this.showAdvanced(clPanel, false);
        }
    }

    boolean processPromptOverride() throws ClCommandException {
        return this.processPromptOverride(true);
    }

    boolean processPromptOverride(boolean bl) throws ClCommandException {
        return this.processPromptOverride(bl, true);
    }

    boolean processPromptOverride(boolean bl, boolean bl2) throws ClCommandException {
        if (this.m_PmtOvrPgm != null) {
            Object object;
            Object object2;
            if (!bl2) {
                object2 = this.getChildren();
                String string = null;
                while (object2.hasMoreElements()) {
                    object = (ClNode)object2.nextElement();
                    if (!(object instanceof ClParm)) continue;
                    ClParm clParm = (ClParm)object;
                    string = ((ClParm)object).getCLString(bl);
                    if (!string.equals("") || !clParm.getKeyParm() || clParm.getRstd()) continue;
                    MessageLog.logError((Object)("CP: Key parameter value needed for " + clParm.getKwd()));
                    return true;
                }
            }
            ClPanel.setCursor(this.m_panel, true);
            object = new ClPromptOverride(this.m_panel.getCLString(), this.m_panel, this.getPrdLib());
            MessageLog.logError((Object)"CP: Created prompt override and calling");
            ((ClPromptOverride)object).callProgram();
            ClPanel.setCursor(this.m_panel, false);
            object2 = null;
            object2 = ((ClPromptOverride)object).getCommand();
            if (object2 != null) {
                object2 = ((String)object2).trim();
            }
            this.m_BackupPmtOvrPgm = this.m_PmtOvrPgm;
            this.m_PmtOvrPgm = null;
            try {
                if (object2 != null) {
                    this.parseCommandLine((String)object2, true);
                }
                this.updateStartingValues();
            }
            catch (ClParseException clParseException) {
                MessageLog.logError((Object)"CP: Unexpected error on parseCommandLine/updateStartingValues in processPromptOverride");
            }
            return true;
        }
        return false;
    }

    void updateStartingValues() throws ClParseException {
        Enumeration enumeration = this.getChildren();
        String string = null;
        ClNode clNode = null;
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm)) continue;
            ClParm clParm = (ClParm)clNode;
            string = (String)this.m_commandHash.get(clParm.getKwd());
            if (string != null && !string.equals("")) {
                clParm.setStartingValue(string);
                clParm.updateStartingValue(string);
            }
            if (clParm.getPmtCtl() != null) continue;
            clParm.setVisible(true);
        }
    }

    void refresh() {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            ClNode clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm)) continue;
            ((ClParm)clNode).refresh();
        }
        Container container = this.m_panel;
        while (!(container instanceof ClCommandLineDialog)) {
            container = container.getParent();
        }
        ((ClCommandLineDialog)container).getAdvancedButtonPanel().actionPerformed(new ActionEvent(this.m_panel, 0, "Basic"));
        MenuManager menuManager = ((ClCommandLineDialog)container).getViewMenuManager();
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)menuManager.getMenuItem("MAIN_VIEW_ADVANCED");
        jCheckBoxMenuItem.setState(false);
        if (this.hasAdvanced()) {
            ((ClCommandLineDialog)container).getAdvancedButtonPanel().setVisible(true);
            ((ClCommandLineDialog)container).getAdvancedButtonPanel().setAdvanced(true);
            ((ClCommandLineDialog)container).buildNewMenu();
        }
        if (this.m_BackupPmtOvrPgm != null) {
            this.m_PmtOvrPgm = this.m_BackupPmtOvrPgm;
        }
        this.assignFocus();
    }

    void parseCommandLine(String string) throws ClParseException {
        this.parseCommandLine(string, false);
    }

    void parseCommandLine(String string, boolean bl) throws ClParseException {
        block33: {
            if (string == null) break block33;
            boolean bl2 = false;
            String string2 = null;
            while (string != null && !string.equals("")) {
                String string3;
                int n;
                String string4;
                block30: {
                    block31: {
                        block32: {
                            ClParm clParm;
                            boolean bl3;
                            int n2;
                            string = string.trim();
                            int n3 = string.indexOf("(");
                            int n4 = string.indexOf(" ");
                            if (n4 != -1 && n4 < n3 || n3 == -1 || n3 == 0) {
                                int n5;
                                String string5;
                                if (n3 == 0) {
                                    n4 = 0;
                                    int n6 = 0;
                                    for (n2 = 0; n2 < string.length(); ++n2) {
                                        if (string.charAt(n2) == '(') {
                                            ++n6;
                                        } else if (string.charAt(n2) == ')') {
                                            --n6;
                                        }
                                        if (n6 != 0) continue;
                                        if (n2 + 1 == string.length()) {
                                            n4 = -1;
                                            n3 = -1;
                                            break;
                                        }
                                        n4 = string.indexOf(" ", n2 - 1);
                                        n3 = string.indexOf("(", n4);
                                        string5 = string.substring(n4).trim();
                                        if (string5.length() < 1 || string5.charAt(0) != '(') break;
                                        n2 = n3 - 1;
                                    }
                                    if (n6 != 0) {
                                        this.m_panel.displayAS400Message(13);
                                        throw new ClParseException();
                                    }
                                } else if (n4 == -1 && n3 == -1 && (n5 = string.indexOf(")")) != -1) {
                                    this.m_panel.displayAS400Message(13);
                                    throw new ClParseException();
                                }
                                if (bl2) {
                                    if (n4 == -1) {
                                        char[] cArray = new char[]{string2.charAt(string2.length() - 1)};
                                        char[] cArray2 = new char[]{string.charAt(0)};
                                        string5 = new String(cArray);
                                        String string6 = new String(cArray2);
                                        this.m_panel.displayAS400Message(20, (Object)("'" + string5 + "'"), (Object)("'" + string6 + "'"));
                                        throw new ClParseException();
                                    }
                                    this.m_panel.displayAS400Message(44);
                                    throw new ClParseException();
                                }
                                if (n4 != -1) {
                                    String string7 = string;
                                    if (n3 != -1) {
                                        string7 = string.substring(0, n3);
                                        n2 = string7.lastIndexOf(" ");
                                        string7 = string7.substring(0, n2);
                                        string = string.substring(n2 + 1, string.length());
                                        n3 = string.indexOf("(");
                                    }
                                    this.parsePositional(string7);
                                } else if (n3 == -1) {
                                    this.parsePositional(string);
                                }
                            }
                            if (n3 == -1 || n3 == 0) {
                                return;
                            }
                            bl2 = true;
                            string4 = string.substring(0, n3).toUpperCase(Locale.ENGLISH);
                            string = string.substring(n3 + 1, string.length());
                            n2 = string.length();
                            int n7 = 1;
                            boolean bl4 = false;
                            for (n = 0; n < n2; ++n) {
                                char c = string.charAt(n);
                                if (c == '(') {
                                    ++n7;
                                    continue;
                                }
                                if (c != ')' || --n7 != 0) continue;
                                bl4 = true;
                                break;
                            }
                            if (!bl4) {
                                this.m_panel.displayAS400Message(13);
                                throw new ClParseException();
                            }
                            string3 = string.substring(0, n);
                            string3 = string3.trim();
                            while (true) {
                                if (this.m_commandHash.containsKey(string4) && !bl) {
                                    this.m_panel.displayAS400Message(42, (Object)string4);
                                    throw new ClParseException();
                                }
                                if (this.m_parmHash.containsKey(string4)) break block30;
                                if (string4.length() <= 2 || string4.charAt(0) != '?') break block31;
                                if (string4.charAt(1) == '?' || string4.charAt(1) == '*') {
                                    string4 = string4.substring(2, string4.length());
                                    continue;
                                }
                                if (string4.charAt(1) != '<' && string4.charAt(1) != '&' && string4.charAt(1) != '%') break block32;
                                bl3 = false;
                                if (string4.charAt(1) == '&') {
                                    bl3 = true;
                                }
                                if ((clParm = (ClParm)this.m_parmHash.get(string4 = string4.substring(2, string4.length()))) != null) break;
                            }
                            if (!this.m_commandHash.containsKey(string4)) {
                                clParm.setSendDefaultUnlessChanged(true);
                            }
                            if (bl3) {
                                clParm.setPmtCtl("CP111799");
                            }
                            break block30;
                        }
                        this.m_panel.error(6, string4.substring(0, 2));
                        throw new ClParseException();
                    }
                    this.m_panel.displayAS400Message(43, (Object)string4);
                    throw new ClParseException();
                }
                if (!this.m_commandHash.containsKey(string4) || !bl) {
                    this.m_commandHash.put(string4, string3);
                }
                try {
                    string2 = string.substring(0, n + 1);
                    string = string.substring(n + 1, string.length());
                }
                catch (Exception exception) {
                    string = null;
                }
            }
        }
    }

    void parsePositional(String string) throws ClParseException {
        if (this.m_MaxPos == 0) {
            this.m_panel.displayAS400Message(65, new Integer(this.m_MaxPos));
            throw new ClParseException();
        }
        int n = 0;
        while (string != null && !string.equals("")) {
            int n2;
            ++n;
            string = string.trim();
            int n3 = string.indexOf(" ");
            int n4 = string.indexOf("'");
            if (string.indexOf("(") == 0) {
                n2 = 0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == '(') {
                        ++n2;
                    } else if (string.charAt(i) == ')') {
                        --n2;
                    }
                    if (n2 != 0) continue;
                    if (i + 1 == string.length()) {
                        string = string.substring(1, i);
                        n3 = -1;
                    } else {
                        string = string.substring(1, i) + string.substring(i + 1);
                        n3 = string.indexOf(" ", i - 1);
                    }
                    break;
                }
            } else if (n4 != -1 && n4 < n3) {
                n2 = string.indexOf("'", n4 + 1);
                if (n2 > n3) {
                    n3 = string.indexOf(" ", n2);
                } else if (n2 == -1) {
                    this.m_panel.displayAS400Message(14);
                    throw new ClParseException();
                }
            }
            if (n3 != -1) {
                String string2 = string.substring(0, n3);
                if (n > this.m_MaxPos) {
                    this.m_panel.displayAS400Message(65, new Integer(this.m_MaxPos));
                    throw new ClParseException();
                }
                this.addPositionalParameter(n, string2);
                try {
                    string = string.substring(n3 + 1, string.length());
                }
                catch (Exception exception) {
                    string = null;
                }
                continue;
            }
            if (n > this.m_MaxPos) {
                this.m_panel.displayAS400Message(65, new Integer(this.m_MaxPos));
                throw new ClParseException();
            }
            this.addPositionalParameter(n, string);
            string = null;
        }
    }

    void addPositionalParameter(int n, String string) {
        Enumeration enumeration = this.getChildren();
        int n2 = 1;
        while (enumeration.hasMoreElements()) {
            ClNode clNode = (ClNode)enumeration.nextElement();
            if (clNode instanceof ClParm && n2 == n) {
                this.m_commandHash.put(((ClParm)clNode).getKwd(), string);
                return;
            }
            ++n2;
        }
        MessageLog.logError((Object)("CP: Error: Pos parm not found at index " + n));
    }

    boolean verify() {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            ClNode clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm ? !((ClParm)clNode).verify() : clNode instanceof ClDep && !((ClDep)clNode).verify())) continue;
            return false;
        }
        return true;
    }

    String getCLString() {
        return this.getCLString(false);
    }

    String getCLString(boolean bl) {
        String string = this.getCmdName().toUpperCase(Locale.ENGLISH);
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            ClNode clNode = (ClNode)enumeration.nextElement();
            if (!(clNode instanceof ClParm)) continue;
            string = string + ((ClParm)clNode).getCLString(bl);
        }
        return string;
    }

    ClHelpId[] getHelpIds() {
        Vector<ClHelpId> vector = new Vector<ClHelpId>(5);
        if (this.getHlpId() != null) {
            Object object;
            ClHelpId clHelpId = new ClHelpId(this.getHlpId(), this.getHlpPnlGrp(), this.getHlpPnlGrpLib());
            vector.addElement(clHelpId);
            Enumeration enumeration = this.getChildren();
            while (enumeration.hasMoreElements()) {
                ClNode clNode = (ClNode)enumeration.nextElement();
                if (!(clNode instanceof ClParm)) continue;
                object = (ClParm)clNode;
                clHelpId = new ClHelpId(this.getHlpId() + "/" + ((ClParm)object).getKwd(), this.getHlpPnlGrp(), this.getHlpPnlGrpLib());
                vector.addElement(clHelpId);
            }
            object = new ClHelpId[vector.size()];
            vector.copyInto((Object[])object);
            return object;
        }
        return new ClHelpId[0];
    }

    boolean shouldPrompt(ClPmtCtl clPmtCtl) {
        return clPmtCtl.shouldPrompt(this);
    }

    void registerPromptControl(String string, ClParm clParm) {
        ClParm clParm2 = (ClParm)this.m_parmHash.get(string);
        if (clParm2 == null) {
            MessageLog.logError((Object)("CP: Parm " + string + " not found in hashtable."));
            return;
        }
        clParm2.addPromptControl(clParm);
    }

    int getParmType(String string) {
        ClParm clParm = (ClParm)this.m_parmHash.get(string);
        if (clParm == null) {
            MessageLog.logError((Object)("CP: Parm " + string + " not found in hashtable."));
            return 0;
        }
        int n = clParm.getType();
        return n;
    }

    String getParmDft(String string) {
        ClParm clParm = (ClParm)this.m_parmHash.get(string);
        if (clParm == null) {
            MessageLog.logError((Object)("CP: Parm " + string + " not found in hashtable."));
            return null;
        }
        return clParm.getMapToValue(clParm.getCompareDft());
    }

    String getParmValue(String string) {
        ClParm clParm = (ClParm)this.m_parmHash.get(string);
        if (clParm == null) {
            MessageLog.logError((Object)("CP: Parm " + string + " not found in hashtable."));
            return "";
        }
        String string2 = clParm.getStringValue();
        if (string2 != null) {
            string2 = string2.trim();
            string2 = ClSyntax.upperCase(clParm.getType(), string2);
        }
        return string2;
    }

    String getParmCompareValue(String string) {
        ClParm clParm = (ClParm)this.m_parmHash.get(string);
        if (clParm == null) {
            MessageLog.logError((Object)("CP: Parm " + string + " not found in hash"));
            return "";
        }
        String string2 = clParm.getCompareValue();
        return string2;
    }

    String getParmPmtCtlPgm(String string) {
        ClParm clParm = (ClParm)this.m_parmHash.get(string);
        if (clParm == null) {
            MessageLog.logError((Object)("CP: Parm " + string + " not found in hash"));
            return "";
        }
        String string2 = clParm.getPmtCtlPgm();
        return string2;
    }

    ClParm getParm(String string) {
        return (ClParm)this.m_parmHash.get(string);
    }

    void reorderChildren() {
        Vector vector = this.getChildrenVector();
        Enumeration enumeration = this.getChildren();
        ClNode clNode = null;
        Vector vector2 = (Vector)vector.clone();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            clNode = (ClNode)enumeration.nextElement();
            if (clNode instanceof ClParm) {
                int n2 = ((ClParm)clNode).getPosNbr();
                if (n2 != -1) {
                    vector2.setElementAt(clNode, n2 - 1);
                }
            } else {
                vector2.setElementAt(clNode, n);
            }
            ++n;
        }
        this.setChildren(vector2);
    }

    private static String getCopyright() {
        return "(C)Copyright IBM Corp. 1998, 1999";
    }
}

