/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import miworkplace.common.model.IConnection;
import miworkplace.common.model.IRemoteObject;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IResource;

public abstract class RemoteObject
implements IRemoteObject {
    private static final Map<String, IRemoteObject.Type> typeLookupMap;
    protected final IConnection connection;
    protected final IResource file;
    protected String name;
    protected final IRemoteObject.Type type;
    protected IRemoteObject.Attribute attr;
    private String rawCreationDate;
    private String rawChangeDate;
    private boolean childrenLoaded = false;
    private String fRealAttr;
    private String fRealType;

    static {
        IRemoteObject.Type[] types;
        typeLookupMap = new HashMap<String, IRemoteObject.Type>();
        IRemoteObject.Type[] typeArray = types = IRemoteObject.Type.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteObject.Type t = typeArray[n2];
            typeLookupMap.put(t.abbr(), t);
            ++n2;
        }
    }

    public static IRemoteObject.Type getTypeByValue(String value) {
        IRemoteObject.Type t = typeLookupMap.get(value);
        if (t == null) {
            return IRemoteObject.Type.defaultType;
        }
        return t;
    }

    protected RemoteObject(IConnection connection, IResource file, IRemoteObject.Type type, String pRealType, String pRealAttribute) {
        this.connection = connection;
        this.file = file;
        this.type = type;
        this.fRealType = pRealType;
        this.fRealAttr = pRealAttribute;
        this.name = FilenameUtils.getBaseName((String)file.getName());
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public IRemoteObject.Type getType() {
        return this.type;
    }

    @Override
    public IRemoteObject.Attribute getAttribute() {
        return this.attr;
    }

    @Override
    public void setAttribute(IRemoteObject.Attribute attr) {
        this.attr = attr;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.file.getFullPath().toString().substring("RemoteFileSystem".length() + 1 + this.connection.getName().length() + 1);
    }

    @Override
    public boolean areChildrenLoaded() {
        return this.childrenLoaded;
    }

    @Override
    public void setChildrenLoaded(boolean childrenLoaded) {
        this.childrenLoaded = childrenLoaded;
    }

    @Override
    public String escapedPath() {
        Object path = this.getPath();
        path = ((String)path).replaceAll("/", "#");
        path = this.connection.getName() + "-" + (String)path;
        return path;
    }

    @Override
    public String getRawCreationDate() {
        return this.rawCreationDate;
    }

    @Override
    public void setRawCreationDate(String rawCreationDate) {
        this.rawCreationDate = rawCreationDate;
    }

    @Override
    public String getRawChangeDate() {
        return this.rawChangeDate;
    }

    @Override
    public void setRawChangeDate(String rawChangeDate) {
        this.rawChangeDate = rawChangeDate;
    }

    public static String escapedPath(String connection, String path) {
        path = ((String)path).replaceAll("/", "#");
        path = connection + "-" + (String)path;
        return path;
    }

    @Override
    public String getRealAttribute() {
        return this.fRealAttr;
    }

    @Override
    public String getRealType() {
        return this.fRealType;
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.file);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteObject other = (RemoteObject)obj;
        return Objects.equals(this.connection, other.connection) && Objects.equals(this.file, other.file);
    }
}

