/*
 * Decompiled with CFR 0.152.
 */
package miworkplace.common.debug;

import com.remainsoftware.common.util.ServiceUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Hashtable;
import miworkplace.common.debug.Option;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;

public class Debug
implements DebugOptionsListener {
    private static final String BUNDLE_ID = "miworkplace.common";
    private static Debug fInstance = new Debug();
    private DebugOptions fDebugOptions;
    private final ILog log = Platform.getLog(Debug.class);
    public static boolean DEBUG;

    private Debug() {
        this.registerDebugOptionsListener();
    }

    private void registerDebugOptionsListener() {
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", BUNDLE_ID);
        ServiceUtils.registerService(this.getClass(), DebugOptionsListener.class, (Object)this, props);
    }

    public void info(Option pOption, String pMessage) {
        if (this.isOn(pOption)) {
            this.log.info(pMessage);
        }
    }

    public void warn(Option pOption, String pMessage) {
        if (this.isOn(pOption)) {
            this.log.warn(pMessage);
        }
    }

    public void error(Option pOption, String pMessage) {
        if (this.isOn(pOption)) {
            this.log.error(pMessage);
        }
    }

    public void info(Option pOption, String pMessage, Throwable pError) {
        if (this.isOn(pOption)) {
            this.log.info(pMessage, pError);
        }
    }

    public void warn(Option pOption, String pMessage, Throwable pError) {
        if (this.isOn(pOption)) {
            this.log.warn(pMessage, pError);
        }
    }

    public void error(Option pOption, String pMessage, Throwable pError) {
        this.log.error(pMessage, pError);
    }

    public void traceEntry(Option pOption, Object ... pParms) {
        if (this.isOn(pOption)) {
            Exception e = new Exception();
            String className = e.getStackTrace()[1].getClassName();
            String methodName = e.getStackTrace()[1].getMethodName();
            this.log.info(MessageFormat.format("entry: {0}#{1} parms:{2}", className, methodName, pParms == null ? pParms : Arrays.asList(pParms)));
        }
    }

    public void traceExit(Option pOption, Object pResult) {
        if (this.isOn(pOption)) {
            Exception e = new Exception();
            String className = e.getStackTrace()[1].getClassName();
            String methodName = e.getStackTrace()[1].getMethodName();
            this.log.info(MessageFormat.format("exit: {0}#{1} result:{2}", className, methodName, pResult));
        }
    }

    public void optionsChanged(DebugOptions pDebugOptions) {
        this.fDebugOptions = pDebugOptions;
        DEBUG = pDebugOptions.isDebugEnabled();
        this.log.info("MiWorkplace logging changed (debug=" + DEBUG + ")");
    }

    public boolean isOn(Option pOption) {
        return DEBUG && this.fDebugOptions.getBooleanOption(pOption.getMasterSwitch().fullOption(), false) && this.fDebugOptions.getBooleanOption(pOption.fullOption(), false);
    }

    public static Debug getInstance() {
        return fInstance;
    }

    public void error(String pMessage, Throwable pThrowable) {
        Throwable e = pThrowable == null ? new Exception("error generated") : pThrowable;
        this.log.error(pMessage, e);
    }

    public void warning(String pMessage, Throwable pThrowable) {
        Throwable e = pThrowable == null ? new Exception("warning generated") : pThrowable;
        this.log.warn(pMessage, e);
    }

    public void debug(Option pOption, String pString) {
        this.info(pOption, pString);
    }

    public void debug(Option pOption, String pString, Throwable pThrowable) {
        this.info(pOption, pString, pThrowable);
    }
}

